/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.EditorKit;
import org.netbeans.modules.jarpackager.ArchiveDescriptor;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public class ManifestTab
extends JPanel
implements PropertyEditor {
    private JEditorPane manifestPane;
    private JPanel featuresPanel;
    private JComboBox generationComboBox;
    private JLabel generationLabel;
    private JButton generateButton;
    private JLabel manifestTextLabel;
    private JScrollPane jScrollPane1;
    private JPanel generationPanel;
    private JButton loadButton;
    private static File lastManifestFolder = null;
    private Manifest manifest;
    private PropertyChangeSupport support;
    private boolean editorKitInitialized;
    private DefaultComboBoxModel model;
    BasicAttributesGenerator baGen;
    private ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ManifestTab == null ? (class$org$netbeans$modules$jarpackager$ManifestTab = ManifestTab.class$("org.netbeans.modules.jarpackager.ManifestTab")) : class$org$netbeans$modules$jarpackager$ManifestTab));
    public static final String SPECIFIED_BY = new String("Specified-By");
    private boolean isValid = true;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$ManifestTab;

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.manifestPane = new JEditorPane();
        this.featuresPanel = new JPanel();
        this.loadButton = new JButton();
        this.generationPanel = new JPanel();
        this.generationComboBox = new JComboBox();
        this.generateButton = new JButton();
        this.generationLabel = new JLabel();
        this.manifestTextLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jScrollPane1.setPreferredSize(new Dimension(418, 200));
        this.jScrollPane1.setMinimumSize(new Dimension(418, 200));
        this.manifestPane.setMinimumSize(new Dimension(400, 200));
        this.manifestPane.getAccessibleContext().setAccessibleName(this.bundle.getString("ACCN_Manifest"));
        this.manifestPane.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACCD_Manifest"));
        this.manifestPane.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                ManifestTab.this.manifestPaneFocusLost(evt);
            }
        });
        this.manifestPane.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                ManifestTab.this.manifestPaneKeyPressed(evt);
            }

            public void keyReleased(KeyEvent evt) {
                ManifestTab.this.manifestPaneKeyReleased(evt);
            }
        });
        this.manifestPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ManifestTab.this.manifestPanePropertyChange(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.manifestPane);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.featuresPanel.setLayout(new GridBagLayout());
        this.loadButton.setToolTipText(this.bundle.getString("CTL_LoadManifestTip"));
        this.loadButton.setText(this.bundle.getString("CTL_LoadManifest"));
        this.loadButton.setAlignmentY(1.0f);
        this.loadButton.setMnemonic(this.bundle.getString("MNM_LoadManifest").charAt(0));
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManifestTab.this.loadButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.featuresPanel.add((Component)this.loadButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 2.0;
        this.add((Component)this.featuresPanel, gridBagConstraints);
        this.generationPanel.setLayout(new GridBagLayout());
        this.generationPanel.setAlignmentY(1.0f);
        this.generationComboBox.getAccessibleContext().setAccessibleName(this.bundle.getString("ACCN_GenerateList"));
        this.generationComboBox.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACCN_GenerateList"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 8);
        this.generationPanel.add((Component)this.generationComboBox, gridBagConstraints);
        this.generateButton.setToolTipText(this.bundle.getString("CTL_GenerationButtonTip"));
        this.generateButton.setText(this.bundle.getString("CTL_GenerationButton"));
        this.generateButton.setMnemonic(this.bundle.getString("MNM_Generate").charAt(0));
        this.generateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManifestTab.this.generateButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.generationPanel.add((Component)this.generateButton, gridBagConstraints);
        this.generationLabel.setLabelFor(this.generationComboBox);
        this.generationLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/jarpackager/Bundle").getString("CTL_GenerationBorder"));
        this.generationLabel.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.generationPanel.add((Component)this.generationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.generationPanel, gridBagConstraints);
        this.manifestTextLabel.setLabelFor(this.manifestPane);
        this.manifestTextLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/jarpackager/Bundle").getString("CTL_ManifestText"));
        this.manifestTextLabel.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/jarpackager/Bundle").getString("CTL_ManifestTextTip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.manifestTextLabel, gridBagConstraints);
    }

    private void manifestPanePropertyChange(PropertyChangeEvent evt) {
    }

    private void manifestPaneFocusLost(FocusEvent evt) {
        try {
            this.updateValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void manifestPaneKeyPressed(KeyEvent evt) {
        if ((evt.getModifiers() & 8) != 0 || evt.getKeyCode() == 27) {
            this.dispatchEvent(evt);
        }
    }

    private void manifestPaneKeyReleased(KeyEvent evt) {
        this.checkValid();
    }

    private void generateButtonActionPerformed(ActionEvent evt) {
        Generator generator = (Generator)this.generationComboBox.getSelectedItem();
        if (generator == null) {
            return;
        }
        generator.generate(this.manifest);
        this.setValue(this.manifest);
        this.checkValid();
        this.manifestPane.requestFocus();
    }

    private void loadButtonActionPerformed(ActionEvent evt) {
        File f;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new MfFileFilter());
        if (lastManifestFolder == null) {
            try {
                File defDir = new File(System.getProperty("user.home"));
                if (Utilities.isUnix()) {
                    lastManifestFolder = defDir;
                } else if (Utilities.isWindows()) {
                    while ((defDir = defDir.getParentFile()) != null && defDir.getParentFile() != null) {
                    }
                    if (defDir != null) {
                        lastManifestFolder = defDir;
                    }
                }
            }
            catch (Exception ex) {
                lastManifestFolder = null;
            }
        }
        if (lastManifestFolder != null) {
            chooser.setCurrentDirectory(lastManifestFolder);
        }
        chooser.setDialogTitle(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ManifestTab == null ? (class$org$netbeans$modules$jarpackager$ManifestTab = ManifestTab.class$("org.netbeans.modules.jarpackager.ManifestTab")) : class$org$netbeans$modules$jarpackager$ManifestTab)).getString("CTL_LoadManifestTitle"));
        if (chooser.showDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ManifestTab == null ? (class$org$netbeans$modules$jarpackager$ManifestTab = ManifestTab.class$("org.netbeans.modules.jarpackager.ManifestTab")) : class$org$netbeans$modules$jarpackager$ManifestTab)).getString("CTL_BrowseOk")) == 0 && (f = chooser.getSelectedFile()) != null) {
            lastManifestFolder = chooser.getCurrentDirectory();
            try {
                FileReader fr = new FileReader(f);
                try {
                    Manifest mf = ManifestTab.readManifest(fr);
                    this.setValue(mf);
                    Object var7_9 = null;
                    this.checkValid();
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    this.checkValid();
                    throw throwable;
                }
                {
                }
            }
            catch (IOException exc) {
                ErrorManager errMgr = ErrorManager.getDefault();
                String annot = NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ManifestTab == null ? (class$org$netbeans$modules$jarpackager$ManifestTab = ManifestTab.class$("org.netbeans.modules.jarpackager.ManifestTab")) : class$org$netbeans$modules$jarpackager$ManifestTab)).getString("FMT_LoadManifestError");
                String err = MessageFormat.format(annot, exc.getMessage());
                errMgr.notify(65536, errMgr.annotate((Throwable)exc, err));
            }
        }
    }

    public ManifestTab() {
        this.initComponents();
        this.additionalInitialization();
        HelpCtx.setHelpIDString((JComponent)this, (String)(class$org$netbeans$modules$jarpackager$ManifestTab == null ? (class$org$netbeans$modules$jarpackager$ManifestTab = ManifestTab.class$("org.netbeans.modules.jarpackager.ManifestTab")) : class$org$netbeans$modules$jarpackager$ManifestTab).getName());
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("CTL_ManifestTip"));
    }

    public void setJarContentFile(String jarContentFile) {
        if (this.baGen != null) {
            this.baGen.setJarContentFile(jarContentFile);
        }
    }

    private void additionalInitialization() {
        this.model = new DefaultComboBoxModel();
        this.baGen = new BasicAttributesGenerator();
        this.model.addElement(this.baGen);
        this.generationComboBox.setModel(this.model);
        this.initContentType();
        this.manifestTextLabel.setDisplayedMnemonic(this.manifestTextLabel.getText().charAt(0));
        this.generationLabel.setDisplayedMnemonic(this.generationLabel.getText().charAt(0));
    }

    public void readSettings(ArchiveDescriptor content) throws IOException {
        this.doSetValue(content.getManifest());
        this.updateGui(this.manifest);
    }

    public void storeSettings(ArchiveDescriptor content) throws IOException {
        this.updateValue();
        content.setManifest(this.manifest);
        this.support().firePropertyChange("", null, null);
    }

    public Component getComponent() {
        return this;
    }

    public String getDisplayName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ManifestTab == null ? (class$org$netbeans$modules$jarpackager$ManifestTab = ManifestTab.class$("org.netbeans.modules.jarpackager.ManifestTab")) : class$org$netbeans$modules$jarpackager$ManifestTab)).getString("CTL_ManifestTab");
    }

    public String getShortDescription() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ManifestTab == null ? (class$org$netbeans$modules$jarpackager$ManifestTab = ManifestTab.class$("org.netbeans.modules.jarpackager.ManifestTab")) : class$org$netbeans$modules$jarpackager$ManifestTab)).getString("HINT_ManifestTab");
    }

    public String getJavaInitializationString() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return this;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics p1, Rectangle p2) {
    }

    public String[] getTags() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener pchl) {
        this.support().addPropertyChangeListener(pchl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pchl) {
        this.support().addPropertyChangeListener(pchl);
    }

    public void setValue(Object value) {
        try {
            this.doSetValue(value);
            this.updateGui(value);
        }
        catch (IOException exc) {
            ErrorManager errMgr = ErrorManager.getDefault();
            String annot = NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ManifestTab == null ? (class$org$netbeans$modules$jarpackager$ManifestTab = ManifestTab.class$("org.netbeans.modules.jarpackager.ManifestTab")) : class$org$netbeans$modules$jarpackager$ManifestTab)).getString("FMT_CanNotReadManifest");
            String err = MessageFormat.format(annot, exc.getMessage());
            errMgr.notify(65536, errMgr.annotate((Throwable)exc, err));
        }
    }

    public Object getValue() {
        if (ManifestTab.ensureVersionAttribute(this.manifest)) {
            try {
                this.updateGui(this.manifest);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.manifest;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    public String getAsText() {
        Integer mainAttrs = new Integer(this.manifest.getMainAttributes().size());
        Integer entries = new Integer(this.manifest.getEntries().size());
        return MessageFormat.format(this.bundle.getString("FMT_ManifestSize"), mainAttrs, entries);
    }

    private PropertyChangeSupport support() {
        if (this.support == null) {
            this.support = new PropertyChangeSupport(this);
        }
        return this.support;
    }

    void updateValue() throws IOException {
        this.doSetValue(this.makeManifest());
    }

    public boolean isValid() {
        return this.isValid;
    }

    private boolean checkValid() {
        boolean nowValid = true;
        try {
            this.makeManifest();
        }
        catch (IOException ex) {
            nowValid = false;
        }
        if (this.isValid != nowValid) {
            this.isValid = nowValid;
            this.support().firePropertyChange("propertyValueValid", !this.isValid, this.isValid);
        }
        return this.isValid;
    }

    private Manifest makeManifest() throws IOException {
        String panelString = this.manifestPane.getText();
        return ManifestTab.readManifest(new StringReader(panelString));
    }

    static Manifest readManifest(InputStream stream) throws IOException {
        return ManifestTab.readManifest(new InputStreamReader(stream));
    }

    static Manifest readManifest(Reader reader) throws IOException {
        Manifest man;
        TerminateLineInputStream str = new TerminateLineInputStream(new ReaderInputStream(reader));
        try {
            try {
                man = new Manifest(str);
                ((InputStream)str).close();
            }
            catch (DoubleByteCharacterReadException ex) {
                throw new IOException(ex.getMessage());
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            ((InputStream)str).close();
            throw throwable;
        }
        ((InputStream)str).close();
        return man;
    }

    void doSetValue(Object value) {
        if (!(value instanceof Manifest)) {
            throw new IllegalArgumentException(value.toString());
        }
        this.manifest = (Manifest)value;
        ManifestTab.ensureVersionAttribute(this.manifest);
        this.support().firePropertyChange("", null, null);
    }

    void updateGui(Object value) throws IOException {
        Manifest manifest = (Manifest)value;
        this.manifestPane.setText("");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            manifest.write(baos);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            baos.close();
            throw throwable;
        }
        baos.close();
        this.manifestPane.setText(baos.toString().trim());
    }

    void initContentType() {
        EditorKit kit = this.manifestPane.getEditorKitForContentType("text/plain");
        if (kit != null) {
            String content = this.manifestPane.getText();
            this.manifestPane.setContentType("text/plain");
            this.manifestPane.setEditorKit(kit);
            this.manifestPane.setText(content);
        }
    }

    static boolean ensureVersionAttribute(Manifest mf) {
        boolean changed = false;
        Attributes attrs = mf.getMainAttributes();
        if (attrs.size() > 0 && attrs.getValue(Attributes.Name.MANIFEST_VERSION) == null && attrs.getValue(Attributes.Name.SIGNATURE_VERSION) == null) {
            attrs.put(Attributes.Name.MANIFEST_VERSION, "Version 1.0");
            changed = true;
        }
        return changed;
    }

    static void completeMainAttributes(Attributes mainAttr, String jarContentFile) {
        Attributes.Name cbAttr;
        if (mainAttr.getValue(Attributes.Name.MANIFEST_VERSION) == null) {
            mainAttr.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        }
        if (mainAttr.getValue(cbAttr = new Attributes.Name("Created-By")) == null) {
            mainAttr.put(cbAttr, NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ManifestTab == null ? (class$org$netbeans$modules$jarpackager$ManifestTab = ManifestTab.class$("org.netbeans.modules.jarpackager.ManifestTab")) : class$org$netbeans$modules$jarpackager$ManifestTab)).getString("CTL_IDEName"));
        }
        if (jarContentFile != null) {
            Attributes.Name sbAttr;
            boolean hasDouble = false;
            int i = 0;
            while (i < jarContentFile.length()) {
                if (jarContentFile.charAt(i) > '\u00ff') {
                    hasDouble = true;
                    break;
                }
                ++i;
            }
            if (!hasDouble && mainAttr.getValue(sbAttr = new Attributes.Name(SPECIFIED_BY)) == null) {
                mainAttr.put(sbAttr, jarContentFile);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ReaderInputStream
    extends InputStream {
        Reader reader;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$ManifestTab;

        ReaderInputStream(Reader rdr) {
            this.reader = rdr;
        }

        public int read() throws IOException {
            int i = this.reader.read();
            if (i < 0) {
                return i;
            }
            if (i <= 255) {
                return i;
            }
            throw new DoubleByteCharacterReadException(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ManifestTab == null ? (class$org$netbeans$modules$jarpackager$ManifestTab = ReaderInputStream.class$("org.netbeans.modules.jarpackager.ManifestTab")) : class$org$netbeans$modules$jarpackager$ManifestTab)).getString("MSG_DoubleByte"), (char)i);
        }

        public void close() throws IOException {
            this.reader.close();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static class DoubleByteCharacterReadException
    extends RuntimeException {
        char dbChar;

        DoubleByteCharacterReadException(String msg, char c) {
            super(msg);
            this.dbChar = c;
        }

        char getChar() {
            return this.dbChar;
        }
    }

    static class TerminateLineInputStream
    extends FilterInputStream {
        byte last = 0;
        boolean terminated = true;

        TerminateLineInputStream(InputStream in) {
            super(in);
        }

        public int read() throws IOException {
            int val = this.in.read();
            if (val < 0) {
                if (this.last == 10 || this.terminated) {
                    return val;
                }
                this.terminated = true;
                return 10;
            }
            this.terminated = false;
            this.last = (byte)val;
            return val;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int size = this.in.read(b, off, len);
            if (size < 0) {
                if (this.last == 10 || this.terminated) {
                    return size;
                }
                b[off] = 10;
                this.terminated = true;
                return 1;
            }
            if (size > 0) {
                this.terminated = false;
                this.last = b[off + size - 1];
            }
            return size;
        }
    }

    static final class BasicAttributesGenerator
    implements Generator {
        private String jarContentFile;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$ManifestTab;

        BasicAttributesGenerator() {
        }

        public void setJarContentFile(String jarContentFile) {
            this.jarContentFile = jarContentFile;
        }

        public void generate(Manifest manifest) {
            ManifestTab.completeMainAttributes(manifest.getMainAttributes(), this.jarContentFile);
        }

        public String getDisplayName() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ManifestTab == null ? (class$org$netbeans$modules$jarpackager$ManifestTab = BasicAttributesGenerator.class$("org.netbeans.modules.jarpackager.ManifestTab")) : class$org$netbeans$modules$jarpackager$ManifestTab)).getString("CTL_BasicAttributes");
        }

        public String getShortDescription() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ManifestTab == null ? (class$org$netbeans$modules$jarpackager$ManifestTab = BasicAttributesGenerator.class$("org.netbeans.modules.jarpackager.ManifestTab")) : class$org$netbeans$modules$jarpackager$ManifestTab)).getString("CTL_BasicAttributesTip");
        }

        public String toString() {
            return this.getDisplayName();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static interface Generator {
        public void generate(Manifest var1);

        public String getDisplayName();

        public String getShortDescription();
    }

    static final class MfFileFilter
    extends FileFilter {
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$ManifestTab;

        MfFileFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".mf") || f.getName().endsWith(".txt") || f.getName().endsWith(".MF");
        }

        public String getDescription() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ManifestTab == null ? (class$org$netbeans$modules$jarpackager$ManifestTab = MfFileFilter.class$("org.netbeans.modules.jarpackager.ManifestTab")) : class$org$netbeans$modules$jarpackager$ManifestTab)).getString("CTL_MfFiles");
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

