/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.netbeans.modules.jarpackager.FileObjectFilter;
import org.netbeans.modules.jarpackager.util.Assert;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class REFilter
implements FileObjectFilter {
    protected transient RE matcher;
    protected String pattern;
    protected boolean negative;
    static final long serialVersionUID = -6746916584711803738L;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$REFilter;

    public REFilter() {
        try {
            this.setPattern("");
        }
        catch (RESyntaxException ex) {
            Assert.test(false, "this should never happen");
        }
    }

    public REFilter(String pattern) throws RESyntaxException {
        this.setPattern(pattern);
    }

    public void setPattern(String pattern) throws RESyntaxException {
        if (pattern == null) {
            pattern = "";
        }
        this.matcher = new RE(pattern);
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean accept(FileObject fo) {
        if (this.matcher == null) {
            return !this.negative;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(fo.getName());
        buf.append(".");
        buf.append(fo.getExt());
        boolean result = this.matcher.match(buf.toString());
        return this.negative ? !result : result;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public void setNegative(boolean negative) {
        this.negative = negative;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.setPattern(this.pattern);
        }
        catch (RESyntaxException exc) {
            throw new IOException();
        }
    }

    public String toString() {
        return this.pattern;
    }

    public String getSummary() {
        if (this.negative) {
            return this.pattern + " (" + NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$REFilter == null ? (class$org$netbeans$modules$jarpackager$REFilter = REFilter.class$("org.netbeans.modules.jarpackager.REFilter")) : class$org$netbeans$modules$jarpackager$REFilter)).getString("CTL_Negative") + ")";
        }
        return this.pattern;
    }

    public static boolean checkRegExp(String expPattern) {
        try {
            RE matcher = new RE(expPattern);
        }
        catch (RESyntaxException exc) {
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof REFilter)) {
            return false;
        }
        REFilter other = (REFilter)obj;
        if (this.pattern == null && other.pattern != null) {
            return false;
        }
        if (this.pattern != null && !this.pattern.equals(other.pattern)) {
            return false;
        }
        return this.negative == other.negative;
    }

    public int hashCode() {
        return this.pattern == null ? 0 : this.pattern.hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

