/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager.filesystem;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.JarCreator;
import org.openide.ErrorManager;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class WriteableJarFileSystem
extends MultiFileSystem
implements PropertyChangeListener,
FileSystem.Status,
FileSystem.AtomicAction {
    static final long serialVersionUID = -7096247660760549348L;
    private FileSystem cacheFileSystem;
    private JarFileSystem jarFileSystem;
    private static final MessageFormat[] MESSAGES = new MessageFormat[2];
    private File cacheDir;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$filesystem$UpdateWritableJarFileSystemAction;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$filesystem$WriteableJarFileSystem;

    public WriteableJarFileSystem() {
        super(new FileSystem[1]);
        this.addPropertyChangeListener(this);
    }

    public FileSystem getCacheFileSystem() {
        return this.cacheFileSystem;
    }

    public void setCacheFileSystem(FileSystem cacheFileSystem) {
        FileSystem oldCacheFileSystem;
        WriteableJarFileSystem writeableJarFileSystem = this;
        synchronized (writeableJarFileSystem) {
            oldCacheFileSystem = this.cacheFileSystem;
            this.cacheFileSystem = cacheFileSystem;
            if (cacheFileSystem != null) {
                cacheFileSystem.addPropertyChangeListener((PropertyChangeListener)this);
            }
            if (oldCacheFileSystem != null) {
                oldCacheFileSystem.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
        this.firePropertyChange("cacheFileSystem", oldCacheFileSystem, cacheFileSystem);
    }

    public File getJarFile() {
        JarFileSystem fs = this.jarFileSystem;
        return fs == null ? null : fs.getJarFile();
    }

    public void setJarFile(File jarFile) throws PropertyVetoException, IOException {
        File old = this.getJarFile();
        WriteableJarFileSystem writeableJarFileSystem = this;
        synchronized (writeableJarFileSystem) {
            JarFileSystem fs = this.jarFileSystem;
            if (fs == null) {
                fs = new JarFileSystem();
            }
            fs.setJarFile(jarFile);
            this.jarFileSystem = fs;
            if (this.cacheFileSystem == null) {
                FileSystem temp = this.createTempFileSystem();
                temp.addPropertyChangeListener((PropertyChangeListener)this);
                this.cacheFileSystem = temp;
            }
        }
        this.firePropertyChange("jarFile", old, jarFile);
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if ("cacheFileSystem".equals(ev.getPropertyName()) || "jarFile".equals(ev.getPropertyName())) {
            FileSystem[] arr = null;
            arr = this.cacheFileSystem != null && this.jarFileSystem != null ? new FileSystem[]{this.cacheFileSystem, this.jarFileSystem} : (this.cacheFileSystem != null ? new FileSystem[]{this.cacheFileSystem} : new FileSystem[]{new LocalFileSystem(), this.jarFileSystem});
            if (arr != null) {
                this.setDelegates(arr);
            }
        }
        this.getRoot().refresh(true);
        if (!"systemName".equals(ev.getPropertyName()) && ev.getSource() != this) {
            this.resetSystemName();
        }
    }

    private void resetSystemName() {
        try {
            if (this.cacheFileSystem == null || this.jarFileSystem == null) {
                this.setSystemName("");
                return;
            }
            StringBuffer b = new StringBuffer();
            b.append(this.cacheFileSystem.getSystemName());
            b.append(this.jarFileSystem.getSystemName());
            this.setSystemName(b.toString());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public String getDisplayName() {
        MessageFormat mf = new MessageFormat(WriteableJarFileSystem.getString0("FMT_DisplayName"));
        Object[] param = new Object[]{this.jarFileSystem != null ? this.jarFileSystem.getDisplayName() : WriteableJarFileSystem.getString0("LAB_Error"), this.cacheFileSystem != null ? this.cacheFileSystem.getSystemName() : WriteableJarFileSystem.getString0("LAB_Error")};
        return mf.format(param);
    }

    public FileSystem.Status getStatus() {
        return this;
    }

    public String annotateName(String name, Set files) {
        Iterator it = files.iterator();
        int inCache = 1;
        while (it.hasNext()) {
            FileObject fo = (FileObject)it.next();
            if (fo.isRoot() || this.findSystem(fo) != this.cacheFileSystem) continue;
            inCache = 0;
            break;
        }
        return this.getMessage(inCache).format(new Object[]{name});
    }

    public Image annotateIcon(Image icon, int iconType, Set files) {
        return icon;
    }

    protected void notifyMigration(FileObject fo) {
        this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, fo, false, true));
    }

    private MessageFormat getMessage(int msgIndx) {
        if (MESSAGES[msgIndx] == null) {
            WriteableJarFileSystem.MESSAGES[msgIndx] = new MessageFormat(WriteableJarFileSystem.getString0("MSG_FS_" + msgIndx));
        }
        return MESSAGES[msgIndx];
    }

    private boolean jarContentNeedsUpdate() {
        FileSystem fs = this.getCacheFileSystem();
        if (fs == null) {
            return false;
        }
        Enumeration enumeration = fs.getRoot().getChildren(true);
        while (enumeration.hasMoreElements()) {
            FileObject fo1 = (FileObject)enumeration.nextElement();
            if (this.jarFileSystem == null) {
                return true;
            }
            FileObject fo2 = this.jarFileSystem.findResource(fo1.getPath());
            if (fo2 == null) {
                return true;
            }
            if (!fo1.lastModified().after(fo2.lastModified())) continue;
            return true;
        }
        return false;
    }

    private File createNewJar() throws IOException {
        File f = this.jarFileSystem.getJarFile();
        File newFile = File.createTempFile("tmpJarFile" + Math.random(), "jar");
        newFile.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(newFile);
        JarContent content = new JarContent(JarContent.ALL);
        content.addDataObject(DataObject.find((FileObject)this.getRoot()));
        JarCreator creator = new JarCreator(content);
        creator.createJar(fos, newFile);
        return newFile;
    }

    private void swapToNewJarFile(File newJar) throws IOException {
        try {
            JarFileSystem jfs = this.jarFileSystem;
            if (jfs == null) {
                return;
            }
            File oldJar = jfs.getJarFile();
            jfs.removeNotify();
            if (oldJar != null && !oldJar.delete()) {
                throw new IOException("Cannot delete old jar file");
            }
            FileInputStream fis = new FileInputStream(newJar);
            FileOutputStream fos = new FileOutputStream(oldJar);
            FileUtil.copy((InputStream)fis, (OutputStream)fos);
            jfs.setJarFile(oldJar);
            fis.close();
            fos.close();
            newJar.delete();
            jfs.addNotify();
            this.getRoot().refresh(true);
        }
        catch (PropertyVetoException x) {
            ErrorManager.getDefault().notify((Throwable)x);
        }
    }

    private FileSystem createTempFileSystem() {
        File tmp;
        String pref = "WJFS" + String.valueOf(this.hashCode());
        try {
            tmp = File.createTempFile(pref, null);
            tmp.delete();
            tmp.mkdirs();
        }
        catch (IOException ex) {
            tmp = null;
        }
        LocalFileSystem fs = new LocalFileSystem();
        try {
            if (tmp != null) {
                fs.setRootDirectory(tmp);
            }
        }
        catch (PropertyVetoException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        return fs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void clearBaseFileSystem() {
        FileSystem fs = this.getCacheFileSystem();
        if (fs == null) {
            return;
        }
        JarFileSystem jar = this.jarFileSystem;
        if (jar == null) {
            return;
        }
        Enumeration enumeration = fs.getRoot().getChildren(true);
        while (enumeration.hasMoreElements()) {
            Object var10_9;
            boolean delete;
            FileObject fo1 = (FileObject)enumeration.nextElement();
            FileObject fo2 = jar.findResource(fo1.getPath());
            if (fo2 == null || !(delete = fo1.lastModified().before(fo2.lastModified()))) continue;
            FileLock lock = null;
            try {
                try {
                    lock = fo1.lock();
                    fo1.delete(lock);
                }
                catch (IOException x) {
                    ErrorManager.getDefault().notify((Throwable)x);
                    var10_9 = null;
                    lock.releaseLock();
                    continue;
                }
                var10_9 = null;
            }
            catch (Throwable throwable) {
                var10_9 = null;
                lock.releaseLock();
                throw throwable;
            }
            lock.releaseLock();
        }
        return;
    }

    public void updateJarFileContent() {
        try {
            this.runAtomicAction(this);
        }
        catch (IOException x) {
            ErrorManager.getDefault().notify((Throwable)x);
        }
    }

    public void run() throws IOException {
        if (this.jarContentNeedsUpdate()) {
            File f = this.createNewJar();
            this.swapToNewJarFile(f);
            this.clearBaseFileSystem();
            this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, true, true));
        }
    }

    public void prepareEnvironment(FileSystem.Environment env) throws EnvironmentNotSupportedException {
        this.cacheFileSystem.prepareEnvironment(env);
        if (this.jarFileSystem != null) {
            this.jarFileSystem.prepareEnvironment(env);
        }
    }

    public SystemAction[] getActions(Set files) {
        SystemAction[] arr = super.getActions(files);
        SystemAction[] a1 = new SystemAction[arr.length + 1];
        a1[0] = SystemAction.get((Class)(class$org$netbeans$modules$jarpackager$filesystem$UpdateWritableJarFileSystemAction == null ? (class$org$netbeans$modules$jarpackager$filesystem$UpdateWritableJarFileSystemAction = WriteableJarFileSystem.class$("org.netbeans.modules.jarpackager.filesystem.UpdateWritableJarFileSystemAction")) : class$org$netbeans$modules$jarpackager$filesystem$UpdateWritableJarFileSystemAction));
        System.arraycopy(arr, 0, a1, 1, arr.length);
        return a1;
    }

    private static final String getString0(String key) {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$filesystem$WriteableJarFileSystem == null ? (class$org$netbeans$modules$jarpackager$filesystem$WriteableJarFileSystem = WriteableJarFileSystem.class$("org.netbeans.modules.jarpackager.filesystem.WriteableJarFileSystem")) : class$org$netbeans$modules$jarpackager$filesystem$WriteableJarFileSystem)).getString(key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

