/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager.util;

import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.openide.util.Utilities;

public class BadgeIconCache {
    private Map badges = new HashMap();
    private Map icons = new WeakHashMap();
    private String baseName;

    public BadgeIconCache(String base) {
        this.baseName = base;
    }

    public synchronized void registerBadge(String icon, int key, int x, int y) {
        this.badges.put(new Integer(key), new BadgeID(icon, key, x, y));
    }

    public Image getIcon(Image base, int key) {
        Object icon = this.icons.get(new Integer(key));
        if (icon != null) {
            return (Image)icon;
        }
        Image baseImage = Utilities.loadImage((String)(this.baseName + ".gif"));
        return this.createCompositeImage(baseImage, key);
    }

    private Image createCompositeImage(Image baseImage, int key) {
        if (key == 0) {
            return baseImage;
        }
        int bit = 1;
        int left = key;
        while (left != 0) {
            if ((left & bit) != 0) {
                left &= ~bit;
                BadgeID bn = (BadgeID)this.badges.get(new Integer(bit));
                if (bn != null) {
                    baseImage = BadgeIconCache.addBadge(baseImage, bn.iconName, bn.x, bn.y);
                }
            }
            bit <<= 1;
        }
        this.icons.put(new Integer(key), baseImage);
        return baseImage;
    }

    public static Image addBadge(Image base, String badgeName, int x, int y) {
        Image badge = Utilities.loadImage((String)(badgeName + ".gif"));
        if (badge == null) {
            System.err.println("[Badging] Badge " + badgeName + " cannot be loaded");
        } else {
            base = Utilities.mergeImages((Image)base, (Image)badge, (int)x, (int)y);
        }
        return base;
    }

    static class BadgeID {
        String iconName;
        int x;
        int y;
        int key;

        BadgeID(String icon, int key, int x, int y) {
            this.iconName = icon;
            this.key = key;
            this.x = x;
            this.y = y;
        }
    }
}

