/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class ForwardizeKey {
    private JComponent component;
    private Component whereto;
    private int keycode;
    private int keymodifier;

    public ForwardizeKey(JComponent comp, int keycode, int keymodifier, Component whereto) {
        this.component = comp;
        this.whereto = whereto;
        this.keycode = keycode;
        this.keymodifier = keymodifier;
        this.initMaps();
    }

    protected void initMaps() {
        KeyStroke keystroke = KeyStroke.getKeyStroke(this.keycode, this.keymodifier);
        InputMap im = this.component.getInputMap(1);
        ActionMap am = this.component.getActionMap();
        Object prevBinding = im.get(keystroke);
        Action prevAction = null;
        if (prevBinding != null) {
            prevAction = am.get(prevBinding);
            String actionName = "passOn" + KeyEvent.getKeyText(this.keycode);
            im.put(keystroke, actionName);
            am.put(actionName, new PassOnKey(prevAction));
        } else {
            this.component.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent evt) {
                    if (evt.getKeyCode() == ForwardizeKey.this.keycode && evt.getModifiers() == ForwardizeKey.this.keymodifier && ForwardizeKey.this.canPass(ForwardizeKey.this.component)) {
                        ForwardizeKey.this.passKey();
                    }
                }
            });
        }
    }

    protected boolean canPass(JComponent component) {
        return true;
    }

    private void passKey() {
        this.whereto.requestFocus();
        try {
            Thread.currentThread();
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.whereto.dispatchEvent(new KeyEvent(this.whereto, 401, System.currentTimeMillis(), this.keymodifier, this.keycode));
    }

    class PassOnKey
    extends AbstractAction {
        private Action prevAction;
        private Action newAction;

        public PassOnKey(Action prevAction) {
            this.prevAction = prevAction;
        }

        public void actionPerformed(ActionEvent ae) {
            if (ForwardizeKey.this.canPass(ForwardizeKey.this.component)) {
                ForwardizeKey.this.passKey();
            } else if (this.prevAction != null) {
                this.prevAction.actionPerformed(ae);
            }
        }
    }
}

