/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager.util;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.JarFile;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.options.JarPackagerOption;
import org.netbeans.modules.jarpackager.util.JarUtils;
import org.netbeans.modules.jarpackager.util.ProgressListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class JarInspector {
    private static MessageFormat progressInfo;
    private static final String META_INF_DIR = "META-INF";
    private HashSet listeners;
    private File archiveFile;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$util$JarInspector;

    public JarInspector(File archiveFile) {
        this.archiveFile = archiveFile;
    }

    public JarContent createContent() throws IOException, PropertyVetoException {
        JarFile jarFile = new JarFile(this.archiveFile);
        long itemCount = jarFile.size();
        JarContent result = new JarContent();
        JarInspector.initializeFromOptions(result);
        this.fireProgressEvent(0, "MSG_ObtainingManifest");
        result.setManifest(jarFile.getManifest());
        jarFile.close();
        jarFile = null;
        result.setTargetFile(this.archiveFile);
        result.setFilter(JarContent.ALL);
        this.fireProgressEvent(0, "MSG_AddingToRepository");
        FileSystem jarFs = JarUtils.addJarFSToRepository(this.archiveFile, false);
        FileObject curFo = null;
        long counter = 0L;
        Enumeration enumeration = jarFs.getRoot().getChildren(false);
        while (enumeration.hasMoreElements()) {
            block4: {
                curFo = (FileObject)enumeration.nextElement();
                try {
                    if (!META_INF_DIR.equals(curFo.getName())) {
                        result.putFile(DataObject.find((FileObject)curFo).getPrimaryFile());
                    }
                }
                catch (DataObjectNotFoundException exc) {
                    if (System.getProperty("netbeans.debug.exceptions") == null) break block4;
                    exc.printStackTrace();
                }
            }
            this.fireProgressEvent((int)(counter * 100L / itemCount), JarInspector.progressInfo().format(new Object[]{curFo.getName()}));
            ++counter;
        }
        return result;
    }

    public synchronized void addProgressListener(ProgressListener pl) {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(pl);
    }

    public synchronized void removeProgressListener(ProgressListener pl) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(pl);
    }

    protected void fireProgressEvent(int percent, String description) {
        HashSet cloned;
        if (this.listeners == null) {
            return;
        }
        JarInspector jarInspector = this;
        synchronized (jarInspector) {
            cloned = (HashSet)this.listeners.clone();
        }
        Iterator iter = cloned.iterator();
        while (iter.hasNext()) {
            ((ProgressListener)iter.next()).progress(percent, description);
        }
    }

    private static void initializeFromOptions(JarContent jc) {
        JarPackagerOption rootOption = JarPackagerOption.singleton();
        jc.setCompressionLevel(rootOption.getCompressionLevel());
        jc.setManifestFileList(rootOption.isManifestFileList());
        jc.setMainAttributes(rootOption.isMainAttributes());
    }

    private static MessageFormat progressInfo() {
        if (progressInfo == null) {
            progressInfo = new MessageFormat(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$util$JarInspector == null ? (class$org$netbeans$modules$jarpackager$util$JarInspector = JarInspector.class$("org.netbeans.modules.jarpackager.util.JarInspector")) : class$org$netbeans$modules$jarpackager$util$JarInspector)).getString("FMT_ProgressInfo"));
        }
        return progressInfo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

