/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager.util;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import org.netbeans.modules.jarpackager.ArchiveDescriptor;
import org.netbeans.modules.jarpackager.ContentMember;
import org.netbeans.modules.jarpackager.ContentMemberList;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.JarDataObject;
import org.netbeans.modules.jarpackager.options.JarPackagerOption;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.cookies.CompilerCookie;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;

public final class JarUtils {
    public static final String MANIFEST_VERSION = "1.0";
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarDataObject;

    private JarUtils() {
    }

    public static boolean canAdd(ArchiveDescriptor ad, Node[] nodes, String targetName) {
        if (nodes.length == 0) {
            return false;
        }
        Node parent = null;
        int i = 0;
        while (i < nodes.length) {
            parent = nodes[i].getParentNode();
            if (parent != null && parent.getCookie(class$org$openide$loaders$DataFolder == null ? JarUtils.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder) == null && nodes[i].getCookie(class$org$openide$loaders$DataFolder == null ? JarUtils.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder) == null) {
                return false;
            }
            ++i;
        }
        DataObject curDo = null;
        Object curFolder = null;
        File targetFile = targetName == null ? null : new File(targetName);
        FileSystem curFs = null;
        int i2 = 0;
        while (i2 < nodes.length) {
            curDo = (DataObject)nodes[i2].getCookie(class$org$openide$loaders$DataObject == null ? JarUtils.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (curDo != null) {
                if (curDo instanceof JarDataObject && JarUtils.isEqual(targetFile, NbClassPath.toFile((FileObject)curDo.getPrimaryFile()))) {
                    return false;
                }
                try {
                    curFs = curDo.getPrimaryFile().getFileSystem();
                }
                catch (FileStateInvalidException exc) {
                    return false;
                }
                if (curFs instanceof JarFileSystem && JarUtils.isEqual(targetFile, ((JarFileSystem)curFs).getJarFile())) {
                    return false;
                }
            } else {
                return false;
            }
            ++i2;
        }
        return true;
    }

    private static boolean isEqual(File file1, File file2) {
        int index2;
        if (file1 == null) {
            return file2 == null;
        }
        if (file2 == null) {
            return file1 == null;
        }
        String name1 = file1.getPath();
        String name2 = file2.getPath();
        int index1 = name1.lastIndexOf(46);
        if (index1 < 0) {
            index1 = name1.length();
        }
        if ((index2 = name2.lastIndexOf(46)) < 0) {
            index2 = name2.length();
        }
        return new File(name1.substring(0, index1)).equals(new File(name2.substring(0, index2)));
    }

    public static void addNodes(ArchiveDescriptor ad, Node[] nodes) {
        DataObject curDo = null;
        ContentMemberList members = ad.getContentList();
        int i = 0;
        while (i < nodes.length) {
            curDo = (DataObject)nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? JarUtils.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (curDo != null) {
                if (curDo.getNodeDelegate().getDisplayName().length() == 0) {
                    curDo.getNodeDelegate().setDisplayName(nodes[i].getDisplayName());
                }
            } else {
                throw new NullPointerException("Added node doesn't support DataObject cookie");
            }
            members.addMember(curDo);
            ++i;
        }
    }

    public static void removeNodes(ArchiveDescriptor ad, Node[] nodes) {
        ContentMemberList members = ad.getContentList();
        Object curDo = null;
        int i = 0;
        while (i < nodes.length) {
            members.removeMember((DataObject)nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? JarUtils.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject));
            ++i;
        }
    }

    public static FileSystem addJarFSToRepository(File rootFile, boolean writeable) throws IOException, PropertyVetoException {
        Repository repo = Repository.getDefault();
        FileSystem foundFS = JarUtils.getMountedJarFS(rootFile);
        if (foundFS == null) {
            JarFileSystem jarFs = new JarFileSystem();
            jarFs.setJarFile(rootFile);
            repo.addFileSystem((FileSystem)jarFs);
            return jarFs;
        }
        return foundFS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FileSystem getMountedJarFS(File rootFile) {
        FileSystem existing;
        if (rootFile == null) {
            return null;
        }
        JarFileSystem jfs = new JarFileSystem();
        try {
            try {
                jfs.setJarFile(rootFile);
                existing = Repository.getDefault().findFileSystem(jfs.getSystemName());
            }
            catch (Exception ex) {
                existing = null;
                Object var5_4 = null;
                jfs.removeNotify();
                return existing;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            jfs.removeNotify();
            throw throwable;
        }
        jfs.removeNotify();
        return existing;
    }

    public static JarContent jarContentFromNode(Node node) {
        JarDataObject jdo = (JarDataObject)node.getCookie(class$org$netbeans$modules$jarpackager$JarDataObject == null ? (class$org$netbeans$modules$jarpackager$JarDataObject = JarUtils.class$("org.netbeans.modules.jarpackager.JarDataObject")) : class$org$netbeans$modules$jarpackager$JarDataObject);
        return jdo != null ? jdo.getJarContent() : null;
    }

    public static DataObject resolve(DataObject source) {
        if (source instanceof DataShadow) {
            return ((DataShadow)source).getOriginal();
        }
        return source;
    }

    public static CompilerJob createCompilerJob(ArchiveDescriptor ad, DataObject source) {
        CompilerJobBuilder job = new CompilerJobBuilder();
        JarUtils.addToCompilerJob(job, ad, source);
        return job.getJob();
    }

    private static void addToCompilerJob(CompilerJobBuilder job, ArchiveDescriptor ad, DataObject source) {
        if (source != null && !job.ignoreDataObject(source)) {
            return;
        }
        ContentMemberList members = ad.getContentList();
        int i = 0;
        while (i < members.size()) {
            DataObject dataObj = ((ContentMember)members.get(i)).getDataObject();
            job.addDataObject(dataObj);
            ++i;
        }
    }

    public static String defaultContentName(ArchiveDescriptor desc) {
        String targetPath = desc.getTargetResource().getFile();
        int index = targetPath.lastIndexOf(".");
        if (index < 0) {
            index = targetPath.length();
        }
        StringBuffer contentPath = new StringBuffer();
        contentPath.append(targetPath.substring(0, index));
        contentPath.append(".");
        contentPath.append(JarPackagerOption.singleton().getContentExt());
        return contentPath.toString();
    }

    public static File urlToFile(URL url) {
        return new File(URLDecoder.decode(url.getFile()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class CompilerJobBuilder {
        private HashSet seen = new HashSet();
        private CompilerJob job = new CompilerJob(Compiler.DEPTH_INFINITE);
        static /* synthetic */ Class class$org$openide$loaders$DataFolder;
        static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Compile;

        CompilerJobBuilder() {
        }

        boolean ignoreDataObject(DataObject ignore) {
            return this.seen.add(ignore);
        }

        void addDataObject(DataObject dataObj) {
            if ((dataObj = JarUtils.resolve(dataObj)) == null || this.seen.contains(dataObj)) {
                return;
            }
            if (dataObj instanceof JarDataObject) {
                JarUtils.addToCompilerJob(this, ((JarDataObject)dataObj).getJarContent(), dataObj);
            } else {
                DataFolder folder = (DataFolder)dataObj.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = CompilerJobBuilder.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
                if (folder == null) {
                    this.addScalarObjectToJob(dataObj);
                } else {
                    if (this.seen.contains(folder)) {
                        return;
                    }
                    this.seen.add(folder);
                    Enumeration en = folder.children();
                    while (en.hasMoreElements()) {
                        DataObject child = (DataObject)en.nextElement();
                        this.addDataObject(child);
                    }
                }
            }
        }

        private void addScalarObjectToJob(DataObject dataObj) {
            this.seen.add(dataObj);
            CompilerCookie cc = (CompilerCookie)dataObj.getCookie(class$org$openide$cookies$CompilerCookie$Compile == null ? (class$org$openide$cookies$CompilerCookie$Compile = CompilerJobBuilder.class$("org.openide.cookies.CompilerCookie$Compile")) : class$org$openide$cookies$CompilerCookie$Compile);
            if (cc != null) {
                cc.addToJob(this.job, Compiler.DEPTH_INFINITE);
                if (dataObj instanceof JarDataObject) {
                    new Throwable().printStackTrace();
                }
            }
        }

        CompilerJob getJob() {
            return this.job;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

