/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.FocusManager;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import org.netbeans.modules.jarpackager.util.ForwardizeKey;

public class TabifyJTable {
    private JTable table;
    private ForwardizeKeyForTable fwEnter;
    private ForwardizeKeyForTable fwEscape;

    public TabifyJTable(JTable table) {
        this.table = table;
        this.initMaps();
    }

    private void initMaps() {
        InputMap im = this.table.getInputMap(1);
        ActionMap am = this.table.getActionMap();
        KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
        im.put(tab, "focusNextComponent");
        am.put("focusNextComponent", new ForwardFocus());
        KeyStroke shiftTab = KeyStroke.getKeyStroke(9, 1);
        im.put(shiftTab, "focusPreviousComponent");
        am.put("focusPreviousComponent", new BackwardFocus());
        this.fwEnter = new ForwardizeKeyForTable(this.table, 10, 0, (Component)this.table.getParent());
        this.fwEscape = new ForwardizeKeyForTable(this.table, 27, 0, (Component)this.table.getParent());
    }

    class BackwardFocus
    extends AbstractAction {
        BackwardFocus() {
        }

        public void actionPerformed(ActionEvent ae) {
            FocusManager.getCurrentManager().focusPreviousComponent(TabifyJTable.this.table);
        }
    }

    class ForwardFocus
    extends AbstractAction {
        ForwardFocus() {
        }

        public void actionPerformed(ActionEvent ae) {
            FocusManager.getCurrentManager().focusNextComponent(TabifyJTable.this.table);
        }
    }

    private static class ForwardizeKeyForTable
    extends ForwardizeKey {
        ForwardizeKeyForTable(JTable comp, int keycode, int keymodifier, Component whereto) {
            super(comp, keycode, keymodifier, whereto);
        }

        protected boolean canPass(JComponent component) {
            return !((JTable)component).isEditing();
        }
    }
}

