/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import org.openide.util.NbBundle;
import org.openide.util.io.SafeException;

public class VersionSerializator {
    HashMap versionMap;
    String lastReadVersion;
    String lastRegisteredVersion;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$util$VersionSerializator;

    public VersionSerializator() {
        this(10);
    }

    public VersionSerializator(int capacity) {
        this.versionMap = new HashMap(capacity);
    }

    public void putVersion(Versionable data) {
        String version = data.getName();
        this.versionMap.put(version, data);
        this.lastRegisteredVersion = version;
    }

    public void removeVersion(String version) {
        this.versionMap.remove(version);
        if (version.equals(this.lastRegisteredVersion)) {
            this.lastRegisteredVersion = null;
        }
    }

    public Versionable getVersion(String version) {
        return (Versionable)this.versionMap.get(version);
    }

    public String lastReadVersion() {
        return this.lastReadVersion;
    }

    public void readVersion(ObjectInput in) throws IOException, ClassNotFoundException {
        String version = (String)in.readObject();
        Versionable dataManager = (Versionable)this.versionMap.get(version);
        if (dataManager == null) {
            throw new IOException(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$util$VersionSerializator == null ? (class$org$netbeans$modules$jarpackager$util$VersionSerializator = VersionSerializator.class$("org.netbeans.modules.jarpackager.util.VersionSerializator")) : class$org$netbeans$modules$jarpackager$util$VersionSerializator)).getString("EXC_UnknownVersion"));
        }
        try {
            dataManager.readData(in);
        }
        catch (Exception exc) {
            if (System.getProperty("netbeans.debug.exceptions") != null) {
                exc.printStackTrace();
            }
            throw new SafeException(exc);
        }
        this.lastReadVersion = version;
    }

    public void writeVersion(ObjectOutput out, String version) throws IOException {
        Versionable dataManager = (Versionable)this.versionMap.get(version);
        if (dataManager == null) {
            throw new IOException(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$util$VersionSerializator == null ? (class$org$netbeans$modules$jarpackager$util$VersionSerializator = VersionSerializator.class$("org.netbeans.modules.jarpackager.util.VersionSerializator")) : class$org$netbeans$modules$jarpackager$util$VersionSerializator)).getString("EXC_UnknownVersion"));
        }
        out.writeObject(version);
        try {
            dataManager.writeData(out);
        }
        catch (Exception exc) {
            if (System.getProperty("netbeans.debug.exceptions") != null) {
                exc.printStackTrace();
            }
            throw new SafeException(exc);
        }
    }

    public void writeLastVersion(ObjectOutput oos) throws IOException {
        this.writeVersion(oos, this.lastRegisteredVersion);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Versionable {
        public String getName();

        public void readData(ObjectInput var1) throws IOException, ClassNotFoundException;

        public void writeData(ObjectOutput var1) throws IOException;
    }
}

