/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager.wizard;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.JarDataLoader;
import org.netbeans.modules.jarpackager.JarDataObject;
import org.netbeans.modules.jarpackager.wizard.ContentMemberWizardPanel;
import org.netbeans.modules.jarpackager.wizard.ContentWizardPanel;
import org.netbeans.modules.jarpackager.wizard.ManifestWizardPanel;
import org.netbeans.modules.jarpackager.wizard.RecipeNameWizardPanel;
import org.openide.WizardDescriptor;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

public class JarContentsWizardIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = -1987345873459L;
    private static final int PANEL_COUNT = 4;
    private transient WizardDescriptor.Panel[] panels;
    private transient String[] panelNames;
    private transient int panelIndex = 0;
    private static JarContentsWizardIterator instance = null;
    private transient TemplateWizard wizardInstance;
    private static final String JAR_CONTENT_PROPERTY = new String("jarContent");
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$wizard$JarContentsWizardIterator;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarDataLoader;

    private static String getString(String msg) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$jarpackager$wizard$JarContentsWizardIterator == null ? (class$org$netbeans$modules$jarpackager$wizard$JarContentsWizardIterator = JarContentsWizardIterator.class$("org.netbeans.modules.jarpackager.wizard.JarContentsWizardIterator")) : class$org$netbeans$modules$jarpackager$wizard$JarContentsWizardIterator), (String)msg);
    }

    public static synchronized JarContentsWizardIterator singleton() {
        if (instance == null) {
            instance = new JarContentsWizardIterator();
        }
        return instance;
    }

    public Set instantiate(TemplateWizard wiz) throws IOException {
        JarContent fromWizard = JarContentsWizardIterator.getJarContent(wiz);
        if (wiz.getTargetFolder() == null) {
            throw new IllegalStateException();
        }
        DataObject obj = this.instantiateTemplate(wiz.getTemplate(), wiz.getTargetFolder(), wiz.getTargetName());
        if (JarContentsWizardIterator.isDefaultJarName(fromWizard.getTargetFile().getName())) {
            String jarFileName = obj.getPrimaryFile().getName() + ".jar";
            File newJarFileName = new File(fromWizard.getTargetFile().getParent(), jarFileName);
            fromWizard.setTargetFile(newJarFileName);
        }
        JarDataObject jdObj = (JarDataObject)obj;
        JarContent fromTemplate = jdObj.getJarContent();
        int i = 0;
        while (i < 4) {
            if (this.panels[i] instanceof JarContentEditor) {
                ((JarContentEditor)this.panels[i]).applyChanges(fromTemplate, fromWizard);
            }
            ++i;
        }
        jdObj.save();
        return Collections.singleton(obj);
    }

    public void initialize(TemplateWizard wizard) {
        this.wizardInstance = wizard;
        JarDataObject template = (JarDataObject)wizard.getTemplate();
        JarContent templateContent = template.getJarContent();
        JarContent wizardContent = new JarContent();
        wizardContent.copyContentList(templateContent);
        wizardContent.copyManifest(templateContent);
        JarContentsWizardIterator.setJarContent(wizard, wizardContent);
        if (this.panels == null) {
            this.initialize();
            this.panels = new WizardDescriptor.Panel[4];
            this.panels[0] = new RecipeNameWizardPanel(0);
            ((JComponent)this.panels[0].getComponent()).putClientProperty("WizardPanel_contentData", this.panelNames);
            this.panels[1] = new ContentWizardPanel(1);
            this.panels[2] = new ContentMemberWizardPanel(2);
            this.panels[3] = new ManifestWizardPanel(3);
        }
        Component panel = wizard.targetChooser().getComponent();
        this.panelIndex = 0;
    }

    protected void initialize() {
        if (this.panelNames == null) {
            this.panelNames = new String[4];
            this.panelNames[0] = JarContentsWizardIterator.getString("TIT_ChooseTarget");
            this.panelNames[1] = JarContentsWizardIterator.getString("TIT_Contents");
            this.panelNames[2] = JarContentsWizardIterator.getString("TIT_ContentMembers");
            this.panelNames[3] = JarContentsWizardIterator.getString("TIT_Manifest");
        }
    }

    public void uninitialize(TemplateWizard wiz) {
        this.panels = null;
        this.panelNames = null;
        JarContentsWizardIterator.setJarContent(wiz, null);
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.panelIndex];
    }

    public String name() {
        return this.panelNames[this.panelIndex];
    }

    public boolean hasNext() {
        return this.panelIndex < 3;
    }

    public boolean hasPrevious() {
        return this.panelIndex > 0;
    }

    public void nextPanel() {
        ++this.panelIndex;
    }

    public void previousPanel() {
        --this.panelIndex;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private DataObject instantiateTemplate(DataObject tpl, DataFolder target, String name) throws IOException {
        return tpl.createFromTemplate(target, name);
    }

    public static void setJarContent(TemplateWizard wiz, JarContent jc) {
        wiz.putProperty(JAR_CONTENT_PROPERTY, (Object)jc);
    }

    public static JarContent getJarContent(TemplateWizard wiz) {
        return (JarContent)wiz.getProperty(JAR_CONTENT_PROPERTY);
    }

    public static String getExt() {
        JarDataLoader loader = (JarDataLoader)SharedClassObject.findObject((Class)(class$org$netbeans$modules$jarpackager$JarDataLoader == null ? (class$org$netbeans$modules$jarpackager$JarDataLoader = JarContentsWizardIterator.class$("org.netbeans.modules.jarpackager.JarDataLoader")) : class$org$netbeans$modules$jarpackager$JarDataLoader));
        return loader.getArchiveExt();
    }

    public static File getJarFile(TemplateWizard wizard) {
        JarDataLoader loader = (JarDataLoader)SharedClassObject.findObject((Class)(class$org$netbeans$modules$jarpackager$JarDataLoader == null ? (class$org$netbeans$modules$jarpackager$JarDataLoader = JarContentsWizardIterator.class$("org.netbeans.modules.jarpackager.JarDataLoader")) : class$org$netbeans$modules$jarpackager$JarDataLoader));
        String extension = loader.getArchiveExt();
        try {
            String parent;
            File folder = NbClassPath.toFile((FileObject)wizard.getTargetFolder().getPrimaryFile());
            String string = parent = folder == null ? "" : folder.getPath() + File.separator;
            if (wizard.getTargetName() == null) {
                return new File(parent + JarContentsWizardIterator.getString("FMT_DefaultName") + "." + extension);
            }
            return new File(parent + wizard.getTargetName() + "." + extension);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static String getJarContentFile(TemplateWizard wizard) {
        JarDataLoader loader = (JarDataLoader)SharedClassObject.findObject((Class)(class$org$netbeans$modules$jarpackager$JarDataLoader == null ? (class$org$netbeans$modules$jarpackager$JarDataLoader = JarContentsWizardIterator.class$("org.netbeans.modules.jarpackager.JarDataLoader")) : class$org$netbeans$modules$jarpackager$JarDataLoader));
        String extension = loader.getExtension();
        try {
            String folder = wizard.getTargetFolder().getPrimaryFile().getPath();
            if (folder.length() > 0) {
                folder = folder + "/";
            }
            if (wizard.getTargetName() == null) {
                return NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$wizard$JarContentsWizardIterator == null ? (class$org$netbeans$modules$jarpackager$wizard$JarContentsWizardIterator = JarContentsWizardIterator.class$("org.netbeans.modules.jarpackager.wizard.JarContentsWizardIterator")) : class$org$netbeans$modules$jarpackager$wizard$JarContentsWizardIterator)).getString("ManifestWizardPanel.unknownContentName") + "." + extension;
            }
            return folder + wizard.getTargetName() + "." + extension;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private static boolean isDefaultJarName(String jarFileName) {
        File jfn = new File(jarFileName);
        String defaultJarName = NbBundle.getMessage((Class)(class$org$netbeans$modules$jarpackager$wizard$JarContentsWizardIterator == null ? (class$org$netbeans$modules$jarpackager$wizard$JarContentsWizardIterator = JarContentsWizardIterator.class$("org.netbeans.modules.jarpackager.wizard.JarContentsWizardIterator")) : class$org$netbeans$modules$jarpackager$wizard$JarContentsWizardIterator), (String)"FMT_DefaultName") + ".jar";
        return jfn.getName().equals(defaultJarName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static interface JarContentEditor {
        public void applyChanges(JarContent var1, JarContent var2);
    }
}

