/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.jarpackager.FileObjectFilter;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.util.ForwardizeKey;
import org.netbeans.modules.jarpackager.wizard.JarContentsWizardIterator;
import org.netbeans.modules.jarpackager.wizard.RecipeNameWizardPanel;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class RecipeNamePanel
extends JPanel {
    private RecipeNameWizardPanel wizardPanel;
    private JLabel jLabel4;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JTextField targetName;
    private JLabel jLabel2;
    private JComboBox filtersComboBox;
    private JButton BrowseButton;
    private JPanel jPanel1;
    private JTextField generatedJarLocation;
    private JTextField generatedJarName;
    private JPanel substPanel;
    private ForwardizeKey fwRecipeName = null;
    private ForwardizeKey fwJarName = null;
    private ForwardizeKey fwJarLocation = null;
    final ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$wizard$RecipeNamePanel == null ? (class$org$netbeans$modules$jarpackager$wizard$RecipeNamePanel = RecipeNamePanel.class$("org.netbeans.modules.jarpackager.wizard.RecipeNamePanel")) : class$org$netbeans$modules$jarpackager$wizard$RecipeNamePanel));
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$wizard$RecipeNamePanel;

    public RecipeNamePanel(RecipeNameWizardPanel wizardPanel, int order) {
        this.wizardPanel = wizardPanel;
        this.initComponents();
        this.initAccessibility();
        this.targetName.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        this.generatedJarName.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        if (wizardPanel.targetName != null) {
            this.targetName.setText(wizardPanel.targetName);
            this.targetName.setSelectionStart(0);
            this.targetName.setSelectionEnd(wizardPanel.targetName.length());
        }
        if (wizardPanel.current != null) {
            this.generatedJarName.setText(wizardPanel.current.getName());
            this.generatedJarLocation.setText(wizardPanel.current.getParent());
        }
        this.substPanel.setName(RecipeNamePanel.getMessage("TIT_RecipeName"));
        this.substPanel.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(order));
        DefaultComboBoxModel<FileObjectFilter> model = new DefaultComboBoxModel<FileObjectFilter>();
        model.addElement(JarContent.DEFAULT);
        model.addElement(JarContent.CLASSES_ONLY);
        model.addElement(JarContent.ALL);
        this.filtersComboBox.setModel(model);
        if (wizardPanel.currentFilter != null) {
            this.filtersComboBox.setSelectedItem(wizardPanel.currentFilter);
        }
        HelpCtx.setHelpIDString((JComponent)this.substPanel, (String)(class$org$netbeans$modules$jarpackager$wizard$RecipeNamePanel == null ? (class$org$netbeans$modules$jarpackager$wizard$RecipeNamePanel = RecipeNamePanel.class$("org.netbeans.modules.jarpackager.wizard.RecipeNamePanel")) : class$org$netbeans$modules$jarpackager$wizard$RecipeNamePanel).getName());
        this.substPanel.getAccessibleContext().setAccessibleDescription(RecipeNamePanel.getMessage("ACCD_RecipeNamePanel"));
        this.jLabel1.setDisplayedMnemonic(RecipeNamePanel.getMessage("RecipeNamePanel.jLabel1.mnemonics").charAt(0));
        this.jLabel2.setDisplayedMnemonic(RecipeNamePanel.getMessage("RecipeNamePanel.jLabel2.mnemonics").charAt(0));
        this.jLabel3.setDisplayedMnemonic(RecipeNamePanel.getMessage("RecipeNamePanel.jLabel3.mnemonics").charAt(0));
        this.jLabel4.setDisplayedMnemonic(RecipeNamePanel.getMessage("RecipeNamePanel.jLabel4.mnemonics").charAt(0));
        this.jLabel1.setLabelFor(this.targetName);
        this.jLabel2.setLabelFor(this.generatedJarLocation);
        this.jLabel3.setLabelFor(this.generatedJarName);
        this.jLabel4.setLabelFor(this.filtersComboBox);
        this.targetName.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                RecipeNamePanel.this.keyTyped(false);
            }

            public void removeUpdate(DocumentEvent e) {
                RecipeNamePanel.this.keyTyped(true);
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.add((Component)this.substPanel, "Center");
        HelpCtx.setHelpIDString((JComponent)this, (String)(class$org$netbeans$modules$jarpackager$wizard$RecipeNamePanel == null ? (class$org$netbeans$modules$jarpackager$wizard$RecipeNamePanel = RecipeNamePanel.class$("org.netbeans.modules.jarpackager.wizard.RecipeNamePanel")) : class$org$netbeans$modules$jarpackager$wizard$RecipeNamePanel).getName());
        this.setName(RecipeNamePanel.getMessage("TIT_RecipeName"));
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(order));
        this.fwRecipeName = new ForwardizeKey(this.targetName, 10, 0, this.jLabel1);
        this.fwJarName = new ForwardizeKey(this.generatedJarName, 10, 0, this.jLabel2);
        this.fwJarLocation = new ForwardizeKey(this.generatedJarLocation, 10, 0, this.jLabel3);
    }

    Component getSubstPanel() {
        return this.substPanel;
    }

    String getTargetName() {
        return this.targetName.getText();
    }

    void setTargetName(String name) {
        this.targetName.setText(name);
        this.targetName.setSelectionStart(0);
        this.targetName.setSelectionEnd(name.length());
    }

    String getJarName() {
        return this.generatedJarName.getText();
    }

    void setJarFile(File jarFile) {
        this.generatedJarName.setText(jarFile.getName());
        this.generatedJarLocation.setText(jarFile.getParent());
    }

    FileObjectFilter getSelectedFileFilter() {
        return (FileObjectFilter)this.filtersComboBox.getSelectedItem();
    }

    void setSelectedFileFilter(FileObjectFilter filter) {
        this.filtersComboBox.setSelectedItem(filter);
    }

    public void requestFocus() {
        this.targetName.requestFocus();
        this.targetName.selectAll();
    }

    static String defaultName() {
        return RecipeNamePanel.getMessage("FMT_DefaultName");
    }

    static String defaultJarName() {
        return RecipeNamePanel.defaultName() + "." + JarContentsWizardIterator.getExt();
    }

    String derivedJarName() {
        return this.targetName.getText() + "." + JarContentsWizardIterator.getExt();
    }

    private void browseRecipeLocation() {
        File currentParent = this.wizardPanel.currentParent;
        if (currentParent == null) {
            try {
                File defDir = new File(System.getProperty("user.home"));
                if (Utilities.isUnix()) {
                    currentParent = defDir;
                } else if (Utilities.isWindows()) {
                    while ((defDir = defDir.getParentFile()) != null && defDir.getParentFile() != null) {
                    }
                    if (defDir != null) {
                        currentParent = defDir;
                    }
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        JFileChooser chooser = new JFileChooser(currentParent);
        chooser.setFileSelectionMode(1);
        int returnVal = chooser.showDialog(this, RecipeNamePanel.getMessage("CTL_Select"));
        if (returnVal == 0) {
            this.generatedJarLocation.setText(chooser.getSelectedFile().getPath());
            this.saveJarFile();
            this.wizardPanel.parentDirty = true;
        }
    }

    public void handleTargetNameChange() {
        if (this.wizardPanel.jarNameDirty) {
            return;
        }
        this.generatedJarName.setText(this.derivedJarName());
        this.wizardPanel.current = new File(this.wizardPanel.currentParent, this.generatedJarName.getText());
    }

    private void initComponents() {
        this.substPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.targetName = new JTextField();
        this.jLabel2 = new JLabel();
        this.generatedJarLocation = new JTextField();
        this.BrowseButton = new JButton();
        this.jLabel3 = new JLabel();
        this.generatedJarName = new JTextField();
        this.jLabel4 = new JLabel();
        this.filtersComboBox = new JComboBox();
        this.jPanel1 = new JPanel();
        this.substPanel.setLayout(new GridBagLayout());
        this.substPanel.setMinimumSize(new Dimension(200, 100));
        this.substPanel.setPreferredSize(new Dimension(700, 300));
        this.jLabel1.setLabelFor(this.targetName);
        this.jLabel1.setText(this.bundle.getString("CTL_RecipeName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 11, 2);
        this.substPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.targetName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecipeNamePanel.this.targetNameActionPerformed(evt);
            }
        });
        this.targetName.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                RecipeNamePanel.this.editBoxFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                RecipeNamePanel.this.editBoxFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 11, 11);
        this.substPanel.add((Component)this.targetName, gridBagConstraints);
        this.jLabel2.setLabelFor(this.generatedJarLocation);
        this.jLabel2.setText(this.bundle.getString("CTL_GeneratedJarLocation"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 11, 12);
        this.substPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.generatedJarLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecipeNamePanel.this.generatedJarLocationActionPerformed(evt);
            }
        });
        this.generatedJarLocation.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                RecipeNamePanel.this.editBoxFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                RecipeNamePanel.this.editBoxFocusLost(evt);
            }
        });
        this.generatedJarLocation.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                RecipeNamePanel.this.generatedJarLocationKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.substPanel.add((Component)this.generatedJarLocation, gridBagConstraints);
        this.BrowseButton.setText(this.bundle.getString("CTL_Browse"));
        this.BrowseButton.setMnemonic(this.bundle.getString("MNM_Browse").charAt(0));
        this.BrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecipeNamePanel.this.BrowseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.substPanel.add((Component)this.BrowseButton, gridBagConstraints);
        this.jLabel3.setLabelFor(this.generatedJarName);
        this.jLabel3.setText(this.bundle.getString("CTL_GeneratedJarName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 11, 12);
        this.substPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.generatedJarName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecipeNamePanel.this.generatedJarNameActionPerformed(evt);
            }
        });
        this.generatedJarName.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                RecipeNamePanel.this.editBoxFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                RecipeNamePanel.this.editBoxFocusLost(evt);
            }
        });
        this.generatedJarName.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                RecipeNamePanel.this.generatedJarNameKeyTyped(evt);
            }

            public void keyReleased(KeyEvent evt) {
                RecipeNamePanel.this.generatedJarNameKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.substPanel.add((Component)this.generatedJarName, gridBagConstraints);
        this.jLabel4.setLabelFor(this.filtersComboBox);
        this.jLabel4.setText(this.bundle.getString("CTL_Filter"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 11, 12);
        this.substPanel.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.substPanel.add((Component)this.filtersComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.substPanel.add((Component)this.jPanel1, gridBagConstraints);
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(200, 100));
        this.setPreferredSize(new Dimension(700, 300));
    }

    private void generatedJarLocationKeyReleased(KeyEvent evt) {
        this.saveJarFile();
        this.wizardPanel.parentDirty = true;
    }

    private void generatedJarNameKeyTyped(KeyEvent evt) {
        this.wizardPanel.jarNameDirty = true;
    }

    private void editBoxFocusGained(FocusEvent evt) {
        JTextComponent eb = (JTextComponent)evt.getComponent();
        eb.selectAll();
    }

    private void keyTyped(boolean removing) {
        if (this.targetName.getText().equals("") && removing) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (RecipeNamePanel.this.targetName.getText().equals("")) {
                        RecipeNamePanel.this.targetName.setText(RecipeNamePanel.defaultName());
                        RecipeNamePanel.this.targetName.selectAll();
                    }
                }
            });
        }
        this.handleTargetNameChange();
    }

    private void editBoxFocusLost(FocusEvent evt) {
        JTextComponent eb = (JTextComponent)evt.getComponent();
        eb.select(0, 0);
    }

    private void generatedJarNameKeyReleased(KeyEvent evt) {
        if (this.generatedJarName.getText().equals("")) {
            this.generatedJarName.setText(this.derivedJarName());
            this.generatedJarName.selectAll();
        }
        this.saveJarFile();
        if (this.derivedJarName().equals(this.wizardPanel.current.getName())) {
            this.wizardPanel.jarNameDirty = false;
        }
    }

    private void saveJarFile() {
        this.wizardPanel.currentParent = new File(this.generatedJarLocation.getText());
        this.wizardPanel.current = new File(this.wizardPanel.currentParent, this.generatedJarName.getText());
    }

    private void generatedJarNameActionPerformed(ActionEvent evt) {
    }

    private void BrowseButtonActionPerformed(ActionEvent evt) {
        this.browseRecipeLocation();
    }

    private void targetNameActionPerformed(ActionEvent evt) {
        this.targetName.setText(this.targetName.getText().trim());
        if (this.targetName.getText().equals("")) {
            this.targetName.setText(RecipeNamePanel.defaultName());
            this.targetName.selectAll();
        }
        this.handleTargetNameChange();
        this.wizardPanel.fireStateChanged();
    }

    private void generatedJarLocationActionPerformed(ActionEvent evt) {
    }

    private void initAccessibility() {
        AccessibleContext context = this.getAccessibleContext();
        context.setAccessibleDescription(RecipeNamePanel.getMessage("ACCD_RecipeNamePanel"));
        context = this.targetName.getAccessibleContext();
        context.setAccessibleDescription(RecipeNamePanel.getMessage("ACCD_RecipeTargetName"));
        context = this.filtersComboBox.getAccessibleContext();
        context.setAccessibleDescription(RecipeNamePanel.getMessage("ACCD_RecipeFiltersComboBox"));
        context = this.BrowseButton.getAccessibleContext();
        context.setAccessibleDescription(RecipeNamePanel.getMessage("ACCD_Browse"));
        context = this.generatedJarName.getAccessibleContext();
        context.setAccessibleDescription(RecipeNamePanel.getMessage("ACCD_RecipeGeneratedJarName"));
        context = this.generatedJarLocation.getAccessibleContext();
        context.setAccessibleDescription(RecipeNamePanel.getMessage("ACCD_RecipeGeneratedJarLocation"));
    }

    private static String getMessage(String msg) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$jarpackager$wizard$RecipeNamePanel == null ? (class$org$netbeans$modules$jarpackager$wizard$RecipeNamePanel = RecipeNamePanel.class$("org.netbeans.modules.jarpackager.wizard.RecipeNamePanel")) : class$org$netbeans$modules$jarpackager$wizard$RecipeNamePanel), (String)msg);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

