/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager.wizard;

import java.awt.Component;
import java.io.File;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.jarpackager.FileObjectFilter;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.wizard.JarContentsWizardIterator;
import org.netbeans.modules.jarpackager.wizard.RecipeNamePanel;
import org.openide.WizardDescriptor;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;

class RecipeNameWizardPanel
implements WizardDescriptor.FinishPanel,
JarContentsWizardIterator.JarContentEditor {
    private RecipeNamePanel uiPanel;
    private int order;
    private ChangeListener listener;
    private String extension;
    String targetName;
    File current;
    File currentParent;
    FileObjectFilter currentFilter;
    private boolean setByUser = false;
    boolean parentDirty = false;
    boolean jarNameDirty = false;

    RecipeNameWizardPanel(int order) {
        this.order = order;
    }

    public Component getComponent() {
        if (this.uiPanel == null) {
            this.uiPanel = new RecipeNamePanel(this, this.order);
        }
        return this.uiPanel.getSubstPanel();
    }

    public HelpCtx getHelp() {
        return HelpCtx.findHelp((Component)this.getComponent());
    }

    public void readSettings(Object settings) {
        TemplateWizard wizard = (TemplateWizard)settings;
        DataObject template = wizard.getTemplate();
        if (template != null) {
            this.extension = template.getPrimaryFile().getExt();
        }
        this.targetName = wizard.getTargetName();
        if (this.targetName == null || this.targetName.length() == 0) {
            this.targetName = RecipeNamePanel.defaultName();
        }
        JarContent fromWizard = JarContentsWizardIterator.getJarContent(wizard);
        File defaultJar = JarContentsWizardIterator.getJarFile(wizard);
        if (this.setByUser) {
            this.current = fromWizard.getTargetFile();
            this.currentParent = this.current.getParentFile();
        } else {
            this.current = defaultJar;
            this.currentParent = this.current.getParentFile();
        }
        if ((this.targetName + "." + JarContentsWizardIterator.getExt()).equals(this.current.getName())) {
            this.jarNameDirty = false;
        }
        this.currentFilter = fromWizard.getFilter();
        if (this.uiPanel != null) {
            this.uiPanel.setTargetName(this.targetName);
            this.uiPanel.setJarFile(this.current);
            this.uiPanel.setSelectedFileFilter(this.currentFilter);
        }
    }

    public void storeSettings(Object settings) {
        if (this.uiPanel == null) {
            return;
        }
        TemplateWizard wizard = (TemplateWizard)settings;
        JarContent fromWizard = JarContentsWizardIterator.getJarContent(wizard);
        String name = this.uiPanel.getTargetName();
        if (name.equals(RecipeNamePanel.defaultName())) {
            name = null;
        }
        wizard.setTargetName(name);
        String jarName = this.uiPanel.getJarName();
        if (!jarName.equals(RecipeNamePanel.defaultJarName())) {
            this.current = new File(this.currentParent, jarName);
            fromWizard.setTargetFile(this.current);
            this.setByUser = true;
        } else if (this.parentDirty) {
            this.current = new File(this.currentParent, this.uiPanel.derivedJarName());
            fromWizard.setTargetFile(this.current);
            this.setByUser = true;
        }
        if (!this.setByUser) {
            this.current = new File(this.currentParent, RecipeNamePanel.defaultJarName());
            fromWizard.setTargetFile(this.current);
        }
        fromWizard.setFilter(this.uiPanel.getSelectedFileFilter());
    }

    public boolean isValid() {
        return true;
    }

    public void addChangeListener(ChangeListener l) {
        if (this.listener != null) {
            throw new IllegalStateException();
        }
        this.listener = l;
    }

    public void removeChangeListener(ChangeListener l) {
        this.listener = null;
    }

    void fireStateChanged() {
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    public void applyChanges(JarContent fromTemplate, JarContent fromWizard) {
        File location = fromWizard.getTargetFile();
        if (location != null) {
            fromTemplate.setTargetFile(location);
        }
        FileObjectFilter filter = fromWizard.getFilter();
        fromTemplate.setFilter(filter);
    }
}

