/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.context;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.web.context.RepManager;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class DelegatingFileSystem
extends MultiFileSystem
implements FileSystem.Status,
FileStatusListener {
    static final long serialVersionUID = 3521863383479243345L;
    protected String rootFolder;
    protected transient FileSystem delegateeFs;
    protected String delegateeFsName;
    private transient PropertyChangeListener pcl;
    private transient boolean removable = false;
    static /* synthetic */ Class class$org$netbeans$modules$web$context$DelegatingFileSystem;

    public DelegatingFileSystem(FileObject baseFo) throws IOException {
        this(baseFo.getFileSystem(), baseFo.getPackageName('/'));
    }

    public DelegatingFileSystem(FileSystem baseFs, String rootFolder) throws IOException {
        super(new FileSystem[]{baseFs});
        this.rootFolder = rootFolder;
        this.delegateeFsName = baseFs.getSystemName();
        this.setFileSystem(baseFs);
    }

    public final void setFileSystem(FileSystem main) {
        FileSystem old;
        FileSystem[] fss = (FileSystem[])this.getDelegates().clone();
        if (fss.length > 0) {
            old = fss[0];
            fss[0] = main;
        } else {
            old = null;
            fss = new FileSystem[]{main};
        }
        if (old != null) {
            old.removeFileStatusListener((FileStatusListener)this);
        }
        if (main != null) {
            main.addFileStatusListener((FileStatusListener)this);
        }
        this.setDelegates(fss[0] != null ? fss : new FileSystem[1]);
        this.delegateeFs = main;
        this.updateName();
    }

    void updateState() {
        if (this.delegateeFsName != null) {
            RepManager.register(this);
            FileSystem fs = Repository.getDefault().findFileSystem(this.delegateeFsName);
            this.setFileSystem(fs);
        }
    }

    public void prepareEnvironment(final FileSystem.Environment env) throws EnvironmentNotSupportedException {
        if (this.delegateeFs != null) {
            this.delegateeFs.prepareEnvironment(new FileSystem.Environment(){

                public void addClassPath(String classPathElement) {
                    String cp = classPathElement.endsWith(File.separator) ? classPathElement : classPathElement + File.separator;
                    cp = cp + DelegatingFileSystem.this.rootFolder.replace('/', File.separatorChar);
                    env.addClassPath(cp);
                }
            });
        }
    }

    private void updateName() {
        try {
            FileSystem[] fss = this.getDelegates();
            String n = fss.length > 0 && fss[0] != null ? fss[0].getSystemName() : "Invalid " + this.delegateeFsName;
            this.setSystemName(n + ":" + this.rootFolder);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public String getDisplayName() {
        return this.delegateeFs == null ? NbBundle.getMessage((Class)(class$org$netbeans$modules$web$context$DelegatingFileSystem == null ? (class$org$netbeans$modules$web$context$DelegatingFileSystem = DelegatingFileSystem.class$("org.netbeans.modules.web.context.DelegatingFileSystem")) : class$org$netbeans$modules$web$context$DelegatingFileSystem), (String)"LBL_displayNameInvalid", (Object)this.rootFolder) : this.delegateeFs.getDisplayName() + " : /" + this.rootFolder;
    }

    public SystemAction[] getActions(Set fooSet) {
        if (this.delegateeFs == null) {
            return new SystemAction[0];
        }
        return this.delegateeFs.getActions(this.translateFiles(fooSet, false));
    }

    protected FileObject findResourceOn(FileSystem fs, String res) {
        if (fs == null) {
            return null;
        }
        return fs.findResource(this.rootFolder + "/" + res);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        FileSystem[] fss;
        in.defaultReadObject();
        if (this.delegateeFsName == null && (fss = this.getDelegates()).length > 0) {
            this.delegateeFsName = fss[0].getSystemName();
        }
        this.updateState();
    }

    public boolean correspondsTo(FileSystem fs) {
        if (fs instanceof DelegatingFileSystem) {
            DelegatingFileSystem dfs = (DelegatingFileSystem)fs;
            return (this.delegateeFs == dfs.delegateeFs || this.delegateeFsName.equals(dfs.delegateeFsName)) && this.rootFolder.equals(dfs.rootFolder);
        }
        if (fs instanceof LocalFileSystem && this.delegateeFs instanceof LocalFileSystem) {
            File f1 = NbClassPath.toFile((FileObject)fs.getRoot());
            if (f1 == null) {
                return false;
            }
            FileObject fo2 = this.delegateeFs.find(this.rootFolder.replace('/', '.'), null, null);
            if (fo2 == null) {
                return false;
            }
            File f2 = NbClassPath.toFile((FileObject)fo2);
            if (f2 == null) {
                return false;
            }
            return f1.equals(f2);
        }
        return false;
    }

    public boolean delegatesTo(FileSystem fs) {
        File fsRoot = FileUtil.toFile((FileObject)fs.getRoot());
        if (fsRoot == null || this.delegateeFs == null) {
            return false;
        }
        return fsRoot.equals(FileUtil.toFile((FileObject)this.delegateeFs.getRoot()));
    }

    public FileSystem.Status getStatus() {
        return this;
    }

    public String annotateName(String name, Set files) {
        if (this.delegateeFs == null) {
            return name;
        }
        return this.delegateeFs.getStatus().annotateName(name, this.translateFiles(files, false));
    }

    public Image annotateIcon(Image icon, int iconType, Set files) {
        if (this.delegateeFs == null) {
            return icon;
        }
        return this.delegateeFs.getStatus().annotateIcon(icon, iconType, this.translateFiles(files, false));
    }

    protected Set translateFiles(Set files, boolean fromBase) {
        HashSet<FileObject> newFiles = new HashSet<FileObject>();
        Iterator it = files.iterator();
        while (it.hasNext()) {
            FileObject fo = (FileObject)it.next();
            if ((fo = this.translateFile(fo, fromBase)) == null) continue;
            newFiles.add(fo);
        }
        return newFiles;
    }

    protected FileObject translateFile(FileObject fo, boolean fromBase) {
        if (fromBase) {
            String path = fo.getPackageNameExt('/', '.');
            fo = null;
            if (path.startsWith(this.rootFolder)) {
                fo = "".equals(path = path.substring(this.rootFolder.length())) ? this.getRoot() : this.findResource(path.substring(1));
            }
        } else {
            if (this.delegateeFs == null) {
                return null;
            }
            fo = this.delegateeFs.findResource(this.rootFolder + '/' + fo.getPackageNameExt('/', '.'));
        }
        return fo;
    }

    public void annotationChanged(final FileStatusEvent ev) {
        HashSet set = new HashSet(1){

            public boolean contains(Object o) {
                if (DelegatingFileSystem.this.delegateeFs == null) {
                    return false;
                }
                if (o instanceof FileObject) {
                    FileObject fo = (FileObject)o;
                    fo = DelegatingFileSystem.this.delegateeFs.findResource(DelegatingFileSystem.this.rootFolder + '/' + fo.getPackageNameExt('/', '.'));
                    return fo != null && ev.hasChanged(fo);
                }
                return false;
            }
        };
        this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, (Set)set, ev.isIconChange(), ev.isNameChange()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

