/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.context;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.j2ee.server.Server;
import org.netbeans.modules.j2ee.server.datamodel.FileArchiveResource;
import org.netbeans.modules.j2ee.server.datamodel.J2eeAppStandardData;
import org.netbeans.modules.jarpackager.ArchiveDescriptor;
import org.netbeans.modules.jarpackager.FileObjectFilter;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.JarCreator;
import org.netbeans.modules.jarpackager.api.ArchiveBuilder;
import org.netbeans.modules.web.context.WebContextObject;
import org.netbeans.modules.web.context.WebInfObject;
import org.netbeans.modules.web.context.packager.WarServerArchiveBuilder;
import org.openide.actions.AbstractCompileAction;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.compiler.CompilerTask;
import org.openide.cookies.CompilerCookie;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.enum.SingletonEnumeration;
import org.openide.windows.WindowManager;

public abstract class PackageWar
implements WebContextObject.WebContextPackager,
FileArchiveResource {
    private static final String WARFILE = "_webmodule";
    private static final String WAREXT = "war";
    private static File lastChosenFolder = null;
    private WebContextObject wco;
    private Server server = null;
    private J2eeAppStandardData appData = null;
    private File warFile;
    private static final FileFilter WARFILTER = new WarFileFilter();
    private static final FileObjectFilter WARCONTENTFILTER = new WarContentFilter();
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Compile;
    static /* synthetic */ Class class$org$netbeans$modules$web$context$PackageWar;

    public PackageWar() {
        this.wco = null;
    }

    PackageWar(WebContextObject w, Server s, J2eeAppStandardData appData) {
        this(w, s, appData, null);
    }

    PackageWar(WebContextObject w, Server s, J2eeAppStandardData appData, File warFile) {
        this.wco = w;
        this.server = s;
        this.warFile = warFile == null ? this.getDefaultWarFile() : warFile;
    }

    private void doPackage() throws Exception {
        if (this.warFile == null) {
            this.warFile = this.getDefaultWarFile();
        }
        PackageWar.doCompile(this.wco);
        this.runPackage();
    }

    public static void doCompile(WebContextObject web) throws Exception {
        PackageWar.doCompile(web.getInfObject());
    }

    public static void doCompile(WebInfObject inf) throws Exception {
        CompilerTask task;
        CompilerCookie cookie = (CompilerCookie)inf.getCookie(class$org$openide$cookies$CompilerCookie$Compile == null ? (class$org$openide$cookies$CompilerCookie$Compile = PackageWar.class$("org.openide.cookies.CompilerCookie$Compile")) : class$org$openide$cookies$CompilerCookie$Compile);
        if (cookie == null) {
            return;
        }
        CompilerJob job = AbstractCompileAction.createJob((Enumeration)new SingletonEnumeration((Object)cookie), (Compiler.Depth)Compiler.DEPTH_INFINITE);
        job.setDisplayName(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$context$PackageWar == null ? (class$org$netbeans$modules$web$context$PackageWar = PackageWar.class$("org.netbeans.modules.web.context.PackageWar")) : class$org$netbeans$modules$web$context$PackageWar)).getString("MSG_WebModuleCompiling"));
        if (!job.isUpToDate() && !(task = job.start()).isSuccessful()) {
            throw new Exception(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$context$PackageWar == null ? (class$org$netbeans$modules$web$context$PackageWar = PackageWar.class$("org.netbeans.modules.web.context.PackageWar")) : class$org$netbeans$modules$web$context$PackageWar)).getString("MSG_WebModuleCompilingFailed"));
        }
    }

    public abstract File getFile();

    public abstract InputStream getJarFile();

    public InputStream getXML() {
        return null;
    }

    public String getArchiveFileName() {
        return null;
    }

    private void runPackage() throws Exception {
        OutputStream os;
        block5: {
            File warfile = PackageWar.ensureExtension(this.warFile, ".war");
            ObjectOutputStream oos = null;
            os = null;
            WarServerArchiveBuilder builder = null;
            JarCreator jcr = null;
            try {
                JarContent jc = new JarContent(WARCONTENTFILTER);
                jc.addDataObject((DataObject)this.wco);
                jc.setTargetResource(warfile.toURL());
                os = new FileOutputStream(warfile);
                jcr = new JarCreator((ArchiveDescriptor)jc);
                builder = new WarServerArchiveBuilder(this.wco, this.server, this.appData);
                jcr.addSpecificBuilder((ArchiveBuilder)builder);
                jcr.createJar(os, warfile);
                builder.finish();
                Object var8_7 = null;
                if (oos == null) break block5;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (oos != null) {
                    oos.close();
                }
                if (os != null) {
                    os.close();
                }
                throw throwable;
            }
            oos.close();
        }
        if (os != null) {
            os.close();
        }
    }

    protected File getDefaultWarFile() {
        File parent = NbClassPath.toFile((FileObject)this.wco.getInfObject().getPrimaryFile());
        return new File(parent, "_webmodule.war");
    }

    public static File ensureExtension(File f, String e) {
        String ext;
        if (f == null) {
            return null;
        }
        String n = f.getName();
        if (n.length() <= 0) {
            return null;
        }
        String string = ext = e.startsWith(".") ? e : "." + e;
        if (n.endsWith(ext)) {
            return f;
        }
        int i = n.lastIndexOf(".");
        if (i >= 0) {
            n = n.substring(0, i);
        }
        n = n + ext;
        return new File(f.getParentFile(), n);
    }

    public static File fileChooseDialog() {
        File f;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(WARFILTER);
        if (lastChosenFolder != null) {
            chooser.setCurrentDirectory(lastChosenFolder);
        }
        chooser.setDialogTitle(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$context$PackageWar == null ? (class$org$netbeans$modules$web$context$PackageWar = PackageWar.class$("org.netbeans.modules.web.context.PackageWar")) : class$org$netbeans$modules$web$context$PackageWar), (String)"CTL_SelectWar"));
        if (chooser.showDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getBundle((Class)(class$org$netbeans$modules$web$context$PackageWar == null ? (class$org$netbeans$modules$web$context$PackageWar = PackageWar.class$("org.netbeans.modules.web.context.PackageWar")) : class$org$netbeans$modules$web$context$PackageWar)).getString("CTL_SelectOk")) == 0 && (f = chooser.getSelectedFile()) != null) {
            lastChosenFolder = chooser.getCurrentDirectory();
            return PackageWar.ensureExtension(f, WAREXT);
        }
        return null;
    }

    public abstract FileArchiveResource getResource(WebContextObject var1, Server var2, J2eeAppStandardData var3, File var4);

    public abstract FileArchiveResource getResource(WebContextObject var1, Server var2, J2eeAppStandardData var3);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class WarContentFilter
    implements FileObjectFilter {
        static final long serialVersionUID = 2728555521505193570L;

        public boolean accept(FileObject fo) {
            String ext = fo.getExt();
            if (fo.getName().equals("web") && fo.getParent().getName().equals("WEB-INF")) {
                return ext.equals("xml");
            }
            return !"java".equals(ext) && !"form".equals(ext);
        }

        private Object readResolve() throws ObjectStreamException {
            return WARCONTENTFILTER;
        }
    }

    private static final class WarFileFilter
    extends FileFilter {
        static /* synthetic */ Class class$org$netbeans$modules$web$context$PackageWar;

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".war");
        }

        public String getDescription() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$web$context$PackageWar == null ? (class$org$netbeans$modules$web$context$PackageWar = WarFileFilter.class$("org.netbeans.modules.web.context.PackageWar")) : class$org$netbeans$modules$web$context$PackageWar)).getString("CTL_WarArchivesMask");
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

