/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.context;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.netbeans.modules.web.context.DelegatingFileSystem;
import org.netbeans.modules.web.context.WebContextLoader;
import org.netbeans.modules.web.context.WebContextObject;
import org.netbeans.modules.web.context.WebInfObject;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.RequestProcessor;

public final class ProjectViewManager
implements RepositoryListener,
PropertyChangeListener,
Runnable {
    private static ProjectViewManager pvm;
    private boolean projectSwitchInProgress = false;
    private Map contexts = new HashMap();
    private Collection uninitedContexts = new Vector();

    public static synchronized ProjectViewManager getDefault() {
        if (pvm == null) {
            pvm = new ProjectViewManager();
        }
        return pvm;
    }

    private ProjectViewManager() {
    }

    public void fileSystemAdded(RepositoryEvent ev) {
        this.registerWebContext(ev.getFileSystem());
    }

    public void notifyWebContext(FileSystem fs, WebContextObject wco) {
        if (wco != null) {
            this.registerWebContext(fs);
        } else {
            this.contexts.remove(fs);
        }
    }

    public void run() {
        Iterator it = this.uninitedContexts.iterator();
        while (it.hasNext()) {
            FileSystem fs = (FileSystem)it.next();
            this.registerWebContext(fs);
        }
        this.uninitedContexts.clear();
    }

    private void registerWebContext(FileSystem fs) {
        block21: {
            if (this.projectSwitchInProgress) {
                if (!this.uninitedContexts.contains(fs)) {
                    this.uninitedContexts.add(fs);
                }
                return;
            }
            if (this.contexts.containsKey(fs)) {
                return;
            }
            FileObject root = fs.getRoot();
            try {
                FileObject webInf;
                DataObject dobj2;
                if (!WebContextLoader.canBeContext(fs) || !WebContextLoader.isWebApplication(fs)) break block21;
                DataObject dobj = DataObject.find((FileObject)root);
                if (!(dobj instanceof WebContextObject)) {
                    try {
                        dobj.setValid(false);
                    }
                    catch (PropertyVetoException e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                    dobj = DataObject.find((FileObject)root);
                }
                if (!((dobj2 = DataObject.find((FileObject)(webInf = fs.findResource("WEB-INF")))) instanceof WebInfObject)) {
                    try {
                        dobj2.setValid(false);
                    }
                    catch (PropertyVetoException e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                    dobj2 = DataObject.find((FileObject)root);
                }
                if (dobj instanceof WebContextObject) {
                    WebContextObject wc = (WebContextObject)dobj;
                    wc.setupContext();
                    if (!this.contexts.containsKey(fs)) {
                        this.contexts.put(fs, wc);
                    }
                } else {
                    ErrorManager.getDefault().notify(1, (Throwable)new RuntimeException(fs.getSystemName()));
                }
            }
            catch (DataObjectNotFoundException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        if (fs instanceof DelegatingFileSystem) {
            FileSystem deleg;
            DelegatingFileSystem dfs = (DelegatingFileSystem)fs;
            String sysName = fs.getSystemName();
            Enumeration en = Repository.getDefault().getFileSystems();
            while (en.hasMoreElements()) {
                FileSystem fs2 = (FileSystem)en.nextElement();
                if (fs2 == fs || !fs2.getSystemName().equals(sysName)) continue;
                WebContextObject.removeFS(fs);
                dfs = null;
            }
            if (dfs != null && (deleg = dfs.delegateeFs) != null) {
                try {
                    DataObject dobj = DataObject.find((FileObject)deleg.getRoot());
                    if (dobj instanceof WebContextObject) {
                        ((WebContextObject)dobj).setClassesFS((FileSystem)dfs);
                    }
                }
                catch (DataObjectNotFoundException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
        }
    }

    public void fileSystemRemoved(RepositoryEvent ev) {
        if (!this.projectSwitchInProgress) {
            FileSystem fs = ev.getFileSystem();
            FileObject root = fs.getRoot();
            WebContextObject dobj = (WebContextObject)this.contexts.remove(fs);
            if (dobj != null) {
                dobj.destroyContext();
            }
        }
    }

    public void fileSystemPoolReordered(RepositoryReorderedEvent ev) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("nb-projects-beforeOpenProject".equals(evt.getPropertyName())) {
            this.projectSwitchInProgress = true;
            this.contexts.clear();
        }
        if ("nb-projects-afterOpenProject".equals(evt.getPropertyName())) {
            this.projectSwitchInProgress = false;
            if (!this.uninitedContexts.isEmpty()) {
                RequestProcessor.getDefault().post((Runnable)this);
            }
        }
    }
}

