/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.context;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.web.context.BaseWizardPanel;
import org.netbeans.modules.web.context.NewWebModuleMountWizardPanel;
import org.netbeans.modules.web.context.WebAppObject;
import org.netbeans.modules.web.context.WebContextLoader;
import org.netbeans.modules.web.context.WebContextObject;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public final class WebAppWizardIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = 4443289023351613861L;
    private static String[] panelNames = null;
    private static WebAppWizardIterator singletonInstance;
    private transient WebAppObject.WizardData wizardData;
    private WizardDescriptor.ArrayIterator arrayIterator = null;
    static /* synthetic */ Class class$org$netbeans$modules$web$context$WebAppWizardIterator;

    public static String[] panelNames() {
        if (panelNames == null) {
            panelNames = new String[1];
            WebAppWizardIterator.panelNames[0] = NbBundle.getMessage((Class)(class$org$netbeans$modules$web$context$WebAppWizardIterator == null ? (class$org$netbeans$modules$web$context$WebAppWizardIterator = WebAppWizardIterator.class$("org.netbeans.modules.web.context.WebAppWizardIterator")) : class$org$netbeans$modules$web$context$WebAppWizardIterator), (String)"CTL_WebAppWizardPanel.ChooseTarget");
        }
        return panelNames;
    }

    private WebAppWizardIterator() {
    }

    public void initialize(TemplateWizard tw) {
        if (this.arrayIterator == null) {
            this.wizardData = new WebAppObject.WizardData();
            WizardDescriptor.Panel[] panelArray = new WizardDescriptor.Panel[]{new BaseWizardPanel(this.wizardData)};
            this.arrayIterator = new WizardDescriptor.ArrayIterator(panelArray);
        }
    }

    public void uninitialize(TemplateWizard tw) {
    }

    public WizardDescriptor.Panel current() {
        return this.arrayIterator.current();
    }

    public boolean hasNext() {
        return this.arrayIterator.hasNext();
    }

    public boolean hasPrevious() {
        return this.arrayIterator.hasNext();
    }

    public synchronized void nextPanel() {
        this.arrayIterator.nextPanel();
    }

    public synchronized void previousPanel() {
        this.arrayIterator.previousPanel();
    }

    public void addChangeListener(ChangeListener l) {
        this.arrayIterator.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.arrayIterator.removeChangeListener(l);
    }

    public String name() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$web$context$WebAppWizardIterator == null ? (class$org$netbeans$modules$web$context$WebAppWizardIterator = WebAppWizardIterator.class$("org.netbeans.modules.web.context.WebAppWizardIterator")) : class$org$netbeans$modules$web$context$WebAppWizardIterator), (String)"NewWebModuleMountWizardPanel.Title");
    }

    public boolean validateDocumentPath() {
        String documentBasePath = this.wizardData.getDocumentBasePath();
        File file = new File(documentBasePath);
        if (file.exists()) {
            if (file.isDirectory()) {
                return true;
            }
            Object[] args = new Object[]{documentBasePath};
            NewWebModuleMountWizardPanel.showErrorMessageI18N("MSG_NewWebModuleMountWizard.InvalidMountDirectory", args);
            return false;
        }
        boolean success = file.mkdirs();
        if (success) {
            return true;
        }
        Object[] args = new Object[]{documentBasePath};
        NewWebModuleMountWizardPanel.showErrorMessageI18N("MSG_NewWebModuleMountWizard.InvalidMountDirectory", args);
        return false;
    }

    public Set instantiate(TemplateWizard wiz) throws IOException {
        String documentBasePath = this.wizardData.getDocumentBasePath();
        if (documentBasePath == null || documentBasePath.length() <= 0 || !this.validateDocumentPath()) {
            return Collections.EMPTY_SET;
        }
        LocalFileSystem localFS = null;
        LocalFileSystem webModuleFS = null;
        File f = new File(documentBasePath);
        if (f != null && f.isDirectory()) {
            localFS = new LocalFileSystem();
            try {
                try {
                    f = f.getCanonicalFile();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                localFS.setRootDirectory(f);
                Repository r = Repository.getDefault();
                FileSystem existingFS = this.findAlreadyMountedFileSystem(r, (FileSystem)localFS);
                if (existingFS == null) {
                    webModuleFS = localFS;
                } else {
                    if (WebContextLoader.isWebApplication(existingFS)) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$web$context$WebAppWizardIterator == null ? (class$org$netbeans$modules$web$context$WebAppWizardIterator = WebAppWizardIterator.class$("org.netbeans.modules.web.context.WebAppWizardIterator")) : class$org$netbeans$modules$web$context$WebAppWizardIterator), (String)"MGS_WebModuleAlreadyMounted", (Object)documentBasePath), 1));
                        return Collections.EMPTY_SET;
                    }
                    webModuleFS = existingFS;
                }
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            catch (PropertyVetoException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        Object webContextObj = null;
        if (webModuleFS != null) {
            this.wizardData.setDocumentBase((FileSystem)webModuleFS);
            TemplateWizard tw = wiz;
            DataFolder projectFolder = WebContextObject.projectFolder();
            if (projectFolder != null) {
                tw.setTargetFolder(projectFolder);
            }
            tw.setTargetName(this.wizardData.getDocumentBase().getSystemName());
            if (WebContextLoader.isOrCanBeWebApplication(webModuleFS)) {
                WebContextLoader.convert((FileSystem)webModuleFS);
            }
        }
        if (webContextObj == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.singleton(webContextObj);
    }

    public FileSystem findAlreadyMountedFileSystem(Repository r, FileSystem targetFs) throws IOException {
        FileObject targetRoot = targetFs.getRoot();
        String targetDisplayName = targetFs.getDisplayName();
        String targetSystemName = targetFs.getSystemName();
        File targetFile = NbClassPath.toFile((FileObject)targetRoot);
        String targetFileCan = targetFile.getCanonicalPath();
        Enumeration fsen = r.fileSystems();
        while (fsen.hasMoreElements()) {
            File fsFile;
            FileSystem fs = (FileSystem)fsen.nextElement();
            boolean hidden = fs.isHidden();
            if (hidden || (fsFile = NbClassPath.toFile((FileObject)fs.getRoot())) == null) continue;
            String fsFileCan = fsFile.getCanonicalPath();
            if (targetFileCan.equals(fsFileCan)) {
                return fs;
            }
            String sn = fs.getSystemName();
            if (targetSystemName.equals(sn)) {
                return fs;
            }
            String dn = fs.getDisplayName();
            if (targetDisplayName.equals(dn)) {
                return fs;
            }
            if (!targetSystemName.equals(dn)) continue;
            return fs;
        }
        return null;
    }

    public static WebAppWizardIterator singleton() {
        if (singletonInstance == null) {
            singletonInstance = new WebAppWizardIterator();
        }
        return singletonInstance;
    }

    public Object readResolve() throws ObjectStreamException {
        return WebAppWizardIterator.singleton();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

