/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.context;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.web.context.WebShadowChangeAdapter;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class WebBrokenDataShadow
extends DataObject {
    private String origFSName;
    private static WebShadowChangeAdapter changeAdaptor;
    private String origFOName;
    private static Set allDataShadows;
    private static ReferenceQueue rqueue;
    private static final long serialVersionUID = -3046981691235483810L;
    static /* synthetic */ Class class$org$netbeans$modules$web$context$WebBrokenDataShadow;
    static /* synthetic */ Class class$org$netbeans$modules$web$context$WebAppLoader;

    public WebBrokenDataShadow(FileObject fo, DataLoader loader) throws DataObjectExistsException {
        super(fo, loader);
        try {
            BufferedReader ois = new BufferedReader(new InputStreamReader(fo.getInputStream()));
            this.origFOName = ois.readLine();
            this.origFSName = ois.readLine();
            ois.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        WebBrokenDataShadow.enqueueBrokenDataShadow(this);
    }

    private static Set getDataShadowsSet() {
        if (allDataShadows == null) {
            Class clazz = class$org$netbeans$modules$web$context$WebBrokenDataShadow == null ? (class$org$netbeans$modules$web$context$WebBrokenDataShadow = WebBrokenDataShadow.class$("org.netbeans.modules.web.context.WebBrokenDataShadow")) : class$org$netbeans$modules$web$context$WebBrokenDataShadow;
            synchronized (clazz) {
                if (allDataShadows == null) {
                    allDataShadows = new HashSet();
                }
            }
        }
        return allDataShadows;
    }

    private static ReferenceQueue getRqueue() {
        if (rqueue == null) {
            Class clazz = class$org$netbeans$modules$web$context$WebBrokenDataShadow == null ? (class$org$netbeans$modules$web$context$WebBrokenDataShadow = WebBrokenDataShadow.class$("org.netbeans.modules.web.context.WebBrokenDataShadow")) : class$org$netbeans$modules$web$context$WebBrokenDataShadow;
            synchronized (clazz) {
                if (rqueue == null) {
                    rqueue = new ReferenceQueue();
                }
            }
        }
        return rqueue;
    }

    private static void checkQueue() {
        if (rqueue == null) {
            return;
        }
        Reference ref = rqueue.poll();
        while (ref != null) {
            WebBrokenDataShadow.getDataShadowsSet().remove(ref);
            ref = rqueue.poll();
        }
    }

    private static synchronized void enqueueBrokenDataShadow(WebBrokenDataShadow ds) {
        WebBrokenDataShadow.checkQueue();
        WebBrokenDataShadow.initAdapter();
        WebBrokenDataShadow.getDataShadowsSet().add(WebBrokenDataShadow.createReference((Object)ds, WebBrokenDataShadow.getRqueue()));
    }

    private static synchronized void initAdapter() {
        if (changeAdaptor == null) {
            changeAdaptor = new WebShadowChangeAdapter();
        }
    }

    static Reference createReference(Object ds, ReferenceQueue q) {
        return new DSWeakReference(ds, q);
    }

    private static synchronized List getAllDataShadows() {
        Set allShadows = allDataShadows;
        if (allShadows == null || allShadows.isEmpty()) {
            return null;
        }
        ArrayList ret = new ArrayList(allShadows.size());
        Iterator it = allShadows.iterator();
        while (it.hasNext()) {
            Reference ref = (Reference)it.next();
            Object shadow = ref.get();
            if (shadow == null) continue;
            ret.add(shadow);
        }
        return ret;
    }

    static void checkValidity(EventObject ev) {
        List all = WebBrokenDataShadow.getAllDataShadows();
        if (all == null) {
            return;
        }
        int size = all.size();
        int i = 0;
        while (i < size) {
            Object obj = all.get(i);
            ((WebBrokenDataShadow)((Object)obj)).refresh();
            ++i;
        }
    }

    private WebBrokenDataShadow(FileObject fo) throws DataObjectExistsException {
        this(fo, DataLoader.getLoader((Class)(class$org$netbeans$modules$web$context$WebAppLoader == null ? (class$org$netbeans$modules$web$context$WebAppLoader = WebBrokenDataShadow.class$("org.netbeans.modules.web.context.WebAppLoader")) : class$org$netbeans$modules$web$context$WebAppLoader)));
    }

    public boolean isDeleteAllowed() {
        return !this.getPrimaryFile().isReadOnly();
    }

    public void refresh() {
        try {
            if (WebBrokenDataShadow.checkOriginal(this.origFOName, this.origFSName) != null) {
                this.setValid(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static FileObject checkOriginal(String strFile, String strFS) throws IOException {
        Repository rep = Repository.getDefault();
        FileSystem fileSystem = strFS != null ? rep.findFileSystem(strFS) : null;
        FileObject fo = fileSystem != null ? fileSystem.findResource(strFile) : null;
        if (fo == null) {
            throw new FileNotFoundException(strFile);
        }
        return fo;
    }

    public boolean isCopyAllowed() {
        return true;
    }

    public boolean isMoveAllowed() {
        return !this.getPrimaryFile().isReadOnly();
    }

    public boolean isRenameAllowed() {
        return !this.getPrimaryFile().isReadOnly();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected DataObject handleCopy(DataFolder f) throws IOException {
        return this.handleCreateFromTemplate(f, this.getName());
    }

    protected void handleDelete() throws IOException {
        FileLock lock = this.getPrimaryFile().lock();
        try {
            this.getPrimaryFile().delete(lock);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.releaseLock();
            throw throwable;
        }
        lock.releaseLock();
    }

    protected FileObject handleRename(String name) throws IOException {
        FileLock lock = this.getPrimaryFile().lock();
        try {
            this.getPrimaryFile().rename(lock, name, this.getPrimaryFile().getExt());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.releaseLock();
            throw throwable;
        }
        lock.releaseLock();
        return this.getPrimaryFile();
    }

    protected FileObject handleMove(DataFolder f) throws IOException {
        String name = FileUtil.findFreeFileName((FileObject)f.getPrimaryFile(), (String)this.getName(), (String)this.getPrimaryFile().getExt());
        return FileUtil.moveFile((FileObject)this.getPrimaryFile(), (FileObject)f.getPrimaryFile(), (String)name);
    }

    protected DataObject handleCreateFromTemplate(DataFolder f, String name) throws IOException {
        if (name == null) {
            name = this.getName();
        }
        name = FileUtil.findFreeFileName((FileObject)f.getPrimaryFile(), (String)name, (String)this.getPrimaryFile().getExt());
        return new WebBrokenDataShadow(FileUtil.copyFile((FileObject)this.getPrimaryFile(), (FileObject)f.getPrimaryFile(), (String)name));
    }

    protected Node createNodeDelegate() {
        return new BrokenShadowNode(this);
    }

    String getOrigFileSystem() {
        return this.origFSName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class DSWeakReference
    extends WeakReference {
        private int hash;

        DSWeakReference(Object o, ReferenceQueue rqueue) {
            super(o, rqueue);
            this.hash = o.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            Object mine = this.get();
            if (mine == null) {
                return false;
            }
            if (o instanceof DSWeakReference) {
                DSWeakReference him = (DSWeakReference)o;
                return mine.equals(him.get());
            }
            return false;
        }
    }

    private static final class BrokenShadowNode
    extends DataNode {
        private static MessageFormat format;
        private Sheet sheet;
        private static final String ICON_NAME = "org/openide/resources/brokenShadow";
        static /* synthetic */ Class class$org$openide$loaders$DataObject;
        static /* synthetic */ Class class$org$openide$actions$DeleteAction;
        static /* synthetic */ Class class$org$openide$actions$ToolsAction;
        static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

        public BrokenShadowNode(WebBrokenDataShadow par) {
            super((DataObject)par, Children.LEAF);
            this.setIconBase(ICON_NAME);
        }

        public String getDisplayName() {
            if (format == null) {
                format = new MessageFormat(NbBundle.getMessage((Class)(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = BrokenShadowNode.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject), (String)"PROP_brokenShadowFileSystem"));
            }
            return format.format(this.createArguments());
        }

        protected SystemAction[] createActions() {
            return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = BrokenShadowNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = BrokenShadowNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = BrokenShadowNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }

        public Node.PropertySet[] getPropertySets() {
            if (this.sheet == null) {
                this.sheet = this.cloneSheet();
            }
            return this.sheet.toArray();
        }

        private Sheet cloneSheet() {
            Node.PropertySet[] sets = super.getPropertySets();
            Sheet s = new Sheet();
            int i = 0;
            while (i < sets.length) {
                Sheet.Set ss = new Sheet.Set();
                ss.put(sets[i].getProperties());
                ss.setName(sets[i].getName());
                ss.setDisplayName(sets[i].getDisplayName());
                ss.setShortDescription(sets[i].getShortDescription());
                this.modifySheetSet(ss);
                s.put(ss);
                ++i;
            }
            return s;
        }

        private void modifySheetSet(Sheet.Set ss) {
            Object p = ss.remove("name");
            if (p != null) {
                p = new PropertySupport.Name((Node)this);
                ss.put(p);
                p = new Name();
                ss.put(p);
                p = new FileSystemProperty();
                ss.put(p);
            }
        }

        private Object[] createArguments() {
            return new Object[]{this.getDataObject().getName()};
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        private final class FileSystemProperty
        extends PropertySupport.ReadOnly {
            static /* synthetic */ Class class$java$lang$String;
            static /* synthetic */ Class class$org$openide$loaders$DataObject;

            public FileSystemProperty() {
                super("BrokenLinkFileSystem", class$java$lang$String == null ? (class$java$lang$String = FileSystemProperty.class$("java.lang.String")) : class$java$lang$String, NbBundle.getMessage((Class)(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = FileSystemProperty.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject), (String)"PROP_brokenShadowFileSystem"), NbBundle.getMessage((Class)(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = FileSystemProperty.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject), (String)"HINT_brokenShadowFileSystem"));
            }

            public Object getValue() {
                WebBrokenDataShadow bds = (WebBrokenDataShadow)BrokenShadowNode.this.getDataObject();
                return bds.origFSName;
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }

        private final class Name
        extends PropertySupport.ReadWrite {
            static /* synthetic */ Class class$java$lang$String;
            static /* synthetic */ Class class$org$openide$loaders$DataObject;

            public Name() {
                super("BrokenLink", class$java$lang$String == null ? (class$java$lang$String = Name.class$("java.lang.String")) : class$java$lang$String, NbBundle.getMessage((Class)(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = Name.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject), (String)"PROP_brokenShadowOriginalName"), NbBundle.getMessage((Class)(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = Name.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject), (String)"HINT_brokenShadowOriginalName"));
            }

            public Object getValue() {
                WebBrokenDataShadow bds = (WebBrokenDataShadow)BrokenShadowNode.this.getDataObject();
                return bds.origFOName;
            }

            public void setValue(Object val) {
            }

            public boolean canWrite() {
                return false;
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }
    }
}

