/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.context;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Enumeration;
import org.netbeans.modules.web.context.WebAppObject;
import org.netbeans.modules.web.context.WebContextObject;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class WebContextLoader
extends DataLoader {
    private static final long serialVersionUID = -9190870926606500641L;
    static /* synthetic */ Class class$org$netbeans$modules$web$context$WebContextLoader;
    static /* synthetic */ Class class$org$openide$actions$OpenLocalExplorerAction;
    static /* synthetic */ Class class$org$openide$actions$FindAction;
    static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
    static /* synthetic */ Class class$org$openide$actions$ExecuteAction;
    static /* synthetic */ Class class$org$netbeans$modules$web$execution$ExecuteForceReloadAction;
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$impl$DeployAction;
    static /* synthetic */ Class class$org$openide$actions$CompileAction;
    static /* synthetic */ Class class$org$openide$actions$CompileAllAction;
    static /* synthetic */ Class class$org$openide$actions$BuildAction;
    static /* synthetic */ Class class$org$openide$actions$BuildAllAction;
    static /* synthetic */ Class class$org$netbeans$modules$web$context$actions$PackageWarAction;
    static /* synthetic */ Class class$org$netbeans$modules$web$war$actions$ViewContentWarAction;
    static /* synthetic */ Class class$org$netbeans$modules$web$context$actions$ExtraWebAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$RenameAction;
    static /* synthetic */ Class class$org$openide$actions$NewTemplateAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

    public WebContextLoader() {
        super("org.netbeans.modules.web.context.WebContextObject");
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$web$context$WebContextLoader == null ? (class$org$netbeans$modules$web$context$WebContextLoader = WebContextLoader.class$("org.netbeans.modules.web.context.WebContextLoader")) : class$org$netbeans$modules$web$context$WebContextLoader), (String)"PROP_WebContextLoader_Name");
    }

    public static void install() {
        WebContextLoader.findWebApps();
    }

    protected DataObject handleFindDataObject(FileObject fo, DataLoader.RecognizedFiles rf) throws IOException {
        if (fo.getParent() == null) {
            try {
                FileSystem fs = fo.getFileSystem();
                if (WebContextLoader.isWebApplication(fs) && WebContextLoader.canBeContext(fs)) {
                    return new WebContextObject(fo, this);
                }
            }
            catch (FileStateInvalidException e) {
                return null;
            }
            catch (IllegalArgumentException iae) {
                ErrorManager.getDefault().notify(1, (Throwable)iae);
                return null;
            }
        }
        return null;
    }

    protected SystemAction[] defaultActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$OpenLocalExplorerAction == null ? (class$org$openide$actions$OpenLocalExplorerAction = WebContextLoader.class$("org.openide.actions.OpenLocalExplorerAction")) : class$org$openide$actions$OpenLocalExplorerAction)), SystemAction.get((Class)(class$org$openide$actions$FindAction == null ? (class$org$openide$actions$FindAction = WebContextLoader.class$("org.openide.actions.FindAction")) : class$org$openide$actions$FindAction)), SystemAction.get((Class)(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = WebContextLoader.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction)), null, SystemAction.get((Class)(class$org$openide$actions$ExecuteAction == null ? (class$org$openide$actions$ExecuteAction = WebContextLoader.class$("org.openide.actions.ExecuteAction")) : class$org$openide$actions$ExecuteAction)), SystemAction.get((Class)(class$org$netbeans$modules$web$execution$ExecuteForceReloadAction == null ? (class$org$netbeans$modules$web$execution$ExecuteForceReloadAction = WebContextLoader.class$("org.netbeans.modules.web.execution.ExecuteForceReloadAction")) : class$org$netbeans$modules$web$execution$ExecuteForceReloadAction)), SystemAction.get((Class)(class$org$netbeans$modules$j2ee$impl$DeployAction == null ? (class$org$netbeans$modules$j2ee$impl$DeployAction = WebContextLoader.class$("org.netbeans.modules.j2ee.impl.DeployAction")) : class$org$netbeans$modules$j2ee$impl$DeployAction)), null, SystemAction.get((Class)(class$org$openide$actions$CompileAction == null ? (class$org$openide$actions$CompileAction = WebContextLoader.class$("org.openide.actions.CompileAction")) : class$org$openide$actions$CompileAction)), SystemAction.get((Class)(class$org$openide$actions$CompileAllAction == null ? (class$org$openide$actions$CompileAllAction = WebContextLoader.class$("org.openide.actions.CompileAllAction")) : class$org$openide$actions$CompileAllAction)), null, SystemAction.get((Class)(class$org$openide$actions$BuildAction == null ? (class$org$openide$actions$BuildAction = WebContextLoader.class$("org.openide.actions.BuildAction")) : class$org$openide$actions$BuildAction)), SystemAction.get((Class)(class$org$openide$actions$BuildAllAction == null ? (class$org$openide$actions$BuildAllAction = WebContextLoader.class$("org.openide.actions.BuildAllAction")) : class$org$openide$actions$BuildAllAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$web$context$actions$PackageWarAction == null ? (class$org$netbeans$modules$web$context$actions$PackageWarAction = WebContextLoader.class$("org.netbeans.modules.web.context.actions.PackageWarAction")) : class$org$netbeans$modules$web$context$actions$PackageWarAction)), SystemAction.get((Class)(class$org$netbeans$modules$web$war$actions$ViewContentWarAction == null ? (class$org$netbeans$modules$web$war$actions$ViewContentWarAction = WebContextLoader.class$("org.netbeans.modules.web.war.actions.ViewContentWarAction")) : class$org$netbeans$modules$web$war$actions$ViewContentWarAction)), SystemAction.get((Class)(class$org$netbeans$modules$web$context$actions$ExtraWebAction == null ? (class$org$netbeans$modules$web$context$actions$ExtraWebAction = WebContextLoader.class$("org.netbeans.modules.web.context.actions.ExtraWebAction")) : class$org$netbeans$modules$web$context$actions$ExtraWebAction)), null, SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = WebContextLoader.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction)), SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = WebContextLoader.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction)), SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = WebContextLoader.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = WebContextLoader.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), SystemAction.get((Class)(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = WebContextLoader.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction)), null, SystemAction.get((Class)(class$org$openide$actions$NewTemplateAction == null ? (class$org$openide$actions$NewTemplateAction = WebContextLoader.class$("org.openide.actions.NewTemplateAction")) : class$org$openide$actions$NewTemplateAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = WebContextLoader.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = WebContextLoader.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    protected static void findWebApps() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    Enumeration fsen = Repository.getDefault().getFileSystems();
                    while (fsen.hasMoreElements()) {
                        WebContextLoader.checkAndAddFs((FileSystem)fsen.nextElement());
                    }
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify(16, (Throwable)e);
                }
            }
        });
    }

    private static void checkAndAddFs(FileSystem fs) throws Exception {
        if (WebContextLoader.isWebApplication(fs) && !fs.isHidden()) {
            try {
                DataObject.find((FileObject)fs.getRoot()).setValid(false);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    public static WebContextObject findContext(FileSystem fs) throws DataObjectNotFoundException {
        DataObject d = DataObject.find((FileObject)fs.getRoot());
        if (!(d instanceof WebContextObject)) {
            try {
                d.setValid(false);
            }
            catch (PropertyVetoException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            d = DataObject.find((FileObject)fs.getRoot());
        }
        if (d instanceof WebContextObject) {
            return (WebContextObject)d;
        }
        return null;
    }

    public static boolean isWebApplication(FileSystem documentBase) {
        if (documentBase == Repository.getDefault().getDefaultFileSystem()) {
            return false;
        }
        FileObject webinfFo = documentBase.findResource("WEB-INF");
        return webinfFo != null && !Boolean.TRUE.equals(webinfFo.getAttribute("pendingDelete")) && webinfFo.getFileObject("web.xml") != null;
    }

    public static boolean isWebApplication(DataObject dobj) {
        if (dobj == null) {
            return false;
        }
        if (dobj instanceof WebAppObject) {
            return ((WebAppObject)dobj).getContext() != null;
        }
        FileObject fo = dobj.getPrimaryFile();
        try {
            FileSystem fs = fo.getFileSystem();
            return fo.getParent() == null && WebContextLoader.isWebApplication(fs);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean canBeContext(FileSystem documentBase) {
        if (documentBase.isHidden() || documentBase.isReadOnly()) {
            return false;
        }
        return !(documentBase instanceof JarFileSystem);
    }

    public static boolean canBeWebApplication(FileSystem documentBase) {
        if (WebContextLoader.isWebApplication(documentBase)) {
            return false;
        }
        return WebContextLoader.isOrCanBeWebApplication(documentBase);
    }

    public static boolean isOrCanBeWebApplication(FileSystem documentBase) {
        if (documentBase == Repository.getDefault().getDefaultFileSystem()) {
            return false;
        }
        return WebContextLoader.canBeContext(documentBase);
    }

    public static void convert(FileSystem fs) throws IOException {
        Repository.getDefault().removeFileSystem(fs);
        WebContextObject.checkOrCreateWebContext(fs);
        Repository.getDefault().addFileSystem(fs);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

