/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.context;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.modules.j2ee.impl.ServerExecSupport;
import org.netbeans.modules.j2ee.impl.ServerInstanceData;
import org.netbeans.modules.j2ee.impl.ServerRegistryImpl;
import org.netbeans.modules.j2ee.impl.ServerUtilities;
import org.netbeans.modules.j2ee.server.Server;
import org.netbeans.modules.j2ee.server.ServerInstance;
import org.netbeans.modules.j2ee.server.datamodel.FileArchiveResource;
import org.netbeans.modules.j2ee.server.datamodel.J2eeAppStandardData;
import org.netbeans.modules.j2ee.server.datamodel.WebStandardData;
import org.netbeans.modules.jarpackager.JarDataObject;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.projects.CurrentProjectNode;
import org.netbeans.modules.web.context.DelegatingFileSystem;
import org.netbeans.modules.web.context.DelegatingFileSystemVcs;
import org.netbeans.modules.web.context.MountMessagePanel;
import org.netbeans.modules.web.context.ProjectViewManager;
import org.netbeans.modules.web.context.WebBrokenDataShadow;
import org.netbeans.modules.web.context.WebContextEvent;
import org.netbeans.modules.web.context.WebContextListener;
import org.netbeans.modules.web.context.WebContextObject;
import org.netbeans.modules.web.context.WebInfObject;
import org.netbeans.modules.web.context.WebModuleCookie;
import org.netbeans.modules.web.core.ServletSettings;
import org.netbeans.modules.web.core.jsploader.ServletSupport;
import org.netbeans.modules.web.dd.DDDataObject;
import org.netbeans.modules.web.war.WarPackagerSupport;
import org.netbeans.modules.web.webdata.WebDataFactory;
import org.netbeans.modules.web.webdata.WebModuleImpl;
import org.netbeans.modules.web.xmlutils.XMLJ2eeDataObject;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WebContextObject
extends DataFolder
implements ServerRegistryImpl.ServerRegistryListener,
PropertyChangeListener {
    public static final String VCS_PROVIDER_ATTRIBUTE = "VCS Provider";
    public static final String PROP_DOCBASE = "documentBase";
    public static final String PROP_APPNAME = "appName";
    public static final String FOLDER_WEB_INF = "WEB-INF";
    public static final String FOLDER_CLASSES = "classes";
    public static final String FOLDER_LIB = "lib";
    public static final String SUFFIX_JAR = "jar";
    public static final String SUFFIX_JAR_CONTENT = "jarContent";
    private static final String JAVA_EXT = "java";
    private static final String CLASS_EXT = "class";
    private static final String JAR_EXT = "jar";
    private static final String XML_EXT = "xml";
    private static final String TLD_EXT = "tld";
    private long timeOfLastWebModuleModification = 0L;
    private static final String ATTR_OLD_SERVER_INSTANCE_DATA = "ATTR_OLD_SERVER_INSTANCE_DATA";
    public static final String PROP_NEW_SERVER_INSTANCE = "PROP_NEW_SERVER_INSTANCE";
    private static final String WEB_MODULE_SHADOW_NAME = "WebApp";
    public static final String PROP_URI = "URI_CHANGE";
    private static transient Set listenerSet;
    private static transient WebContextPackager packager;
    private static ErrorManager err;
    private static final boolean debug;
    private static final boolean debuglisteners = false;
    private static final boolean debugdetail = false;
    private RequestProcessor.Task classesMounterTask;
    private static RequestProcessor fsMounter;
    private transient FileSystem documentBase;
    private transient FileObject classesDir;
    private transient FileObject libDir;
    private transient String appName;
    private transient FileSystem classesFS;
    private Hashtable libs = new Hashtable();
    private transient WebModuleCookie cookie;
    private transient ServerExecSupport serverExecSupport;
    private transient Set contextDeleteListenerSet = null;
    private LibMountingListener libListener = null;
    private WeakHashMap libListenerAddedTo = null;
    private transient DataObject oldWebAppDataObject = null;
    private DataObject deploymentDescriptor;
    private ClassesListener classesListener;
    private JspListener jspListener;
    private Object contextSetUpLock = new Object();
    private boolean contextSetUp = false;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$impl$ServerExecSupport;
    static /* synthetic */ Class class$org$netbeans$modules$web$context$WebModuleCookie;
    static /* synthetic */ Class class$org$netbeans$modules$web$core$ServletSettings;
    static /* synthetic */ Class class$org$netbeans$modules$web$context$WebContextObject;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$netbeans$modules$web$xmlutils$XMLJ2eeDataObject;
    static /* synthetic */ Class class$org$netbeans$modules$web$core$jsploader$ServletDataObject;
    static /* synthetic */ Class class$org$netbeans$modules$java$JavaDataObject;

    private static synchronized RequestProcessor requestProcessor() {
        if (fsMounter == null) {
            fsMounter = new RequestProcessor("webFS-mounter");
        }
        return fsMounter;
    }

    static DataFolder projectFolder() {
        try {
            CurrentProjectNode prjNode = CurrentProjectNode.getDefault();
            return (DataFolder)prjNode.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = WebContextObject.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
        }
        catch (Exception e) {
            ErrorManager em = ErrorManager.getDefault();
            em.annotate((Throwable)e, "Files folder of current project cannot be found");
            em.notify(1, (Throwable)e);
            return null;
        }
    }

    public WebContextObject(FileObject fo, DataLoader dl) throws IOException {
        super(fo, dl);
        this.documentBase = fo.getFileSystem();
        this.init(fo);
    }

    private void init(FileObject fo) throws IOException {
        if (debug) {
            err.log(1, "WebContextObject[" + this.documentBase + "]:: init()");
        }
        if (this.isMounted()) {
            if (debug) {
                err.log(1, "WebContextObject[" + this.documentBase + "]:: registering in ProjectViewManager()");
            }
            ProjectViewManager.getDefault().notifyWebContext(fo.getFileSystem(), this);
        }
    }

    public String debugToString() {
        try {
            FileSystem fs = this.getPrimaryFile().getFileSystem();
            return "WebContextObject:  " + this + "\n" + "   fs     : " + fs.getSystemName() + "\n" + "   valid  : " + this.isValid() + "\n" + "   mounted: " + this.isMounted() + "\n";
        }
        catch (FileStateInvalidException e) {
            e.printStackTrace();
            return this.toString();
        }
    }

    private boolean isMounted() throws FileStateInvalidException {
        FileSystem fs2;
        FileSystem fs = this.getPrimaryFile().getFileSystem();
        return fs == (fs2 = Repository.getDefault().findFileSystem(fs.getSystemName()));
    }

    public void setupContext() throws IOException {
        Object object = this.contextSetUpLock;
        synchronized (object) {
            if (this.contextSetUp) {
                return;
            }
            this.contextSetUp = true;
            WebContextObject.checkOrCreateWebContext(this.documentBase);
            if (debug) {
                err.log(1, "WebContextObject[" + this.documentBase + "]:: setupContext()");
            }
            this.addLibraryListener();
            this.addServerChangesListeners();
            this.addWebAppChangesListeners();
            this.addJSPListener();
            this.classesMounterTask = RequestProcessor.postRequest((Runnable)new Runnable(){

                public void run() {
                    try {
                        WebContextObject.this.mountClasses();
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                    WebContextObject.this.classesMounterTask = null;
                    WebContextObject.this.mountAllLibs();
                    WebContextObject.this.mkProjectView();
                }
            });
            if (debug) {
                err.log(1, "WebContextObject[" + this.documentBase + "]:: setupContext() - ok");
            }
        }
    }

    public void associateClassesFS() {
        if (this.classesFS == null) {
            try {
                Enumeration en = Repository.getDefault().getFileSystems();
                FileSystem myFs = this.getPrimaryFile().getFileSystem();
                String mySysName = myFs.getSystemName();
                while (en.hasMoreElements()) {
                    FileSystem fs = (FileSystem)en.nextElement();
                    if (!(fs instanceof DelegatingFileSystem) || !((DelegatingFileSystem)fs).delegateeFsName.equals(mySysName)) continue;
                    this.setClassesFS(fs);
                    break;
                }
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    public File getWarFile() {
        return WebContextObject.getPackager().getResource(this, null, null).getFile();
    }

    public void destroyContext() {
        if (debug) {
            err.log(1, "WebContextObject[" + this.documentBase + "]:: disable()");
        }
        this.removeProjectView();
        this.unmountFS();
        this.removeLibraryListener();
        this.removeServerChangesListeners();
        this.removeWebAppChangesListeners();
        this.removeContextDeleteListeners();
        this.removeJSPListener();
        this.removeClassesListener();
        if (debug) {
            err.log(1, "WebContextObject[" + this.documentBase + "]:: disabled()");
        }
    }

    public void handleDelete() {
        if (debug) {
            err.log(1, "WebContextObject[" + this.documentBase + "]:: handleDelete()");
        }
        this.fireWebContextDeleteEvent();
    }

    public void handleWebInfDelete() {
        if (debug) {
            err.log(1, "WebContextObject[" + this.documentBase + "]:: handleWebInfDelete()");
        }
        this.fireWebContextDeleteEvent();
    }

    public Node.Cookie getCookie(Class cls) {
        if (cls.isAssignableFrom(class$org$netbeans$modules$j2ee$impl$ServerExecSupport == null ? (class$org$netbeans$modules$j2ee$impl$ServerExecSupport = WebContextObject.class$("org.netbeans.modules.j2ee.impl.ServerExecSupport")) : class$org$netbeans$modules$j2ee$impl$ServerExecSupport)) {
            return this.getServerExecSupport();
        }
        if (cls.isAssignableFrom(class$org$netbeans$modules$web$context$WebModuleCookie == null ? (class$org$netbeans$modules$web$context$WebModuleCookie = WebContextObject.class$("org.netbeans.modules.web.context.WebModuleCookie")) : class$org$netbeans$modules$web$context$WebModuleCookie)) {
            return this.getWebModuleCookie();
        }
        return super.getCookie(cls);
    }

    private ServerExecSupport getServerExecSupport() {
        if (this.serverExecSupport == null) {
            this.serverExecSupport = new ServerExecSupport((DataObject)this);
            this.serverExecSupport.addPropertyChangeListener((PropertyChangeListener)this);
        }
        return this.serverExecSupport;
    }

    private void removeProjectView() {
        FileObject prjV = this.projectView();
        if (prjV != null) {
            try {
                DataObject.find((FileObject)prjV).delete();
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    private void mkProjectView() {
        if (this.projectView() == null) {
            DataFolder projectFolder = WebContextObject.projectFolder();
            if (projectFolder == null) {
                ErrorManager.getDefault().log(1, "Cannot create project view of web module.");
                return;
            }
            try {
                ServletSettings setting;
                if (this.handleCreateShadow(projectFolder) != null && (setting = (ServletSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$web$core$ServletSettings == null ? (class$org$netbeans$modules$web$core$ServletSettings = WebContextObject.class$("org.netbeans.modules.web.core.ServletSettings")) : class$org$netbeans$modules$web$core$ServletSettings), (boolean)true)).getShowMessageDialog()) {
                    this.showNotifyDialog();
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            catch (NullPointerException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            this.checkServlets();
        }
    }

    private FileObject projectView() {
        DataFolder projectFolder = WebContextObject.projectFolder();
        if (projectFolder == null) {
            return null;
        }
        Enumeration en = projectFolder.children();
        while (en.hasMoreElements()) {
            String orig;
            DataObject dobj = (DataObject)en.nextElement();
            if (dobj instanceof WebBrokenDataShadow) {
                orig = ((WebBrokenDataShadow)dobj).getOrigFileSystem();
                try {
                    if (this.getPrimaryFile().getFileSystem().getSystemName().equals(orig)) {
                        return dobj.getPrimaryFile();
                    }
                }
                catch (FileStateInvalidException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
            if (!(dobj instanceof DataShadow) || !this.equals(orig = ((DataShadow)dobj).getOriginal())) continue;
            return dobj.getPrimaryFile();
        }
        return null;
    }

    protected DataShadow handleCreateShadow(DataFolder df) throws IOException {
        String name = FileUtil.findFreeFileName((FileObject)df.getPrimaryFile(), (String)WEB_MODULE_SHADOW_NAME, (String)"warImage");
        return DataShadow.create((DataFolder)df, (String)name, (DataObject)this, (String)"warImage");
    }

    private static String readResource(String resourceName, ClassLoader cl) throws IOException {
        StringBuffer sb = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        BufferedReader br = new BufferedReader(new InputStreamReader(cl.getResourceAsStream(resourceName)));
        String line = br.readLine();
        while (line != null) {
            sb.append(line);
            sb.append(lineSep);
            line = br.readLine();
        }
        br.close();
        return sb.toString();
    }

    public static void checkOrCreateWebContext(FileSystem fs) throws IOException {
        FileObject webXML;
        FileObject libDir;
        FileObject classesDir;
        Vector<String> warnings = new Vector<String>();
        boolean shouldPutIn = false;
        boolean alreadyAsked = false;
        FileObject webInf = fs.find(FOLDER_WEB_INF, null, null);
        if (webInf == null) {
            if (!alreadyAsked) {
                alreadyAsked = true;
                shouldPutIn = WebContextObject.shouldPutIntoClearCase(fs);
            }
            try {
                webInf = WebContextObject.createFolderClearCaseHack(fs.getRoot(), FOLDER_WEB_INF, shouldPutIn);
            }
            catch (IOException fx1) {
                ErrorManager.getDefault().notify(1, (Throwable)fx1);
                warnings.addElement(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$context$WebContextObject == null ? (class$org$netbeans$modules$web$context$WebContextObject = WebContextObject.class$("org.netbeans.modules.web.context.WebContextObject")) : class$org$netbeans$modules$web$context$WebContextObject), (String)"MSG_WARNING_CannotCreateWEBINF"));
            }
        }
        if ((classesDir = fs.find("WEB-INF.classes", null, null)) == null) {
            if (!alreadyAsked) {
                alreadyAsked = true;
                shouldPutIn = WebContextObject.shouldPutIntoClearCase(fs);
            }
            try {
                if (webInf != null) {
                    classesDir = WebContextObject.createFolderClearCaseHack(webInf, FOLDER_CLASSES, shouldPutIn);
                }
            }
            catch (IOException fx1) {
                ErrorManager.getDefault().notify(1, (Throwable)fx1);
                warnings.addElement(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$context$WebContextObject == null ? (class$org$netbeans$modules$web$context$WebContextObject = WebContextObject.class$("org.netbeans.modules.web.context.WebContextObject")) : class$org$netbeans$modules$web$context$WebContextObject), (String)"MSG_WARNING_CannotCreateWEBINFclasses"));
            }
        }
        if ((libDir = fs.find("WEB-INF.lib", null, null)) == null) {
            if (!alreadyAsked) {
                alreadyAsked = true;
                shouldPutIn = WebContextObject.shouldPutIntoClearCase(fs);
            }
            try {
                if (webInf != null) {
                    libDir = WebContextObject.createFolderClearCaseHack(webInf, FOLDER_LIB, shouldPutIn);
                }
            }
            catch (IOException fx1) {
                ErrorManager.getDefault().notify(1, (Throwable)fx1);
                warnings.addElement(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$context$WebContextObject == null ? (class$org$netbeans$modules$web$context$WebContextObject = WebContextObject.class$("org.netbeans.modules.web.context.WebContextObject")) : class$org$netbeans$modules$web$context$WebContextObject), (String)"MSG_WARNING_CannotCreateWEBINFlib"));
            }
        }
        if ((webXML = fs.find(FOLDER_WEB_INF, "web", XML_EXT)) == null && webInf != null) {
            String webXMLContent = WebContextObject.readResource("org/netbeans/modules/web/core/resources/web.xml", (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = WebContextObject.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader));
            webXML = FileUtil.createData((FileObject)webInf, (String)"web.xml");
            FileLock lock = webXML.lock();
            try {
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(webXML.getOutputStream(lock)));
                bw.write(webXMLContent);
                bw.close();
                Object var12_14 = null;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                lock.releaseLock();
                throw throwable;
            }
            lock.releaseLock();
            {
            }
        }
        if (warnings.size() > 0) {
            File f = FileUtil.toFile((FileObject)fs.getRoot());
            String p = f.getCanonicalPath();
            StringBuffer buf = new StringBuffer(256);
            Enumeration en = warnings.elements();
            while (en.hasMoreElements()) {
                String w = (String)en.nextElement();
                buf.append(w);
                buf.append("\n");
            }
            String msg = NbBundle.getMessage((Class)(class$org$netbeans$modules$web$context$WebContextObject == null ? (class$org$netbeans$modules$web$context$WebContextObject = WebContextObject.class$("org.netbeans.modules.web.context.WebContextObject")) : class$org$netbeans$modules$web$context$WebContextObject), (String)"MSG_WARNING_WebContextWarnings", (Object)p, (Object)buf.toString());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 1));
        }
    }

    public static FileObject createFolderClearCaseHack(FileObject folder, String name, boolean putToVCS) throws IOException {
        FileObject result = null;
        if (putToVCS) {
            String folderName = folder.getPath();
            if (folderName.length() > 0 && !folderName.endsWith("/")) {
                folderName = folderName + "/";
            }
            folderName = folderName + name;
            folder.getFileSystem().getRoot().setAttribute("VCS_MKDIR_ACTION", (Object)folderName);
            folder.refresh();
            result = folder.getFileObject(name);
        }
        if (result == null) {
            result = FileUtil.createFolder((FileObject)folder, (String)name);
        }
        return result;
    }

    public static boolean shouldPutIntoClearCase(FileSystem fs) {
        FileObject root = fs.getRoot();
        if ("ClearCase".equals(root.getAttribute("FS_DISPLAY_NAME"))) {
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$web$context$WebContextObject == null ? (class$org$netbeans$modules$web$context$WebContextObject = WebContextObject.class$("org.netbeans.modules.web.context.WebContextObject")) : class$org$netbeans$modules$web$context$WebContextObject), (String)"MSG_PutIntoClearCase"), 0);
            JButton button1 = new JButton();
            button1.setText(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$context$WebContextObject == null ? (class$org$netbeans$modules$web$context$WebContextObject = WebContextObject.class$("org.netbeans.modules.web.context.WebContextObject")) : class$org$netbeans$modules$web$context$WebContextObject), (String)"MSG_PutIntoClearCaseYes"));
            button1.setToolTipText(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$context$WebContextObject == null ? (class$org$netbeans$modules$web$context$WebContextObject = WebContextObject.class$("org.netbeans.modules.web.context.WebContextObject")) : class$org$netbeans$modules$web$context$WebContextObject), (String)"MSG_PutIntoClearCaseYes_Tooltip"));
            button1.setMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$context$WebContextObject == null ? (class$org$netbeans$modules$web$context$WebContextObject = WebContextObject.class$("org.netbeans.modules.web.context.WebContextObject")) : class$org$netbeans$modules$web$context$WebContextObject), (String)"MSG_PutIntoClearCaseYes_MNEM").charAt(0));
            button1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$context$WebContextObject == null ? (class$org$netbeans$modules$web$context$WebContextObject = WebContextObject.class$("org.netbeans.modules.web.context.WebContextObject")) : class$org$netbeans$modules$web$context$WebContextObject), (String)"MSG_PutIntoClearCaseYes_Tooltip"));
            button1.setDefaultCapable(false);
            JButton button2 = new JButton();
            button2.setText(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$context$WebContextObject == null ? (class$org$netbeans$modules$web$context$WebContextObject = WebContextObject.class$("org.netbeans.modules.web.context.WebContextObject")) : class$org$netbeans$modules$web$context$WebContextObject), (String)"MSG_PutIntoClearCaseNo"));
            button2.setToolTipText(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$context$WebContextObject == null ? (class$org$netbeans$modules$web$context$WebContextObject = WebContextObject.class$("org.netbeans.modules.web.context.WebContextObject")) : class$org$netbeans$modules$web$context$WebContextObject), (String)"MSG_PutIntoClearCaseNo_Tooltip"));
            button2.setMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$context$WebContextObject == null ? (class$org$netbeans$modules$web$context$WebContextObject = WebContextObject.class$("org.netbeans.modules.web.context.WebContextObject")) : class$org$netbeans$modules$web$context$WebContextObject), (String)"MSG_PutIntoClearCaseNo_MNEM").charAt(0));
            button2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$context$WebContextObject == null ? (class$org$netbeans$modules$web$context$WebContextObject = WebContextObject.class$("org.netbeans.modules.web.context.WebContextObject")) : class$org$netbeans$modules$web$context$WebContextObject), (String)"MSG_PutIntoClearCaseNo_Tooltip"));
            button2.setDefaultCapable(false);
            nd.setOptions((Object[])new JButton[]{button1, button2});
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            return nd.getValue() == button1;
        }
        return false;
    }

    private static void addFS(final FileSystem fs) {
        WebContextObject.requestProcessor().post(new Runnable(){

            public void run() {
                try {
                    FileSystem oldFs = Repository.getDefault().findFileSystem(fs.getSystemName());
                    if (oldFs != null) {
                        Repository.getDefault().removeFileSystem(oldFs);
                    }
                    Repository.getDefault().addFileSystem(fs);
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
        });
    }

    static void removeFS(FileSystem fs) {
        if (debug) {
            err.log(1, "WebContextObject]:: removeFS " + fs);
        }
        FSRemover rem = new FSRemover(fs, null);
        WebContextObject.requestProcessor().post((Runnable)rem);
    }

    private void mountClasses() throws IOException {
        this.classesDir = this.documentBase.find("WEB-INF.classes", null, null);
        if (this.classesDir != null) {
            DelegatingFileSystem dfs = WebContextObject.createDelegatingFileSystem(this.classesDir);
            WebContextObject.mountFS((FileSystem)dfs, true);
        }
    }

    synchronized void setClassesFS(FileSystem newClassesFS) {
        this.removeClassesListener();
        this.classesFS = newClassesFS;
        this.addClassesListener();
    }

    private void addClassesListener() {
        if (this.classesFS != null) {
            this.classesListener = new ClassesListener();
            this.classesFS.addFileChangeListener((FileChangeListener)this.classesListener);
        }
    }

    private void removeClassesListener() {
        if (this.classesFS != null) {
            this.classesFS.removeFileChangeListener((FileChangeListener)this.classesListener);
            this.classesListener = null;
        }
    }

    private void addJSPListener() {
        this.jspListener = new JspListener();
        this.documentBase.addFileChangeListener((FileChangeListener)this.jspListener);
    }

    private void removeJSPListener() {
        this.documentBase.removeFileChangeListener((FileChangeListener)this.jspListener);
    }

    private static DelegatingFileSystem createDelegatingFileSystem(FileObject classes) throws IOException {
        if (classes == null || !classes.isFolder()) {
            throw new IllegalArgumentException("WEB-INF/classes is not folder");
        }
        Object vcs = null;
        try {
            BeanDescriptor bd;
            BeanInfo info = Utilities.getBeanInfo(classes.getFileSystem().getClass());
            if (info != null && (bd = info.getBeanDescriptor()) != null) {
                vcs = bd.getValue(VCS_PROVIDER_ATTRIBUTE);
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        if (!Boolean.TRUE.equals(vcs)) {
            return new DelegatingFileSystem(classes);
        }
        return new DelegatingFileSystemVcs(classes);
    }

    private synchronized void mountAllLibs() {
        FileObject libDir = this.getLibrariesFile();
        if (libDir == null) {
            return;
        }
        FileObject[] ch = libDir.getChildren();
        int i = 0;
        while (i < ch.length) {
            try {
                if (ch[i].hasExt("jar")) {
                    if (this.shouldJarFileBeMounted(ch[i])) {
                        this.mountLib(ch[i]);
                    }
                    this.fireWebContextEvent(new WebContextEvent(this, ch[i], true));
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            ++i;
        }
    }

    private boolean shouldJarFileBeMounted(FileObject jarFo) {
        if (!jarFo.hasExt("jar")) {
            return false;
        }
        FileObject jarContentFo = FileUtil.findBrother((FileObject)jarFo, (String)SUFFIX_JAR_CONTENT);
        if (jarContentFo == null) {
            return true;
        }
        try {
            DataObject dobj = DataObject.find((FileObject)jarContentFo);
            if (dobj instanceof JarDataObject) {
                JarDataObject jarDo = (JarDataObject)dobj;
                this.initializeLibListener();
                if (!this.libListenerAddedTo.containsKey(jarDo)) {
                    PropertyChangeListener wl = WeakListener.propertyChange((PropertyChangeListener)this.libListener, (Object)jarDo);
                    jarDo.addPropertyChangeListener(wl);
                    this.libListenerAddedTo.put(jarDo, wl);
                }
                return !jarDo.allValid();
            }
            return true;
        }
        catch (DataObjectNotFoundException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return true;
        }
    }

    private synchronized void initializeLibListener() {
        if (this.libListener == null) {
            this.libListener = new LibMountingListener();
            this.libListenerAddedTo = new WeakHashMap();
        }
    }

    private void addLibraryListener() {
        FileObject libDir = this.getLibrariesFile();
        this.initializeLibListener();
        if (libDir != null) {
            this.libListener.attachToLibDir(libDir);
        }
    }

    private void removeLibraryListener() {
        if (this.libListener != null) {
            this.libListener.dettachFromLibDir();
            this.libListener = null;
        }
    }

    private void fireWebContextEvent(WebContextEvent wce) {
        if (listenerSet != null) {
            Iterator i = listenerSet.iterator();
            while (i.hasNext()) {
                ((WebContextListener)i.next()).fireWebContextEvent(wce);
            }
        }
    }

    private void checkServlets() {
        try {
            DataObject dobj = this.getDeploymentDescriptor();
            XMLJ2eeDataObject dd = (XMLJ2eeDataObject)dobj.getCookie(class$org$netbeans$modules$web$xmlutils$XMLJ2eeDataObject == null ? (class$org$netbeans$modules$web$xmlutils$XMLJ2eeDataObject = WebContextObject.class$("org.netbeans.modules.web.xmlutils.XMLJ2eeDataObject")) : class$org$netbeans$modules$web$xmlutils$XMLJ2eeDataObject);
            if (dd == null) {
                return;
            }
            Document desc = dd.getDocument();
            if (desc == null) {
                return;
            }
            NodeList nodes = desc.getElementsByTagName("servlet-class");
            int i = 0;
            while (i < nodes.getLength()) {
                block9: {
                    String servletClazz;
                    int dot;
                    FileObject servletFO;
                    Node servletNode = nodes.item(i).getFirstChild();
                    if (servletNode instanceof Text && (servletFO = (dot = (servletClazz = ((Text)servletNode).getData()).lastIndexOf(46)) != -1 ? this.getClassesBase().find(servletClazz.substring(0, dot), servletClazz.substring(dot + 1), JAVA_EXT) : this.getClassesBase().find("", servletClazz, JAVA_EXT)) != null) {
                        DataObject servletDO;
                        try {
                            servletDO = DataObject.find((FileObject)servletFO);
                        }
                        catch (DataObjectNotFoundException e) {
                            break block9;
                        }
                        if (servletDO.getCookie(class$org$netbeans$modules$web$core$jsploader$ServletDataObject == null ? WebContextObject.class$("org.netbeans.modules.web.core.jsploader.ServletDataObject") : class$org$netbeans$modules$web$core$jsploader$ServletDataObject) == null && servletDO.getCookie(class$org$netbeans$modules$java$JavaDataObject == null ? WebContextObject.class$("org.netbeans.modules.java.JavaDataObject") : class$org$netbeans$modules$java$JavaDataObject) != null) {
                            ErrorManager.getDefault().log(1, NbBundle.getMessage((Class)(class$org$netbeans$modules$web$context$WebContextObject == null ? WebContextObject.class$("org.netbeans.modules.web.context.WebContextObject") : class$org$netbeans$modules$web$context$WebContextObject), (String)"MSG_ConvertingServlet", (Object)servletClazz));
                            ServletSupport.convertJavaToServlet((JavaDataObject)servletDO, false, false);
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
    }

    void unmountLib(FileObject lib) {
        FileSystem fs = this.removeLib(lib);
        if (fs != null) {
            WebContextObject.removeFS(fs);
        }
    }

    FileSystem removeLib(FileObject lib) {
        if (debug) {
            err.log(1, "WebContextObject[" + this.documentBase + "]::removeLib " + lib + " libs.size()=" + this.libs.size() + "\n                 libs.containskey(lib)=" + this.libs.containsKey(lib));
        }
        this.fireWebContextEvent(new WebContextEvent(this, lib, false));
        FileSystem fs = (FileSystem)this.libs.get(lib);
        this.libs.remove(lib);
        return fs;
    }

    public synchronized void mountLib(final FileObject lib) throws IOException {
        if (debug) {
            err.log(1, "WCO::mountlib: posting request for mountlib impl.");
        }
        WebContextObject.requestProcessor().post(new Runnable(){
            static /* synthetic */ Class class$org$netbeans$modules$web$context$WebContextObject;

            public void run() {
                block11: {
                    try {
                        WebContextObject.this.mountLibImpl(lib);
                    }
                    catch (Exception ex) {
                        String msg = ex.getLocalizedMessage();
                        if (msg.indexOf("{0}") > -1) {
                            String fmt;
                            Object[] args = new Object[1];
                            File f = FileUtil.toFile((FileObject)lib);
                            args[0] = null;
                            if (f != null) {
                                try {
                                    args[0] = f.getCanonicalPath();
                                }
                                catch (Exception oops) {
                                    // empty catch block
                                }
                            }
                            if (args[0] == null) {
                                args[0] = lib.toString();
                            }
                            msg = fmt = MessageFormat.format(msg, args);
                        }
                        String intro = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$context$WebContextObject == null ? (class$org$netbeans$modules$web$context$WebContextObject = 3.class$("org.netbeans.modules.web.context.WebContextObject")) : class$org$netbeans$modules$web$context$WebContextObject)).getString("CTL_MountJarError");
                        Object[] arggh = new Object[3];
                        File pf = FileUtil.toFile((FileObject)WebContextObject.this.getPrimaryFile());
                        if (pf != null) {
                            try {
                                arggh[0] = pf.getCanonicalPath();
                            }
                            catch (Exception hggra) {
                                // empty catch block
                            }
                        }
                        if (arggh[0] == null) {
                            arggh[0] = "";
                        }
                        arggh[1] = lib.toString();
                        arggh[2] = msg;
                        String fullMessage = MessageFormat.format(intro, arggh);
                        Throwable t = ErrorManager.getDefault().annotate((Throwable)ex, fullMessage);
                        ErrorManager.getDefault().notify(16, t);
                        if (!debug) break block11;
                        err.log(1, "WCO::mountLib on thread caught exception mounting " + lib + "\n    ex: " + ex + "\n    msg: " + msg + "\n    ex.getMessage(): " + ex.getMessage() + "\n    ex.getLocalizedMessage(): " + ex.getMessage());
                        err.notify(1, (Throwable)ex);
                    }
                }
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean waitAndSetJarFile(JarFileSystem jfs, FileObject fo, File f, long wait) throws IOException {
        FileLock lock;
        block21: {
            if (wait > 0L) {
                try {
                    Thread.currentThread();
                    Thread.sleep(wait);
                }
                catch (InterruptedException interruptedAgain) {
                    // empty catch block
                }
            }
            lock = null;
            try {
                try {
                    block20: {
                        try {
                            lock = fo.lock();
                            if (debug) {
                                err.log(1, "Got file lock on " + fo.getName());
                            }
                        }
                        catch (IOException ex) {
                            if (!debug) break block20;
                            err.log(1, "*** Exception getting file lock on : " + fo.getName() + " Exception : " + ex);
                        }
                    }
                    try {
                        jfs.setJarFile(f);
                    }
                    catch (PropertyVetoException jbp) {
                        // empty catch block
                    }
                    if (lock != null) {
                        if (debug) {
                            err.log(1, "Releasing Lock on taglib jar " + fo.getName());
                        }
                        lock.releaseLock();
                        lock = null;
                    }
                }
                catch (Exception ex) {
                    if (debug) {
                        err.log(1, "WCO caught exception in trying to set jar file. " + ex);
                    }
                    if (debug) {
                        ex.printStackTrace();
                    }
                    if (ex instanceof IOException) {
                        throw (IOException)ex;
                    }
                    Object var9_11 = null;
                    if (lock == null) return true;
                    if (debug) {
                        err.log(1, "Relasing lock on taglib jar in finally block " + fo.getName());
                    }
                    lock.releaseLock();
                    return true;
                }
                Object var9_10 = null;
                if (lock == null) return true;
                if (!debug) break block21;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (lock == null) throw throwable;
                if (debug) {
                    err.log(1, "Relasing lock on taglib jar in finally block " + fo.getName());
                }
                lock.releaseLock();
                throw throwable;
            }
            err.log(1, "Relasing lock on taglib jar in finally block " + fo.getName());
        }
        lock.releaseLock();
        return true;
    }

    /*
     * Unable to fully structure code
     */
    synchronized FileSystem mountLibImpl(FileObject lib) throws IOException {
        block16: {
            if (WebContextObject.debug) {
                WebContextObject.err.log(1, "\nWebContextObject[" + this.documentBase + "]::mountLib lib=" + lib + "  libs.size()=" + this.libs.size());
            }
            if (WebContextObject.debug) {
                WebContextObject.err.log(1, "                 libs.containskey(lib)=" + this.libs.containsKey(lib));
            }
            if (this.libs.containsKey(lib)) {
                return (FileSystem)this.libs.get(lib);
            }
            jfs = new JarFileSystem();
            f = NbClassPath.toFile((FileObject)lib);
            if (f == null) {
                return null;
            }
            try {
                this.waitAndSetJarFile(jfs, lib, f, 0L);
                break block16;
            }
            catch (Exception firstException) {
                if (WebContextObject.debug) {
                    WebContextObject.err.log(1, "WebContextObject caught exception setting Jar file on JFS. " + firstException + "File f = " + f);
                }
                if (WebContextObject.debug) {
                    WebContextObject.err.log(1, "      wait a bit and then retry.");
                }
                numTries = 3;
                i = 0;
                ** while (i < numTries)
            }
lbl-1000:
            // 1 sources

            {
                block17: {
                    try {
                        if (this.waitAndSetJarFile(jfs, lib, f, 1000L)) {
                            break;
                        }
                    }
                    catch (IOException ex) {
                        if (WebContextObject.debug) {
                            WebContextObject.err.log(1, "WebContextObject caught exception setting Jar file on JFS after wait. " + ex);
                        }
                        if (i != numTries - 1) break block17;
                        throw ex;
                    }
                }
                ++i;
                continue;
            }
        }
        if (WebContextObject.debug) {
            WebContextObject.err.log(1, "WebContextObject successfully set Jar file on JFS. ");
        }
        fs = this.mountFS((FileSystem)jfs);
        this.libs.put(lib, fs);
        this.fireWebContextEvent(new WebContextEvent(this, lib, true));
        if (WebContextObject.debug) {
            WebContextObject.err.log(1, "WCO: mounted lib. libs hashtable contains:");
            en = this.libs.keys();
            while (en.hasMoreElements()) {
                fsi = (FileObject)en.nextElement();
                WebContextObject.err.log(1, "      " + fsi);
            }
        }
        return fs;
    }

    private void unmountFS(FileSystem fs) {
        WebContextObject.removeFS(fs);
    }

    private static void replaceFS(FileSystem oldFs, FileSystem newFs) {
        if (debug) {
            err.log(1, "WCO:replaceFS. old: " + oldFs + " new: " + newFs);
        }
        FSRemover rem = new FSRemover(oldFs, newFs);
        WebContextObject.requestProcessor().post((Runnable)rem);
    }

    private void unmountFS() {
        this.associateClassesFS();
        if (this.classesFS != null) {
            this.unmountFS(this.classesFS);
        }
        Object[] fss = this.libs.values().toArray();
        this.libs.clear();
        int i = 0;
        while (i < fss.length) {
            this.unmountFS((FileSystem)fss[i]);
            ++i;
        }
    }

    private FileSystem mountFS(FileSystem fs) throws IOException {
        return WebContextObject.mountFS(fs, true);
    }

    private static FileSystem mountFS(FileSystem fs, boolean useold) throws IOException {
        DelegatingFileSystem dfs = null;
        if (fs instanceof DelegatingFileSystem) {
            dfs = (DelegatingFileSystem)fs;
        }
        Enumeration en = Repository.getDefault().getFileSystems();
        while (en.hasMoreElements()) {
            FileSystem f = (FileSystem)en.nextElement();
            if (!f.getSystemName().equals(fs.getSystemName()) && (dfs == null || !dfs.correspondsTo(f))) continue;
            if (useold) {
                return f;
            }
            WebContextObject.replaceFS(f, fs);
            return fs;
        }
        WebContextObject.addFS(fs);
        return fs;
    }

    public DataObject getDeploymentDescriptor() throws IOException {
        if (this.deploymentDescriptor != null) {
            return this.deploymentDescriptor;
        }
        FileObject dd = this.documentBase.find(FOLDER_WEB_INF, "web", XML_EXT);
        if (dd == null) {
            throw new IOException();
        }
        this.deploymentDescriptor = DataObject.find((FileObject)dd);
        return this.deploymentDescriptor;
    }

    public DataFolder getLibraries() throws IOException {
        FileObject libraries = this.getLibrariesFile();
        if (libraries == null) {
            throw new IOException();
        }
        return (DataFolder)DataObject.find((FileObject)libraries);
    }

    private FileObject getLibrariesFile() {
        return this.documentBase.findResource("WEB-INF/lib");
    }

    public WebStandardData.WebModule getStandardData() {
        return WebDataFactory.getFactory().findWebModule(this.getPrimaryFile());
    }

    public FileSystem getClassesBase() throws IOException {
        this.associateClassesFS();
        if (this.classesFS != null) {
            return this.classesFS;
        }
        if (this.isMounted()) {
            long t = System.currentTimeMillis();
            int i = 0;
            while (i < 200) {
                if (this.classesMounterTask != null) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {}
                } else {
                    if (this.classesFS == null) {
                        throw new IllegalStateException();
                    }
                    return this.classesFS;
                }
                ++i;
            }
            throw new IllegalStateException("" + (System.currentTimeMillis() - t));
        }
        return null;
    }

    public FileSystem getDocumentBase() {
        return this.documentBase;
    }

    public WebInfObject getInfObject() {
        try {
            return (WebInfObject)DataObject.find((FileObject)this.getPrimaryFile().getFileObject(FOLDER_WEB_INF));
        }
        catch (Exception e) {
            return null;
        }
    }

    public ServerInstance getServerInstance() {
        this.getServerExecSupport();
        ServerInstanceData sid = ServerExecSupport.getServerInstance((FileObject)this.getPrimaryFile());
        ServerInstance si = null;
        if (sid != null) {
            si = ServerUtilities.findServerInstance((ServerInstanceData)sid);
        }
        if (si == null) {
            return ServerRegistryImpl.getRegistry().getDefaultWebInstance();
        }
        return si;
    }

    public static void addWebContextListener(WebContextListener wcl) {
        if (listenerSet == null) {
            listenerSet = new HashSet();
        }
        Set set = listenerSet;
        synchronized (set) {
            listenerSet.add(wcl);
        }
    }

    public static void removeWebContextListener(WebContextListener wcl) {
        Set set = listenerSet;
        synchronized (set) {
            listenerSet.remove(wcl);
        }
    }

    public static WebContextPackager getPackager() {
        if (packager == null) {
            packager = new WarPackagerSupport();
        }
        return packager;
    }

    public WebModuleCookie getWebModuleCookie() {
        if (this.cookie == null) {
            this.cookie = new WebModuleCookieSupport(this);
        }
        return this.cookie;
    }

    private void showNotifyDialog() {
        ServletSettings setting = (ServletSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$web$core$ServletSettings == null ? (class$org$netbeans$modules$web$core$ServletSettings = WebContextObject.class$("org.netbeans.modules.web.core.ServletSettings")) : class$org$netbeans$modules$web$core$ServletSettings));
        MountMessagePanel panel = new MountMessagePanel();
        class Supp
        implements ActionListener,
        Runnable {
            Dialog d;
            static /* synthetic */ Class class$org$netbeans$modules$web$context$WebContextObject;
            private final /* synthetic */ ServletSettings val$setting;
            private final /* synthetic */ MountMessagePanel val$panel;
            private final /* synthetic */ WebContextObject this$0;

            Supp(WebContextObject this$0, ServletSettings val$setting, MountMessagePanel val$panel) {
                this.this$0 = this$0;
                this.val$setting = val$setting;
                this.val$panel = val$panel;
            }

            public void actionPerformed(ActionEvent e) {
                this.val$setting.setShowMessageDialog(this.val$panel.getShowDialog());
                this.d.dispose();
            }

            public void run() {
                DialogDescriptor desc = new DialogDescriptor((Object)this.val$panel, NbBundle.getMessage((Class)(class$org$netbeans$modules$web$context$WebContextObject == null ? (class$org$netbeans$modules$web$context$WebContextObject = Supp.class$("org.netbeans.modules.web.context.WebContextObject")) : class$org$netbeans$modules$web$context$WebContextObject), (String)"CTL_TITLE"), false, -1, null, (ActionListener)this);
                desc.setOptions(new Object[]{NotifyDescriptor.OK_OPTION});
                desc.setMessageType(1);
                this.d = DialogDisplayer.getDefault().createDialog(desc);
                ((Component)this.d).setSize(580, 180);
                this.d.show();
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }
        SwingUtilities.invokeLater(new Supp(this, setting, panel));
    }

    public String getURIParameter() {
        FileObject fob = this.getPrimaryFile();
        try {
            String str = (String)fob.getAttribute(PROP_URI);
            if (str == null) {
                return "";
            }
            return str;
        }
        catch (Exception exception) {
            return "";
        }
    }

    protected void setURIParameter(String parameter) {
        FileObject fob = this.getPrimaryFile();
        try {
            fob.setAttribute(PROP_URI, (Object)parameter);
            this.firePropertyChange(PROP_URI, null, parameter);
            this.serverChanged();
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private void addServerChangesListeners() {
        ServerRegistryImpl.getRegistry().addServerRegistryListener((ServerRegistryImpl.ServerRegistryListener)this);
    }

    private void removeServerChangesListeners() {
        ServerRegistryImpl.getRegistry().removeServerRegistryListener((ServerRegistryImpl.ServerRegistryListener)this);
    }

    private void addWebAppChangesListeners() {
        FileObject fo = (FileObject)this.getPrimaryFile().getAttribute("NbAttrWebApp");
        if (fo != null) {
            try {
                this.oldWebAppDataObject = DataObject.find((FileObject)fo);
                this.oldWebAppDataObject.addPropertyChangeListener((PropertyChangeListener)this);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    private void removeWebAppChangesListeners() {
        if (this.oldWebAppDataObject != null) {
            this.oldWebAppDataObject.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.oldWebAppDataObject = null;
    }

    public void added(ServerRegistryImpl.ServerEvent added) {
        this.serverChanged();
    }

    public void setAppDefault(ServerRegistryImpl.InstanceEvent inst) {
        this.serverChanged();
    }

    public void setWebDefault(ServerRegistryImpl.InstanceEvent inst) {
        this.serverChanged();
    }

    public void removed(ServerRegistryImpl.ServerEvent removed) {
        this.serverChanged();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String str = propertyChangeEvent.getPropertyName();
        Object source = propertyChangeEvent.getSource();
        if (str.equals("serverInstnace")) {
            this.serverChanged();
        }
        if (str.equals("PROP_LOCAL_WEB_APP")) {
            FileObject fo = (FileObject)this.getPrimaryFile().getAttribute("NbAttrWebApp");
            if (fo != null) {
                try {
                    DataObject dob = DataObject.find((FileObject)fo);
                    dob.addPropertyChangeListener((PropertyChangeListener)this);
                    if (this.oldWebAppDataObject != null) {
                        this.oldWebAppDataObject.removePropertyChangeListener((PropertyChangeListener)this);
                    }
                    this.oldWebAppDataObject = dob;
                }
                catch (DataObjectNotFoundException e) {}
            } else {
                if (this.oldWebAppDataObject != null) {
                    this.oldWebAppDataObject.removePropertyChangeListener((PropertyChangeListener)this);
                }
                this.oldWebAppDataObject = null;
            }
            this.serverChanged();
        }
    }

    private void serverChanged() {
        ServerInstanceData oldSID = (ServerInstanceData)this.getPrimaryFile().getAttribute(ATTR_OLD_SERVER_INSTANCE_DATA);
        WebDataFactory factory = WebDataFactory.getFactory();
        WebModuleImpl wmi = factory.findWebModule(this.getPrimaryFile());
        ServerInstance si = factory.findServerInstance((WebStandardData)wmi);
        ServerInstanceData newSID = null;
        if (si != null) {
            newSID = new ServerInstanceData(si.getServer().getID(), si.getID());
        }
        if (oldSID != null) {
            if (!oldSID.equals(newSID)) {
                final ServerInstanceData newSIDCopy = newSID;
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        WebContextObject.super.firePropertyChange(WebContextObject.PROP_NEW_SERVER_INSTANCE, null, newSIDCopy);
                    }
                });
                try {
                    this.getPrimaryFile().setAttribute(ATTR_OLD_SERVER_INSTANCE_DATA, (Object)newSID);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(16, (Throwable)e);
                }
            }
        } else if (newSID != null) {
            this.firePropertyChange(PROP_NEW_SERVER_INSTANCE, null, newSID);
            try {
                this.getPrimaryFile().setAttribute(ATTR_OLD_SERVER_INSTANCE_DATA, (Object)newSID);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
            }
        }
    }

    public void addContextDeleteListener(ContextDeleteListener cl) {
        if (this.contextDeleteListenerSet == null) {
            this.contextDeleteListenerSet = new HashSet();
        }
        Set set = this.contextDeleteListenerSet;
        synchronized (set) {
            this.contextDeleteListenerSet.add(cl);
        }
    }

    public void removeContextDeleteListener(ContextDeleteListener cl) {
        Set set = this.contextDeleteListenerSet;
        synchronized (set) {
            this.contextDeleteListenerSet.remove(cl);
        }
    }

    private void fireWebContextDeleteEvent() {
        if (this.contextDeleteListenerSet != null) {
            Iterator it = this.contextDeleteListenerSet.iterator();
            while (it.hasNext()) {
                ((ContextDeleteListener)it.next()).contextDeleted(new EventObject(this));
            }
        }
    }

    private void removeContextDeleteListeners() {
        if (this.contextDeleteListenerSet != null) {
            this.contextDeleteListenerSet.clear();
            this.contextDeleteListenerSet = null;
        }
    }

    private void setWebModuleModification() {
        this.timeOfLastWebModuleModification = System.currentTimeMillis();
    }

    public long getWebModuleModification() {
        return this.timeOfLastWebModuleModification;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ FileSystem access$900(WebContextObject x0) {
        return x0.documentBase;
    }

    static {
        err = ErrorManager.getDefault().getInstance("org.netbeans.modules.web.context.WebContextObject");
        debug = err.isLoggable(1);
        fsMounter = null;
    }

    private class JspListener
    extends FileChangeAdapter {
        public void fileRenamed(FileRenameEvent fe) {
            String ext = fe.getFile().getExt();
            if (ext.equals(WebContextObject.JAVA_EXT) || ext.equals(WebContextObject.CLASS_EXT) || ext.equals(WebContextObject.TLD_EXT) || ext.equals(WebContextObject.XML_EXT)) {
                WebContextObject.this.setWebModuleModification();
            }
            try {
                DataObject dd = WebContextObject.this.getDeploymentDescriptor();
                if ("jsp".equals(fe.getFile().getExt()) && dd != null && dd instanceof DDDataObject) {
                    ((DDDataObject)dd).fireJspRenamed(fe);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void fileDeleted(FileEvent fe) {
            String ext = fe.getFile().getExt();
            if (ext.equals(WebContextObject.JAVA_EXT) || ext.equals(WebContextObject.CLASS_EXT) || ext.equals(WebContextObject.TLD_EXT) || ext.equals(WebContextObject.XML_EXT)) {
                WebContextObject.this.setWebModuleModification();
            }
            try {
                DataObject dd = WebContextObject.this.getDeploymentDescriptor();
                if ("jsp".equals(fe.getFile().getExt()) && dd != null && dd instanceof DDDataObject) {
                    ((DDDataObject)dd).fireJspDeleted(fe);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void fileDataCreated(FileEvent fe) {
            String ext = fe.getFile().getExt();
            if (ext.equals(WebContextObject.JAVA_EXT) || ext.equals(WebContextObject.CLASS_EXT) || ext.equals(WebContextObject.TLD_EXT) || ext.equals(WebContextObject.XML_EXT)) {
                WebContextObject.this.setWebModuleModification();
            }
            try {
                DataObject dd = WebContextObject.this.getDeploymentDescriptor();
                if ("jsp".equals(fe.getFile().getExt()) && dd != null && dd instanceof DDDataObject) {
                    ((DDDataObject)dd).fireJspCreated(fe);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void fileChanged(FileEvent fe) {
            String ext = fe.getFile().getExt();
            if (ext.equals(WebContextObject.JAVA_EXT) || ext.equals(WebContextObject.CLASS_EXT) || ext.equals(WebContextObject.TLD_EXT) || ext.equals(WebContextObject.XML_EXT)) {
                WebContextObject.this.setWebModuleModification();
            }
        }
    }

    private class ClassesListener
    extends FileChangeAdapter {
        public void fileRenamed(FileRenameEvent fe) {
            try {
                DataObject dd = WebContextObject.this.getDeploymentDescriptor();
                if (WebContextObject.JAVA_EXT.equals(fe.getFile().getExt()) && dd != null && dd instanceof DDDataObject) {
                    ((DDDataObject)dd).fireFileRenamed(fe);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void fileDeleted(FileEvent fe) {
            try {
                DataObject dd = WebContextObject.this.getDeploymentDescriptor();
                if (WebContextObject.JAVA_EXT.equals(fe.getFile().getExt()) && dd != null && dd instanceof DDDataObject) {
                    ((DDDataObject)dd).fireFileDeleted(fe);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void fileDataCreated(FileEvent fe) {
            try {
                DataObject dd = WebContextObject.this.getDeploymentDescriptor();
                if (WebContextObject.JAVA_EXT.equals(fe.getFile().getExt()) && dd != null && dd instanceof DDDataObject) {
                    ((DDDataObject)dd).fireFileCreated(fe);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void fileChanged(FileEvent fe) {
        }
    }

    private class LibMountingListener
    implements FileChangeListener,
    PropertyChangeListener {
        FileObject source;

        private void attachToLibDir(FileObject fo) {
            this.source = fo;
            this.source.addFileChangeListener((FileChangeListener)this);
        }

        private void dettachFromLibDir() {
            if (this.source != null) {
                this.source.removeFileChangeListener((FileChangeListener)this);
                this.source = null;
            }
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
            if (fe.getFile().getExt().equals("jar")) {
                WebContextObject.this.setWebModuleModification();
            }
            WebContextObject.this.mountAllLibs();
        }

        public void fileChanged(FileEvent fe) {
            if (fe.getFile().getExt().equals("jar")) {
                WebContextObject.this.setWebModuleModification();
            }
            WebContextObject.this.mountAllLibs();
        }

        public void fileDeleted(FileEvent fe) {
            if (fe.getFile().getExt().equals("jar")) {
                WebContextObject.this.setWebModuleModification();
            }
            WebContextObject.this.unmountLib(fe.getFile());
        }

        public void fileRenamed(FileRenameEvent fe) {
            if (fe.getFile().getExt().equals("jar")) {
                WebContextObject.this.setWebModuleModification();
            }
        }

        public void fileAttributeChanged(FileAttributeEvent fae) {
        }

        public synchronized void propertyChange(PropertyChangeEvent evt) {
            if ("contents_valid".equals(evt.getPropertyName())) {
                JarDataObject jarDO = (JarDataObject)evt.getSource();
                if (!jarDO.isValid()) {
                    return;
                }
                Set files = jarDO.files();
                FileObject jarFO = null;
                Iterator it = files.iterator();
                while (it.hasNext()) {
                    FileObject next = (FileObject)it.next();
                    if (!next.hasExt("jar")) continue;
                    jarFO = next;
                    break;
                }
                if (jarDO.allValid()) {
                    WebContextObject.this.unmountLib(jarFO);
                } else {
                    WebContextObject.this.mountAllLibs();
                }
            }
        }
    }

    public static interface ContextDeleteListener {
        public void contextDeleted(EventObject var1);
    }

    public static interface WebContextPackager {
        public FileArchiveResource getResource(WebContextObject var1, Server var2, J2eeAppStandardData var3);

        public FileArchiveResource getResource(WebContextObject var1, Server var2, J2eeAppStandardData var3, File var4);
    }

    public static class WebModuleCookieSupport
    implements WebModuleCookie {
        private final WebContextObject context;

        public WebModuleCookieSupport(WebContextObject wco) {
            this.context = wco;
        }

        public WebContextObject getContext() {
            return this.context;
        }

        public WebStandardData.WebModule getStandardData() {
            return this.context.getStandardData();
        }
    }

    static class FSRemover
    implements FileSystem.AtomicAction,
    Runnable {
        FileSystem rem;
        FileSystem rep;

        public FSRemover(FileSystem f, FileSystem replaceWith) {
            this.rem = f;
            this.rep = replaceWith;
        }

        public void run() {
            try {
                Repository.getDefault().removeFileSystem(this.rem);
                if (this.rep != null) {
                    Repository.getDefault().addFileSystem(this.rep);
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }
}

