/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core;

import java.awt.Component;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;

public class WebBrowser
implements Serializable,
Cloneable {
    public static final String BROWSER_WWW = "wwwBrowser";
    public static final String BROWSER_XML = "xmlBrowser";
    public static final String BROWSER_WAP = "wapBrowser";
    private ArrayList browsers;
    private int currentValue = 0;
    private static final long serialVersionUID = -6176769486654262412L;

    public WebBrowser() {
        this.browsers = new ArrayList();
    }

    private WebBrowser(ArrayList browsers, int currentValue) {
        this.browsers = browsers;
        this.currentValue = currentValue;
    }

    public Object clone() {
        return new WebBrowser(this.browsers, this.currentValue);
    }

    public void showURL(URL url) {
        if (this.getImpl() == null) {
            return;
        }
        this.getImpl().showUrl(url);
    }

    public void addImpl(Impl browserImpl) {
        this.browsers.add(browserImpl);
    }

    public Impl[] getAllImpls() {
        return this.browsers.toArray(new Impl[this.browsers.size()]);
    }

    public int getImplIndex() {
        if (this.browsers.size() == 0) {
            return -1;
        }
        return this.currentValue;
    }

    public Impl getImpl() {
        if (this.browsers.size() == 0) {
            return null;
        }
        return (Impl)this.browsers.get(this.currentValue);
    }

    public void setImpl(Impl impl) {
        int newIndex = this.browsers.indexOf(impl);
        if (newIndex == -1) {
            throw new IllegalArgumentException();
        }
        this.currentValue = newIndex;
    }

    public static interface Factory {
        public WebBrowser getBrowser();
    }

    public static interface Impl
    extends Serializable {
        public void showUrl(URL var1);

        public String getDisplayName();

        public Component getConfigComponent();

        public void stopConfigEditing();
    }
}

