/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.netbeans.modules.j2ee.server.ServerInstance;
import org.netbeans.modules.j2ee.server.datamodel.WebStandardData;
import org.netbeans.modules.j2ee.server.web.FfjJspCompileContext;
import org.netbeans.modules.web.core.jsploader.ExCompileContext;
import org.netbeans.modules.web.core.jsploader.JspCompileUtil;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public class CompileData {
    private JspDataObject jspPage;
    private ServerInstance serverInstance;
    private FileObject servletDirectory;
    private boolean outDated;
    private String servletEncoding;
    private Vector additionalClassPath;
    private String servletClassName;
    private String realServletClassName;
    private String servletFileName;
    private String servletFileNameWithoutPackage;
    private static final boolean debug = false;

    public CompileData(JspDataObject jspPage) {
        this.jspPage = jspPage;
        FileObject jspFileObject = jspPage.getPrimaryFile();
        WebStandardData.WebResource res = JspCompileUtil.getResourceData(jspFileObject);
        WebStandardData.WebJsp jspData = (WebStandardData.WebJsp)res;
        this.serverInstance = JspCompileUtil.getCurrentServerInstance((DataObject)jspPage);
        FfjJspCompileContext comp = JspCompileUtil.getCurrentCompileContext((DataObject)jspPage);
        if (comp != null) {
            FfjJspCompileContext.DevelopmentCompilation dev = comp.getDevelopmentCompilation(jspData);
            this.outDated = dev.isOutDated();
            this.servletEncoding = dev.getServletEncoding();
            this.servletClassName = comp.getServletClassName(jspData);
            this.realServletClassName = comp instanceof ExCompileContext ? ((ExCompileContext)comp).getRealClassName(jspData) : this.servletClassName;
            this.servletFileName = dev.getServletFileName();
            this.additionalClassPath = this.computeAdditionalClassPath(dev.getAdditionalClassPath());
            if (this.servletFileName != null) {
                try {
                    this.computeServletData();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public ServerInstance getServerInstance() {
        return this.serverInstance;
    }

    public FileObject getServletDirectory() {
        return this.servletDirectory;
    }

    public boolean isOutDated() {
        return this.outDated;
    }

    public Vector getAdditionalClassPath() {
        return this.additionalClassPath;
    }

    public String getCurrentServletFileName() {
        return this.servletFileNameWithoutPackage;
    }

    public String getCurrentServletClassName() {
        return this.servletClassName;
    }

    public String getRealServletClassName() {
        return this.realServletClassName;
    }

    public String getServletEncoding() {
        return this.servletEncoding;
    }

    private Vector computeAdditionalClassPath(String classpath) {
        Vector<File> v = new Vector<File>();
        StringTokenizer st = new StringTokenizer(classpath, "" + File.pathSeparatorChar);
        while (st.hasMoreTokens()) {
            File f = new File(st.nextToken());
            v.add(f);
        }
        return v;
    }

    private void computeServletData() throws IOException {
        String classNameFS;
        File serv = new File(this.servletFileName).getAbsoluteFile();
        String servName = serv.getAbsolutePath();
        int lastSep = servName.lastIndexOf(File.separatorChar);
        this.servletFileNameWithoutPackage = lastSep != -1 ? servName.substring(lastSep + 1) : servName;
        int lastDot = servName.lastIndexOf(46);
        if (lastDot != -1) {
            servName = servName.substring(0, lastDot);
        }
        if (servName.endsWith(classNameFS = this.servletClassName.replace('.', File.separatorChar))) {
            servName = servName.substring(0, servName.length() - classNameFS.length());
            FileObject rootFO = JspCompileUtil.getAsRootOfFileSystem(new File(servName));
            lastDot = this.servletClassName.lastIndexOf(46);
            if (lastDot != -1) {
                String packageNameSl = this.servletClassName.substring(0, lastDot).replace('.', '/');
                this.servletDirectory = FileUtil.createFolder((FileObject)rootFO, (String)packageNameSl);
            } else {
                this.servletDirectory = rootFO;
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("--COMPILE DATA--");
        sb.append("\n");
        sb.append("server          : " + this.serverInstance);
        sb.append("\n");
        sb.append("JSP page        : " + this.jspPage.getPrimaryFile().getPackageNameExt('/', '.'));
        sb.append("\n");
        sb.append("servletFile     : " + this.servletFileName + ", exists= " + (this.servletFileName == null ? "false" : "" + new File(this.servletFileName).exists()));
        sb.append("\n");
        sb.append("servletClass    : " + this.servletClassName);
        sb.append("\n");
        sb.append("realServletClass: " + this.realServletClassName);
        sb.append("\n");
        sb.append("encoding        : " + this.servletEncoding);
        sb.append("\n");
        sb.append("servletDir (FO) : " + (this.servletDirectory == null ? "null" : this.servletDirectory.getPackageName('/')));
        sb.append("\n");
        sb.append("servlet W/O Pkg : " + this.servletFileNameWithoutPackage);
        sb.append("\n");
        sb.append("outdated        : " + this.outDated);
        sb.append("\n");
        sb.append("--end COMPILE DATA--");
        return sb.toString();
    }
}

