/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;

public class ContextDescriptor {
    private FileSystem baseFs;

    public ContextDescriptor(FileSystem fs) {
        this.baseFs = fs;
    }

    public URL getResource(String path) throws MalformedURLException {
        FileObject fo = this.getResourceAsObject(path);
        if (fo == null) {
            return null;
        }
        try {
            return this.getFileExternalURL(fo);
        }
        catch (FileStateInvalidException ex) {
            throw new MalformedURLException(((Object)((Object)ex)).getClass().getName() + " : " + ex.toString());
        }
    }

    public InputStream getResourceAsStream(String path) {
        FileObject fo = this.getResourceAsObject(path);
        if (fo == null) {
            return null;
        }
        try {
            return fo.getInputStream();
        }
        catch (FileNotFoundException ex) {
            return null;
        }
    }

    public FileObject getResourceAsObject(String path) {
        path = path.replace('\\', '/');
        if (this.baseFs == null) {
            return Repository.getDefault().findResource(path);
        }
        return this.baseFs.findResource(path);
    }

    private URL getFileExternalURL(FileObject fo) throws FileStateInvalidException {
        File ff = NbClassPath.toFile((FileObject)fo);
        if (ff != null) {
            try {
                return ff.toURL();
            }
            catch (MalformedURLException e) {
                return fo.getURL();
            }
        }
        return fo.getURL();
    }

    public String getRealPath(String path) {
        String realPath = null;
        try {
            File ff;
            FileObject fo;
            URL url = this.getResource(path);
            if (url != null && url.getProtocol().equals("file") && (fo = this.getResourceAsObject(path)) != null && (ff = NbClassPath.toFile((FileObject)fo)) != null) {
                realPath = ff.getAbsolutePath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return realPath;
    }
}

