/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.web.core.jsploader.ContextDescriptor;
import org.netbeans.modules.web.core.jsploader.JspCompileUtil;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.netbeans.modules.web.core.jsploader.JspInfo;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class JspCompilationInfo {
    private FileObject jspFile;
    private ContextDescriptor cd;
    private boolean isErrorPage;
    private FileObject[] includedFileObjects;
    private DataObject[] includedFiles;
    private DataObject[] beans;
    private JspDataObject[] errorPage;
    private JspDataObject[] referencedPages;

    public JspCompilationInfo(JspInfo info, FileObject jspFile) throws FileStateInvalidException {
        this.jspFile = jspFile;
        this.cd = new ContextDescriptor(JspCompileUtil.getContextRoot(jspFile).getFileSystem());
        this.isErrorPage = info.isErrorPage();
        Set dObjSet = this.convertBeans(info.getBeans());
        this.beans = dObjSet.toArray(new DataObject[dObjSet.size()]);
        Set fileSet = this.convertIncluded(info.getIncludedFiles());
        this.includedFileObjects = fileSet.toArray(new FileObject[fileSet.size()]);
        this.includedFiles = this.convertFilesToData(this.includedFileObjects);
        DataFilter jspFilter = new DataFilter(){

            public boolean acceptDataObject(DataObject obj) {
                return obj instanceof JspDataObject;
            }
        };
        dObjSet = this.convertPages(info.getErrorPage(), jspFilter);
        this.errorPage = dObjSet.toArray(new JspDataObject[dObjSet.size()]);
        dObjSet = this.convertPages(info.getReferencedPages(), jspFilter);
        this.referencedPages = dObjSet.toArray(new JspDataObject[dObjSet.size()]);
    }

    private DataObject resourceToDataObject(String resource, DataFilter filter) {
        FileObject fo = this.cd.getResourceAsObject(resource);
        DataObject dObj = null;
        if (fo != null) {
            try {
                dObj = DataObject.find((FileObject)fo);
                if (filter != null && !filter.acceptDataObject(dObj)) {
                    dObj = null;
                }
            }
            catch (DataObjectNotFoundException e) {
                // empty catch block
            }
        }
        return dObj;
    }

    private DataObject clazzToDataObject(String clazz) {
        String resource = clazz.replace('.', '/');
        FileObject fo = Repository.getDefault().findResource(resource + ".java");
        if (fo == null) {
            fo = Repository.getDefault().findResource(resource + ".class");
        }
        if (fo == null) {
            return null;
        }
        try {
            return DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException e) {
            return null;
        }
    }

    private Set convertPages(String[] urls, DataFilter filter) {
        HashSet<DataObject> pages = new HashSet<DataObject>();
        int i = 0;
        while (i < urls.length) {
            DataObject dObj = this.resourceToDataObject(urls[i], filter);
            if (dObj != null) {
                pages.add(dObj);
            }
            ++i;
        }
        return pages;
    }

    private Set convertIncluded(String[] urls) {
        HashSet<FileObject> pages = new HashSet<FileObject>();
        int i = 0;
        while (i < urls.length) {
            FileObject fo = this.cd.getResourceAsObject(urls[i]);
            if (fo != null) {
                pages.add(fo);
            }
            ++i;
        }
        return pages;
    }

    private DataObject[] convertFilesToData(FileObject[] files) {
        DataObject[] result = new DataObject[files.length];
        int i = 0;
        while (i < files.length) {
            try {
                result[i] = DataObject.find((FileObject)files[i]);
            }
            catch (DataObjectNotFoundException e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
                return new DataObject[0];
            }
            ++i;
        }
        return result;
    }

    private Set convertBeans(JspInfo.BeanData[] beans) {
        HashSet<DataObject> pages = new HashSet<DataObject>();
        int i = 0;
        while (i < beans.length) {
            DataObject dObj = this.clazzToDataObject(beans[i].getClassName());
            if (dObj != null) {
                pages.add(dObj);
            }
            ++i;
        }
        return pages;
    }

    public DataObject[] getIncludedFiles() {
        return this.includedFiles;
    }

    public FileObject[] getIncludedFileObjects() {
        return this.includedFileObjects;
    }

    public DataObject[] getBeans() {
        return this.beans;
    }

    public JspDataObject[] getErrorPage() {
        return this.errorPage;
    }

    public JspDataObject[] getReferencedPages() {
        return this.referencedPages;
    }

    public boolean isErrorPage() {
        return this.isErrorPage;
    }
}

