/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.netbeans.modules.j2ee.server.Server;
import org.netbeans.modules.j2ee.server.ServerInstance;
import org.netbeans.modules.j2ee.server.datamodel.WebStandardData;
import org.netbeans.modules.j2ee.server.web.FfjJspCompileContext;
import org.netbeans.modules.j2ee.server.web.WebServerInstance;
import org.netbeans.modules.web.core.WebExecUtil;
import org.netbeans.modules.web.core.jsploader.DebugSourceCapabilityBean;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.netbeans.modules.web.core.jsploader.JspParserAPI;
import org.netbeans.modules.web.core.jsploader.JspParserFactory;
import org.netbeans.modules.web.webdata.WebDataFactory;
import org.netbeans.modules.web.webdata.WebResourceImpl;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class JspCompileUtil {
    private static JspParserFactory parserFactory;
    private static final Object repositoryJobLock;
    static /* synthetic */ Class class$org$netbeans$modules$web$core$jsploader$JspCompileUtil;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    public static FfjJspCompileContext getCurrentCompileContext(DataObject jsp) {
        WebServerInstance inst = JspCompileUtil.getCurrentServerInstance(jsp);
        if (inst == null) {
            return null;
        }
        return inst.getJspCompiler();
    }

    public static WebServerInstance getCurrentServerInstance(DataObject resource) {
        FileObject fo = resource.getPrimaryFile();
        ServerInstance si = WebDataFactory.getFactory().findServerInstance((WebStandardData)JspCompileUtil.getResourceData(fo));
        if (si instanceof WebServerInstance) {
            return (WebServerInstance)si;
        }
        return null;
    }

    public static WebStandardData.WebResource getResourceData(FileObject fo) {
        WebStandardData.WebResource result = WebDataFactory.getFactory().findResource(fo.getPackageNameExt('/', '.'), WebDataFactory.getFactory().findWebModule(fo));
        try {
            DataObject res = DataObject.find((FileObject)fo);
            if (res instanceof JspDataObject && !(result instanceof WebStandardData.WebJsp)) {
                result = WebDataFactory.getFactory().getWebJsp(fo.getPackageNameExt('/', '.'), WebDataFactory.getFactory().findWebModule(fo));
            }
        }
        catch (DataObjectNotFoundException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return result;
    }

    public static FileObject getFOForWebResource(WebStandardData.WebResource res) {
        return ((WebResourceImpl)res).getFileObject();
    }

    public static FileObject findFileObjectForFile(String fileName) {
        Repository rep = Repository.getDefault();
        Enumeration en = rep.getFileSystems();
        while (en.hasMoreElements()) {
            FileSystem fs = (FileSystem)en.nextElement();
            FileObject fo = JspCompileUtil.findFileObjectForFile(fs, fileName);
            if (fo == null) continue;
            return fo;
        }
        return null;
    }

    public static FileObject findFileObjectForFile(String fileName, String resourceName) {
        Repository rep = Repository.getDefault();
        Enumeration en = rep.getFileSystems();
        while (en.hasMoreElements()) {
            FileSystem fs = (FileSystem)en.nextElement();
            FileObject fo = JspCompileUtil.findFileObjectForFile(fs, fileName);
            if (fo == null || !resourceName.equals(fo.getPackageNameExt('/', '.'))) continue;
            return fo;
        }
        return null;
    }

    public static FileObject findFileObjectForFile(FileSystem fs, String fileName) {
        FileObject fo;
        String canName = "";
        String canName2 = "";
        try {
            canName = new File(fileName).getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
        String resFriendly = canName.replace(File.separatorChar, '/');
        int sepFound = -1;
        while (true) {
            File ff;
            if ((sepFound = resFriendly.indexOf(47, sepFound + 1)) == -1) {
                return null;
            }
            String resName = resFriendly.substring(sepFound);
            fo = fs.findResource(resName);
            if (fo == null || (ff = NbClassPath.toFile((FileObject)fo)) == null) continue;
            try {
                canName2 = ff.getCanonicalPath();
            }
            catch (IOException e) {
                continue;
            }
            if (canName2.equals(canName)) break;
        }
        return fo;
    }

    public static final String getFileObjectFileName(FileObject fo) throws FileStateInvalidException {
        File ff = NbClassPath.toFile((FileObject)fo);
        if (ff == null) {
            throw new FileStateInvalidException(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$core$jsploader$JspCompileUtil == null ? (class$org$netbeans$modules$web$core$jsploader$JspCompileUtil = JspCompileUtil.class$("org.netbeans.modules.web.core.jsploader.JspCompileUtil")) : class$org$netbeans$modules$web$core$jsploader$JspCompileUtil)).getString("CTL_NotLocalFile"));
        }
        return ff.getAbsolutePath();
    }

    public static final FileObject getContextRoot(FileObject fo) throws FileStateInvalidException {
        return fo.getFileSystem().getRoot();
    }

    public static final String getContextPath(FileObject fo) {
        return "/" + fo.getPackageNameExt('/', '.');
    }

    public static final FileObject suggestContextOutputRoot(FileObject fo, Server srv) throws IOException {
        File serverSpecificRoot = JspCompileUtil.suggestServerWorkDir(srv);
        FileSystem fs = fo.getFileSystem();
        int hc = fs.getSystemName().hashCode();
        String dirName = Long.toHexString(hc <= 0 ? (long)(-hc) : (long)hc);
        File contextRoot = new File(serverSpecificRoot, URLEncoder.encode(dirName));
        return JspCompileUtil.getAsRootOfFileSystem(contextRoot);
    }

    public static final File suggestServerWorkDir(Server srv) {
        File serverRoot = JspCompileUtil.getOutputRootFolder();
        File serverSpecificRoot = srv != null ? new File(serverRoot, URLEncoder.encode(srv.getID())) : serverRoot;
        if (!serverSpecificRoot.exists()) {
            boolean bl = WebExecUtil.myMkdirs(serverSpecificRoot);
        }
        return serverSpecificRoot;
    }

    public static File getOutputRootFolder() {
        String path = WebExecUtil.getUserNbHomeDirectory() + File.separator + "jspwork";
        File myRoot = new File(path).getAbsoluteFile();
        return myRoot;
    }

    static FileObject getAsRootOfFileSystem(File intendedRoot) {
        Object object = repositoryJobLock;
        synchronized (object) {
            Enumeration en = Repository.getDefault().getFileSystems();
            while (en.hasMoreElements()) {
                FileSystem fs = (FileSystem)en.nextElement();
                File root = NbClassPath.toFile((FileObject)fs.getRoot());
                if (root == null || !root.equals(intendedRoot)) continue;
                FileObject fileObject = fs.getRoot();
                return fileObject;
            }
            if (!intendedRoot.exists()) {
                boolean success = WebExecUtil.myMkdirs(intendedRoot);
            }
            DebugSourceCapabilityBean cap = new DebugSourceCapabilityBean();
            cap.setCompile(true);
            cap.setExecute(true);
            cap.setDebug(true);
            cap.setDoc(false);
            cap.setDebugsource(true);
            LocalFileSystem newFs = new LocalFileSystem((FileSystemCapability)cap);
            try {
                newFs.setRootDirectory(intendedRoot);
            }
            catch (Exception e) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$core$jsploader$JspCompileUtil == null ? (class$org$netbeans$modules$web$core$jsploader$JspCompileUtil = JspCompileUtil.class$("org.netbeans.modules.web.core.jsploader.JspCompileUtil")) : class$org$netbeans$modules$web$core$jsploader$JspCompileUtil)).getString("EXC_JspFSNotCreated"), intendedRoot.getAbsolutePath()), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                FileObject fileObject = null;
                return fileObject;
            }
            newFs.setHidden(true);
            Repository.getDefault().addFileSystem((FileSystem)newFs);
            FileObject fileObject = newFs.getRoot();
            return fileObject;
        }
    }

    public static String resolveRelativeURL(String relativeTo, String url) {
        String result;
        if (url.startsWith("/")) {
            result = "/";
            url = url.substring(1);
        } else {
            if (relativeTo == null || !relativeTo.startsWith("/")) {
                throw new IllegalArgumentException();
            }
            int lastSlash = (relativeTo = JspCompileUtil.resolveRelativeURL(null, relativeTo)).lastIndexOf(47);
            if (lastSlash == -1) {
                throw new IllegalArgumentException();
            }
            result = relativeTo.substring(0, lastSlash + 1);
        }
        StringTokenizer st = new StringTokenizer(url, "/", true);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals("/")) {
                if (result.endsWith("/")) continue;
                result = result + "/";
                continue;
            }
            if (tok.equals("") || tok.equals(".")) continue;
            if (tok.equals("..")) {
                String withoutSlash = result.substring(0, result.length() - 1);
                int ls = withoutSlash.lastIndexOf("/");
                if (ls == -1) continue;
                result = withoutSlash.substring(0, ls + 1);
                continue;
            }
            result = result + tok;
        }
        return result;
    }

    public static synchronized JspParserAPI getJspParser() {
        if (parserFactory == null) {
            FileObject f = Repository.getDefault().findResource("/J2EE/JSPParser");
            if (f != null) {
                try {
                    DataFolder folder = (DataFolder)DataObject.find((FileObject)f).getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = JspCompileUtil.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
                    parserFactory = new JspParserFactory(folder);
                }
                catch (DataObjectNotFoundException ex) {
                    ErrorManager.getDefault().notify(4096, (Throwable)ex);
                }
            } else {
                ErrorManager.getDefault().notify(4096, (Throwable)new Exception(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$core$jsploader$JspCompileUtil == null ? (class$org$netbeans$modules$web$core$jsploader$JspCompileUtil = JspCompileUtil.class$("org.netbeans.modules.web.core.jsploader.JspCompileUtil")) : class$org$netbeans$modules$web$core$jsploader$JspCompileUtil)).getString("EXC_JspParserNotInstalled")));
            }
        }
        return parserFactory == null ? null : parserFactory.getJspParser();
    }

    public static FileObject findRelativeResource(FileObject rootFolder, String relativePath) throws FileStateInvalidException {
        if (!rootFolder.isFolder()) {
            throw new IllegalArgumentException();
        }
        String rootPath = rootFolder.getPackageName('/');
        if (!rootPath.endsWith("/")) {
            rootPath = rootPath + "/";
        }
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        return rootFolder.getFileSystem().findResource(rootPath + relativePath);
    }

    public static FileSystem mountJarIfNotMounted(String jarFileName) throws IOException {
        JarFileSystem jfs = new JarFileSystem();
        File f = new File(jarFileName);
        try {
            jfs.setJarFile(f);
        }
        catch (PropertyVetoException jbp) {
            // empty catch block
        }
        FileSystem fs = JspCompileUtil.mountFS((FileSystem)jfs);
        return fs;
    }

    private static FileSystem mountFS(FileSystem fs) throws IOException {
        Enumeration en = Repository.getDefault().getFileSystems();
        while (en.hasMoreElements()) {
            FileSystem f = (FileSystem)en.nextElement();
            if (!f.getSystemName().equals(fs.getSystemName())) continue;
            return f;
        }
        fs.setHidden(true);
        Repository.getDefault().addFileSystem(fs);
        return fs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        repositoryJobLock = new Object();
    }
}

