/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.netbeans.modules.j2ee.impl.ServerExecSupport;
import org.netbeans.modules.j2ee.server.datamodel.WebStandardData;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.web.context.DelegatingFileSystem;
import org.netbeans.modules.web.context.WebContextLoader;
import org.netbeans.modules.web.context.WebContextObject;
import org.netbeans.modules.web.core.QueryStringCookie;
import org.netbeans.modules.web.core.WebExecSupport;
import org.netbeans.modules.web.core.jsploader.ServletDataLoader;
import org.netbeans.modules.web.core.jsploader.ServletDataNode;
import org.netbeans.modules.web.core.jsploader.WebAppNameEditor;
import org.netbeans.modules.web.core.jsploader.WebLookNode;
import org.netbeans.modules.web.dd.DDDataObject;
import org.netbeans.modules.web.dd.event.DDChangeEvent;
import org.netbeans.modules.web.dd.event.DDChangeListener;
import org.netbeans.modules.web.dd.model.Servlet;
import org.netbeans.modules.web.dd.model.ServletMapping;
import org.netbeans.modules.web.dd.model.WebApp;
import org.netbeans.modules.web.execution.ServletExecPerformer;
import org.netbeans.modules.web.webdata.WebDataFactory;
import org.netbeans.modules.web.webdata.WebModuleImpl;
import org.netbeans.modules.web.webdata.WebServletImpl;
import org.openide.ErrorManager;
import org.openide.debugger.DebuggerType;
import org.openide.execution.Executor;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.ExecSupport;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;
import org.openidex.nodes.looks.Look;

public class ServletDataObject
extends JavaDataObject
implements QueryStringCookie {
    protected static final String EA_URI = "NbAttrURI";
    protected static final String EA_SERVLETPARAMS_NAME = "NbAttrExecParamsName";
    private transient ServletConfigCookie configCookie;
    private transient FileChangeListener folderCL;
    private transient Vector servletLsnr;
    protected transient ServletExecSupport servletExecSupport = null;
    private FileChangeListener fcl = new ServletChangeListener();
    static /* synthetic */ Class class$org$openidex$nodes$looks$Look;
    static /* synthetic */ Class class$org$openidex$nodes$looks$DefaultLook;
    static /* synthetic */ Class class$org$openidex$nodes$looks$CompositeLook;
    static /* synthetic */ Class class$org$netbeans$modules$web$core$jsploader$ServletDataObject$ServletConfigCookie;
    static /* synthetic */ Class class$org$netbeans$modules$web$core$jsploader$ServletDataObject;
    static /* synthetic */ Class class$org$netbeans$modules$web$context$WebContextObject;
    static /* synthetic */ Class class$org$netbeans$modules$web$dd$DDDataObject;

    protected static WebModuleImpl getDefaultWebModuleImpl(FileObject fo) throws DataObjectNotFoundException {
        DataObject rootDO;
        WebModuleImpl webMod = WebDataFactory.getFactory().findWebModule(fo);
        if (webMod != null && (rootDO = DataObject.find((FileObject)webMod.getFileObject())) instanceof WebContextObject) {
            return webMod;
        }
        return null;
    }

    private static DDDataObject getWebXML(DataObject dobj) throws DataObjectNotFoundException {
        try {
            WebModuleImpl wmi = ServletExecPerformer.getWebModuleForDO(dobj);
            if (wmi == null) {
                throw new DataObjectNotFoundException(dobj.getPrimaryFile());
            }
            FileObject fob = wmi.getFileObject();
            FileObject wfo = fob.getFileSystem().findResource("WEB-INF/web.xml");
            return (DDDataObject)DataObject.find((FileObject)wfo);
        }
        catch (FileStateInvalidException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            throw new DataObjectNotFoundException(dobj.getPrimaryFile());
        }
    }

    static String getUriString(String uri) {
        StringBuffer buf = new StringBuffer();
        if (uri != null) {
            int i = 0;
            while (i < uri.length()) {
                char ch = uri.charAt(i);
                if (ch == '?') break;
                buf.append(ch);
                ++i;
            }
        }
        if (buf.length() > 0) {
            if (buf.charAt(0) == '/') {
                return buf.toString();
            }
            return "/" + buf.toString();
        }
        return "";
    }

    static void setRequestParams(MultiDataObject.Entry entry, String params) throws IOException {
        StringBuffer newParams = new StringBuffer();
        String s = null;
        if (params != null) {
            int i = 0;
            while (i < params.length()) {
                char ch = params.charAt(i);
                if (ch != '\r' && ch != '\n') {
                    newParams.append(ch);
                }
                ++i;
            }
            s = newParams.toString();
            if (s.length() == 0) {
                s = null;
            }
        }
        WebExecSupport.setQueryString(entry.getFile(), s);
    }

    static String getRequestParams(MultiDataObject.Entry entry) {
        return WebExecSupport.getQueryString(entry.getFile());
    }

    public ServletDataObject(FileObject pf, ServletDataLoader loader) throws DataObjectExistsException {
        super(pf, (MultiFileLoader)loader);
        pf.addFileChangeListener(WeakListener.fileChange((FileChangeListener)this.fcl, (Object)pf));
        this.init(pf);
    }

    private void init(FileObject pf) {
        CookieSet cookies = this.getCookieSet();
        cookies.add((Node.Cookie)new ServerExecSupport(this.getPrimaryEntry()));
        try {
            FileSystem fs;
            DDDataObject dd = this.getWebXML();
            if (dd != null) {
                this.addDDChangeListener(dd);
            }
            if ((fs = pf.getFileSystem()) instanceof DelegatingFileSystem) {
                this.folderCL = new FileChangeAdapter(){

                    public void fileRenamed(FileRenameEvent evt) {
                        FileObject fo = evt.getFile();
                        if (fo.isFolder() && !fo.isRoot() && ServletDataObject.this.getPrimaryFile().getPackageName('.').startsWith(fo.getPackageName('.'))) {
                            String newName = ServletDataObject.this.getPrimaryFile().getPackageName('.');
                            String oldname = fo.getParent().getPackageName('.');
                            oldname = oldname.length() > 0 ? oldname + '.' + evt.getName() : evt.getName();
                            oldname = oldname + newName.substring(fo.getPackageName('.').length());
                            ServletDataObject.this.fireDDChangeEvent(new DDChangeEvent((Object)this, oldname, newName, 2));
                        }
                    }
                };
                fs.addFileChangeListener(this.folderCL);
            }
        }
        catch (FileStateInvalidException ex) {
        }
        catch (DataObjectNotFoundException ex) {
            // empty catch block
        }
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected Node createNodeDelegate() {
        Lookup.Template template = new Lookup.Template(class$org$openidex$nodes$looks$Look == null ? (class$org$openidex$nodes$looks$Look = ServletDataObject.class$("org.openidex.nodes.looks.Look")) : class$org$openidex$nodes$looks$Look);
        Lookup.Result result = Lookup.getDefault().lookup(template);
        Collection cls = result.allInstances();
        Look defaultLook = null;
        Look wellKnown = null;
        ServletDataNode o = new ServletDataNode(this);
        Iterator it = cls.iterator();
        while (it.hasNext()) {
            Look look;
            if ((class$org$openidex$nodes$looks$DefaultLook == null ? ServletDataObject.class$("org.openidex.nodes.looks.DefaultLook") : class$org$openidex$nodes$looks$DefaultLook).equals((look = (Look)it.next()).getClass())) {
                if (wellKnown != null) continue;
                wellKnown = look;
                continue;
            }
            if ((class$org$openidex$nodes$looks$CompositeLook == null ? ServletDataObject.class$("org.openidex.nodes.looks.CompositeLook") : class$org$openidex$nodes$looks$CompositeLook).equals(look.getClass()) && "Web-Look".equals(look.getName())) {
                wellKnown = look;
                continue;
            }
            defaultLook = look;
        }
        if (defaultLook == null) {
            defaultLook = wellKnown;
        }
        WebLookNode ret = new WebLookNode((Object)o, wellKnown == null ? defaultLook : wellKnown);
        return ret;
    }

    public Node.Cookie getCookie(Class c) {
        if (c.isAssignableFrom(class$org$netbeans$modules$web$core$jsploader$ServletDataObject$ServletConfigCookie == null ? (class$org$netbeans$modules$web$core$jsploader$ServletDataObject$ServletConfigCookie = ServletDataObject.class$("org.netbeans.modules.web.core.jsploader.ServletDataObject$ServletConfigCookie")) : class$org$netbeans$modules$web$core$jsploader$ServletDataObject$ServletConfigCookie)) {
            if (this.configCookie == null) {
                this.configCookie = new ServletConfigSupport(this);
            }
            return this.configCookie;
        }
        return super.getCookie(c);
    }

    protected void dispose() {
        super.dispose();
        if (this.folderCL != null) {
            try {
                this.getPrimaryFile().getFileSystem().removeFileChangeListener(this.folderCL);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            this.folderCL = null;
        }
    }

    public ExecSupport getExecSupport() {
        if (this.servletExecSupport == null) {
            this.servletExecSupport = new ServletExecSupport(this.getPrimaryEntry(), new ServerExecSupport(this.getPrimaryEntry()));
        }
        return this.servletExecSupport;
    }

    public String getURIParameter() {
        FileObject fob = this.getPrimaryFile();
        try {
            String str = (String)fob.getAttribute(EA_URI);
            return str;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setURIParameter(String parameter) {
        FileObject fob = this.getPrimaryFile();
        try {
            fob.setAttribute(EA_URI, (Object)parameter);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    public String getWebModuleParameter() {
        FileObject fob = this.getPrimaryFile();
        Object o = fob.getAttribute(EA_SERVLETPARAMS_NAME);
        if (o == null || !(o instanceof String)) {
            return this.defaultWebModule();
        }
        return (String)o;
    }

    public void setWebModuleParameter(String parameter) {
        FileObject fob = this.getPrimaryFile();
        try {
            if (parameter != null && parameter.equals(this.defaultWebModule())) {
                fob.setAttribute(EA_SERVLETPARAMS_NAME, null);
            } else {
                fob.setAttribute(EA_SERVLETPARAMS_NAME, (Object)parameter);
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private String defaultWebModule() {
        String webModuleProp = null;
        try {
            WebModuleImpl webMod = ServletDataObject.getDefaultWebModuleImpl(this.getPrimaryFile());
            if (webMod != null) {
                webModuleProp = webMod.getFileObject().getFileSystem().getSystemName();
            }
        }
        catch (DataObjectNotFoundException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (FileStateInvalidException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return webModuleProp;
    }

    public DDDataObject getWebXML() throws DataObjectNotFoundException {
        return ServletDataObject.getWebXML((DataObject)this);
    }

    protected DataObject handleCreateFromTemplate(DataFolder dataFolder, String str) throws IOException {
        String packageName = dataFolder.getPrimaryFile().getPackageName('.');
        if (!JavaDataObject.isValidPackageName((String)packageName)) {
            throw new IOException(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$core$jsploader$ServletDataObject == null ? (class$org$netbeans$modules$web$core$jsploader$ServletDataObject = ServletDataObject.class$("org.netbeans.modules.web.core.jsploader.ServletDataObject")) : class$org$netbeans$modules$web$core$jsploader$ServletDataObject), (String)"FMT_Not_Valid_PkgName", (Object)packageName));
        }
        DataObject dobj = super.handleCreateFromTemplate(dataFolder, str);
        if (dobj != null && dobj.getPrimaryFile().getAttribute(EA_URI) == null) {
            String urimapping = "/servlet/" + dobj.getPrimaryFile().getPackageName('.');
            ((ServletDataObject)dobj).setURIParameter(urimapping);
        }
        return dobj;
    }

    protected FileObject handleRename(String name) throws IOException {
        String oldname = this.getPrimaryFile().getPackageName('.');
        FileObject fo = super.handleRename(name);
        if (fo != null) {
            String newName = this.getPrimaryFile().getPackageName('.');
            this.fireDDChangeEvent(new DDChangeEvent(this, oldname, newName, 2));
        }
        return fo;
    }

    protected FileObject handleMove(DataFolder df) throws IOException {
        DDDataObject fromWo;
        String origWM = this.getWebModuleParameter();
        String oldname = this.getPrimaryFile().getPackageName('.');
        FileObject fo = super.handleMove(df);
        try {
            FileObject newRoot;
            WebModuleImpl wmi = ServletDataObject.getDefaultWebModuleImpl(fo);
            FileObject fileObject = newRoot = wmi != null ? wmi.getFileObject() : null;
            if (newRoot != null) {
                fo.setAttribute(EA_SERVLETPARAMS_NAME, null);
            } else {
                fo.setAttribute(EA_SERVLETPARAMS_NAME, (Object)origWM);
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (fo == null) {
            return fo;
        }
        String newName = fo.getPackageName('.');
        try {
            fromWo = this.getWebXML();
        }
        catch (DataObjectNotFoundException ex) {
            fromWo = null;
        }
        try {
            WebModuleImpl webMod;
            String newWM = (String)fo.getAttribute(EA_SERVLETPARAMS_NAME);
            if (newWM == null && (webMod = ServletDataObject.getDefaultWebModuleImpl(fo)) != null) {
                newWM = webMod.getFileObject().getFileSystem().getSystemName();
            }
            if (newWM == null && origWM == null) {
                return fo;
            }
            if (newWM != null && newWM.equals(origWM)) {
                this.fireDDChangeEvent(new DDChangeEvent(this, oldname, newName, 2));
            } else {
                DDDataObject toWo;
                DataObject dobj = DataObject.find((FileObject)WebAppNameEditor.findWebContextFO(newWM));
                WebContextObject ctx = (WebContextObject)dobj.getCookie(class$org$netbeans$modules$web$context$WebContextObject == null ? (class$org$netbeans$modules$web$context$WebContextObject = ServletDataObject.class$("org.netbeans.modules.web.context.WebContextObject")) : class$org$netbeans$modules$web$context$WebContextObject);
                if (ctx != null) {
                    dobj = ctx.getDeploymentDescriptor();
                }
                if ((toWo = (DDDataObject)dobj.getCookie(class$org$netbeans$modules$web$dd$DDDataObject == null ? (class$org$netbeans$modules$web$dd$DDDataObject = ServletDataObject.class$("org.netbeans.modules.web.dd.DDDataObject")) : class$org$netbeans$modules$web$dd$DDDataObject)) != null) {
                    if (fromWo != null) {
                        this.removeDDChangeListener(fromWo);
                        this.addDDChangeListener(toWo);
                        this.fireDDChangeEvent(new DDChangeEvent(this, fromWo, oldname, newName, 4));
                    } else {
                        this.addDDChangeListener(toWo);
                        this.fireDDChangeEvent(new DDChangeEvent(this, null, newName, 1));
                    }
                }
            }
        }
        catch (DataObjectNotFoundException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return fo;
    }

    protected DataObject handleCopy(DataFolder df) throws IOException {
        DataObject dobj = super.handleCopy(df);
        if (dobj != null) {
            ((ServletDataObject)dobj).fireDDChangeEvent(new DDChangeEvent(dobj, null, dobj.getPrimaryFile().getPackageName('.'), 1));
        }
        return dobj;
    }

    protected void handleDelete() throws IOException {
        String name = this.getPrimaryFile().getPackageName('.');
        super.handleDelete();
        this.fireDDChangeEvent(new DDChangeEvent(this, null, name, 3));
    }

    public List getServletConfiguration(WebApp wa) {
        ArrayList<Servlet> result = new ArrayList<Servlet>();
        if (wa != null) {
            Servlet[] srvlts = wa.getServlet();
            int i = 0;
            while (i < srvlts.length) {
                if (srvlts[i].getServletClass().equals(this.getPrimaryFile().getPackageName('.'))) {
                    result.add(srvlts[i]);
                }
                ++i;
            }
        }
        return result;
    }

    public List getServletMappingConfiguration(WebApp wa) {
        ArrayList<ServletMapping> result = new ArrayList<ServletMapping>();
        if (wa == null) {
            return result;
        }
        List servlets = this.getServletConfiguration(wa);
        ServletMapping[] mappings = wa.getServletMapping();
        int i = 0;
        while (i < mappings.length) {
            ListIterator it = servlets.listIterator();
            while (it.hasNext()) {
                Servlet s = (Servlet)((Object)it.next());
                if (mappings[i].getServletName() == null || !mappings[i].getServletName().equals(s.getServletName())) continue;
                result.add(mappings[i]);
            }
            ++i;
        }
        return result;
    }

    public void setQueryString(String params) throws IOException {
        ServletDataObject.setRequestParams(this.getPrimaryEntry(), params);
        this.firePropertyChange("requestparams", null, null);
    }

    public synchronized void addDDChangeListener(DDChangeListener l) {
        if (this.servletLsnr == null) {
            this.servletLsnr = new Vector();
        }
        this.servletLsnr.addElement(l);
    }

    public synchronized void removeDDChangeListener(DDChangeListener l) {
        if (this.servletLsnr == null) {
            return;
        }
        this.servletLsnr.removeElement(l);
    }

    void fireDDChangeEvent(DDChangeEvent evt) {
        Vector targets = null;
        ServletDataObject servletDataObject = this;
        synchronized (servletDataObject) {
            if (this.servletLsnr != null) {
                targets = (Vector)this.servletLsnr.clone();
            }
        }
        if (targets != null) {
            int i = 0;
            while (i < targets.size()) {
                DDChangeListener target = (DDChangeListener)targets.elementAt(i);
                target.deploymentChange(evt);
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ServletConfigSupport
    implements ServletConfigCookie {
        private ServletDataObject servlet;
        static /* synthetic */ Class class$org$netbeans$modules$web$dd$DDDataObject;

        ServletConfigSupport(ServletDataObject s) {
            this.servlet = s;
        }

        public List getServletMappings(String webModule) {
            ArrayList<String> values = new ArrayList<String>();
            try {
                if (webModule == null || webModule.equals("")) {
                    return values;
                }
                WebContextObject webCtx = WebContextLoader.findContext(Repository.getDefault().findFileSystem(webModule));
                if (webCtx == null) {
                    return values;
                }
                DataObject dobj = webCtx.getDeploymentDescriptor();
                if (dobj == null) {
                    return values;
                }
                DDDataObject dd = (DDDataObject)dobj.getCookie(class$org$netbeans$modules$web$dd$DDDataObject == null ? (class$org$netbeans$modules$web$dd$DDDataObject = ServletConfigSupport.class$("org.netbeans.modules.web.dd.DDDataObject")) : class$org$netbeans$modules$web$dd$DDDataObject);
                if (dd == null) {
                    return values;
                }
                Servlet[] servletElems = dd.getServlets();
                ServletMapping[] mappingElems = dd.getMappings();
                if (servletElems == null || mappingElems == null) {
                    return values;
                }
                String clz = this.servlet.getPrimaryFile().getPackageName('.');
                int i = 0;
                while (i < servletElems.length) {
                    String sc = servletElems[i].getServletClass();
                    if (sc != null && sc.equals(clz)) {
                        int j = 0;
                        while (j < mappingElems.length) {
                            if (servletElems[i].getServletName().equals(mappingElems[j].getServletName())) {
                                values.add(mappingElems[j].getUrlPattern());
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return values;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class ServletChangeListener
    extends FileChangeAdapter {
        public void fileChanged(FileEvent fe) {
            WebModuleImpl webModule = ServletExecPerformer.getWebModuleForDO((DataObject)ServletDataObject.this);
            WebServletImpl servletData = WebDataFactory.getFactory().getWebServlet(ServletDataObject.this.getPrimaryFile().getPackageNameExt('/', '.'), webModule);
            if (webModule != null && servletData != null) {
                webModule.fireWebModuleChanged(2, 2, (WebStandardData)servletData);
            }
        }
    }

    private class ServletExecSupport
    extends ExecSupport {
        private ServerExecSupport orig;

        public ServletExecSupport(MultiDataObject.Entry entry, ServerExecSupport orig) {
            super(entry);
            this.orig = orig;
        }

        protected DebuggerType defaultDebuggerType() {
            return this.orig.defaultDebuggerType();
        }

        protected Executor defaultExecutor() {
            return this.orig.defaultExecutor();
        }

        public void addProperties(Sheet.Set set) {
            this.orig.addProperties(set);
        }
    }

    public static interface ServletConfigCookie
    extends Node.Cookie {
        public List getServletMappings(String var1);
    }
}

