/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.web.core.jsploader.CESLine;
import org.netbeans.modules.web.core.jsploader.ServletEditor;
import org.openide.loaders.DataObject;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;

public class ServletLine
extends Line
implements CESLine {
    private CloneableEditorSupport.Env editorEnv;
    protected Line orig;
    private boolean detaching;
    private static final long serialVersionUID = -7983358653137935774L;

    public ServletLine(Line orig, ServletEditor editor) {
        super((DataObject)editor.getServlet());
        this.orig = orig;
        this.editorEnv = editor.jspEnv();
    }

    public CloneableEditorSupport getCloneableEditorSupport() {
        return (ServletEditor)this.editorEnv.findCloneableOpenSupport();
    }

    public int hashCode() {
        return this.orig.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof CESLine && o instanceof Line) {
            Line l = (Line)o;
            CloneableEditorSupport otherEditor = ((CESLine)o).getCloneableEditorSupport();
            if (this.getCloneableEditorSupport() == otherEditor) {
                return this.getLineNumber() == l.getLineNumber();
            }
        }
        return false;
    }

    protected void addAnnotation(Annotation anno) {
        super.addAnnotation(anno);
        anno.attach((Annotatable)this.orig);
    }

    protected void removeAnnotation(Annotation anno) {
        if (this.detaching) {
            this.detaching = false;
            return;
        }
        super.removeAnnotation(anno);
        this.detaching = true;
        anno.detach();
    }

    public String getText() {
        return this.orig.getText();
    }

    public int getLineNumber() {
        return this.orig.getLineNumber();
    }

    public void show(int kind, int column) {
        this.orig.show(kind, column);
    }

    public void show(int kind) {
        this.orig.show(kind);
    }

    public void setBreakpoint(boolean b) {
        this.orig.setBreakpoint(b);
    }

    public boolean isBreakpoint() {
        return this.orig.isBreakpoint();
    }

    public void markError() {
        this.orig.markError();
    }

    public void unmarkError() {
        this.orig.unmarkError();
    }

    public void markCurrentLine() {
        this.orig.markCurrentLine();
    }

    public void unmarkCurrentLine() {
        this.orig.unmarkCurrentLine();
    }

    public boolean canBeMarkedCurrent(int action, Line previousLine) {
        return this.orig.canBeMarkedCurrent(action, previousLine);
    }

    public static class Set
    extends Line.Set {
        protected ServletEditor editor;
        protected Line.Set delegate;
        protected ArrayList linesCache;

        public Set(Line.Set delegate, ServletEditor editor) {
            this.delegate = delegate;
            this.editor = editor;
        }

        public List getLines() {
            if (this.linesCache == null) {
                List lines = this.delegate.getLines();
                this.linesCache = new ArrayList();
                int i = 0;
                while (i < lines.size()) {
                    this.linesCache.add(new ServletLine((Line)lines.get(i), this.editor));
                    ++i;
                }
            }
            return this.linesCache;
        }

        public Line getOriginal(int line) throws IndexOutOfBoundsException {
            return new ServletLine(this.delegate.getOriginal(line), this.editor);
        }

        public Line getCurrent(int line) throws IndexOutOfBoundsException {
            return new ServletLine(this.delegate.getCurrent(line), this.editor);
        }
    }
}

