/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.TreeMap;
import org.netbeans.modules.web.core.jsploader.JspCompileUtil;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.netbeans.modules.web.core.jsploader.JspInfo;
import org.netbeans.modules.web.core.jsploader.JspParserAPI;
import org.openide.ErrorManager;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class TagLibParseSupport
implements Node.Cookie {
    private JspDataObject jspdo;
    private boolean documentDirty;
    private RequestProcessor.Task parsingTask = null;
    private WeakReference tagLibEditorDataRef;

    public TagLibParseSupport(JspDataObject jspdo) {
        this.jspdo = jspdo;
    }

    public TagLibEditorData getTagLibEditorData() {
        return this.getTagLibEditorData(true);
    }

    TagLibEditorData getTagLibEditorData(boolean prepare) {
        Object o;
        if (this.tagLibEditorDataRef != null && (o = this.tagLibEditorDataRef.get()) != null) {
            return (TagLibEditorData)o;
        }
        TagLibEditorData tled = new TagLibEditorData(this);
        this.tagLibEditorDataRef = new WeakReference<TagLibEditorData>(tled);
        if (prepare) {
            this.prepare();
        }
        return tled;
    }

    synchronized void setDocumentDirty(boolean b) {
        this.documentDirty = b;
    }

    boolean isDocumentDirty() {
        return this.documentDirty;
    }

    RequestProcessor.Task autoParse() {
        return this.parseObject(1);
    }

    public RequestProcessor.Task prepare() {
        return this.parseObject(9);
    }

    private synchronized RequestProcessor.Task parseObject(int priority) {
        RequestProcessor.Task t = this.parsingTask;
        if (t != null) {
            t.setPriority(Math.max(t.getPriority(), priority));
            return t;
        }
        this.setDocumentDirty(false);
        this.parsingTask = t = RequestProcessor.postRequest((Runnable)new ParsingRunnable(), (int)0, (int)priority);
        return this.parsingTask;
    }

    static TagLibData createTagLibData(JspInfo.TagLibraryData info, FileSystem fs) {
        JspParserAPI parser = JspCompileUtil.getJspParser();
        if (parser == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException());
            return null;
        }
        return parser.createTagLibData(info, fs);
    }

    public static abstract class TagLibData {
        public abstract boolean equalsColoringInformation(TagLibData var1);

        public abstract String getPrefix();

        public abstract Object getTagLibraryInfo();
    }

    public static class TagLibEditorData
    extends PropertyChangeSupport {
        public static final String PROP_COLORING_CHANGE = "coloringChange";
        private TreeMap libraryMap = new TreeMap();
        private JspInfo.BeanData[] beanData = new JspInfo.BeanData[0];
        private boolean errorPage = false;

        TagLibEditorData(Object sourceBean) {
            super(sourceBean);
        }

        public void setBeanData(JspInfo.BeanData[] beanData) {
            this.beanData = beanData;
        }

        public JspInfo.BeanData[] getBeanData() {
            return this.beanData;
        }

        public void setErrorPage(boolean errorPage) {
            this.errorPage = errorPage;
        }

        public boolean isErrorPage() {
            return this.errorPage;
        }

        void applyParsedData(JspInfo.TagLibraryData[] taglibs, FileSystem fs) {
            TreeMap<String, TagLibData> otherMap = new TreeMap<String, TagLibData>();
            int i = 0;
            while (i < taglibs.length) {
                String prefix = taglibs[i].getPrefix();
                otherMap.put(prefix, TagLibParseSupport.createTagLibData(taglibs[i], fs));
                ++i;
            }
            boolean coloringChanged = false;
            if (this.libraryMap.size() != otherMap.size()) {
                coloringChanged = true;
            } else {
                TagLibData[] myTagLibData = this.getTagLibData();
                TagLibData[] otherTagLibData = otherMap.values().toArray(new TagLibData[otherMap.size()]);
                int i2 = 0;
                while (i2 < myTagLibData.length) {
                    if (!myTagLibData[i2].equalsColoringInformation(otherTagLibData[i2])) {
                        coloringChanged = true;
                        break;
                    }
                    ++i2;
                }
            }
            this.libraryMap = otherMap;
            if (coloringChanged) {
                this.firePropertyChange(PROP_COLORING_CHANGE, null, null);
            }
        }

        public TagLibData[] getTagLibData() {
            return this.libraryMap.values().toArray(new TagLibData[this.libraryMap.size()]);
        }

        public TagLibData getTagLibData(String prefix) {
            return (TagLibData)this.libraryMap.get(prefix);
        }

        protected void finalize() throws Throwable {
            super.finalize();
        }
    }

    private class ParsingRunnable
    implements Runnable {
        public void run() {
            TagLibParseSupport tagLibParseSupport;
            try {
                try {
                    JspParserAPI parser = JspCompileUtil.getJspParser();
                    if (parser == null) {
                        ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException());
                    } else {
                        JspParserAPI.ParseResult result = parser.parsePage(TagLibParseSupport.this.jspdo, JspCompileUtil.getContextPath(TagLibParseSupport.this.jspdo.getPrimaryFile()));
                        if (result.isParsingSuccess()) {
                            JspInfo info = result.getPageInfo();
                            TagLibParseSupport.this.getTagLibEditorData(false).applyParsedData(info.getTagLibraryData(), TagLibParseSupport.this.jspdo.getPrimaryFile().getFileSystem());
                            TagLibParseSupport.this.getTagLibEditorData(false).setBeanData(info.getBeans());
                            TagLibParseSupport.this.getTagLibEditorData(false).setErrorPage(info.isErrorPage());
                        }
                    }
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                Object var5_5 = null;
                tagLibParseSupport = TagLibParseSupport.this;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                TagLibParseSupport tagLibParseSupport2 = TagLibParseSupport.this;
                synchronized (tagLibParseSupport2) {
                    TagLibParseSupport.this.parsingTask = null;
                }
                throw throwable;
            }
            synchronized (tagLibParseSupport) {
                TagLibParseSupport.this.parsingTask = null;
            }
        }
    }
}

