/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.TreeSet;
import org.netbeans.modules.web.context.WebContextLoader;
import org.netbeans.modules.web.context.WebContextObject;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;

public class WebAppNameEditor
extends PropertyEditorSupport {
    public String[] getTags() {
        Collection c = WebAppNameEditor.getWebAppDisplayNames();
        return c.toArray(new String[c.size()]);
    }

    public String getAsText() {
        return WebAppNameEditor.getDisplayNameFromSystemName((String)this.getValue());
    }

    public void setAsText(String text) {
        this.setValue(WebAppNameEditor.getSystemNameFromDisplayName(text));
    }

    public static Collection getWebAppSystemNames() {
        TreeSet<String> allWebApps = new TreeSet<String>();
        Repository repository = Repository.getDefault();
        Enumeration e = repository.fileSystems();
        while (e.hasMoreElements()) {
            allWebApps.add(((FileSystem)e.nextElement()).getSystemName());
        }
        return allWebApps;
    }

    public static Collection getWebAppDisplayNames() {
        Repository repository = Repository.getDefault();
        Enumeration e = repository.fileSystems();
        TreeSet<String> allWebApps = new TreeSet<String>();
        while (e.hasMoreElements()) {
            FileSystem fs = (FileSystem)e.nextElement();
            if (!WebContextLoader.isWebApplication(fs)) continue;
            allWebApps.add(fs.getDisplayName());
        }
        return allWebApps;
    }

    public static FileObject findWebContextFO(String systemName) {
        Repository repository = Repository.getDefault();
        Enumeration e = repository.fileSystems();
        while (e.hasMoreElements()) {
            FileSystem fs = (FileSystem)e.nextElement();
            if (!WebContextLoader.isWebApplication(fs) || !fs.getSystemName().equals(systemName)) continue;
            return fs.getRoot();
        }
        return null;
    }

    public static String getDisplayNameFromSystemName(String systemName) {
        Repository repository = Repository.getDefault();
        FileSystem fileSystem = repository.findFileSystem(systemName);
        if (fileSystem == null) {
            return "";
        }
        return fileSystem.getDisplayName();
    }

    public static String getSystemNameFromDisplayName(String displayName) {
        Enumeration e = Repository.getDefault().getFileSystems();
        while (e.hasMoreElements()) {
            FileSystem fs = (FileSystem)e.nextElement();
            if (!fs.getDisplayName().equals(displayName)) continue;
            return fs.getSystemName();
        }
        return "";
    }

    public static DataObject getDDForModuleFromSystemName(String systemName) {
        Repository repository = Repository.getDefault();
        Enumeration e = repository.fileSystems();
        while (e.hasMoreElements()) {
            FileSystem fs = (FileSystem)e.nextElement();
            if (!fs.getSystemName().equals(systemName) || !WebContextLoader.isWebApplication(fs)) continue;
            try {
                WebContextObject wco = WebContextLoader.findContext(fs);
                return wco.getDeploymentDescriptor();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(4096, (Throwable)ex);
            }
        }
        return null;
    }
}

