/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WebXMLSupport
implements Node.Cookie {
    public static final String PROP_TAGLIBRARYMAP = "tagLibraryMap";
    protected DataObject dobj;
    protected Map tagLibraryMap;
    private transient PropertyChangeSupport pcs;
    private static final Map association = new WeakHashMap();

    public WebXMLSupport(DataObject dobj) {
        this.dobj = dobj;
        dobj.getPrimaryFile().addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

            public void fileChanged(FileEvent fe) {
                WebXMLSupport.this.invalidate();
            }

            public void fileDeleted(FileEvent fe) {
                WebXMLSupport.this.invalidate();
            }

            public void fileRenamed(FileRenameEvent fe) {
                WebXMLSupport.this.invalidate();
            }
        });
    }

    public Map getTagLibraryMap() {
        if (this.tagLibraryMap == null) {
            WebXMLSupport webXMLSupport = this;
            synchronized (webXMLSupport) {
                if (this.tagLibraryMap == null) {
                    this.tagLibraryMap = this.createTagLibraryMap();
                }
            }
        }
        return this.tagLibraryMap;
    }

    private Map createTagLibraryMap() {
        TreeMap<String, String> map;
        block9: {
            map = new TreeMap<String, String>();
            try {
                Document webxml = XMLDataObject.parse((URL)this.dobj.getPrimaryFile().getURL(), (ErrorHandler)new ErrorHandler(){

                    public void error(SAXParseException exception) throws SAXException {
                    }

                    public void fatalError(SAXParseException exception) throws SAXException {
                        throw exception;
                    }

                    public void warning(SAXParseException exception) throws SAXException {
                    }
                }, (boolean)true);
                NodeList nList = webxml.getElementsByTagName("taglib");
                if (nList.getLength() != 0) {
                    int i = 0;
                    while (i < nList.getLength()) {
                        Element e = (Element)nList.item(i);
                        NodeList list = e.getChildNodes();
                        String tagLoc = null;
                        String uri = null;
                        int j = 0;
                        while (j < list.getLength()) {
                            Text t;
                            Node em = list.item(j);
                            String tname = em.getNodeName();
                            if (tname.equals("taglib-location") && (t = (Text)em.getFirstChild()) != null && (tagLoc = t.getData()) != null && !(tagLoc = tagLoc.trim()).startsWith("/")) {
                                tagLoc = "/WEB-INF/" + tagLoc;
                            }
                            if (tname.equals("taglib-uri") && (t = (Text)em.getFirstChild()) != null && (uri = t.getData()) != null) {
                                uri = uri.trim();
                            }
                            ++j;
                        }
                        if (tagLoc != null && uri != null) {
                            map.put(uri, tagLoc);
                        }
                        ++i;
                    }
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            catch (SAXException e) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block9;
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return map;
    }

    private synchronized void invalidate() {
        this.tagLibraryMap = null;
        this.fireWebXMLChange();
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.pcs == null) {
            return;
        }
        this.pcs.removePropertyChangeListener(pcl);
    }

    void fireWebXMLChange() {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(PROP_TAGLIBRARYMAP, null, null);
        }
    }

    public static WebXMLSupport getWebXMLSupport(DataObject dobj) {
        WebXMLSupport sup = (WebXMLSupport)association.get(dobj);
        if (sup == null) {
            sup = new WebXMLSupport(dobj);
            association.put(dobj, sup);
        }
        return sup;
    }
}

