/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.dd;

import java.util.Vector;
import org.netbeans.modules.j2ee.impl.DummyAppSrvCustomData;
import org.netbeans.modules.j2ee.impl.ServerRegistryImpl;
import org.netbeans.modules.j2ee.server.CustomDialogData;
import org.netbeans.modules.j2ee.server.Server;
import org.netbeans.modules.j2ee.server.ServerRegistry;
import org.netbeans.modules.j2ee.server.datamodel.StandardData;
import org.netbeans.modules.j2ee.server.datamodel.WebStandardData;
import org.netbeans.modules.j2ee.server.web.WebConfigSupport;
import org.netbeans.modules.j2ee.server.web.WebCustomData;
import org.netbeans.modules.j2ee.server.web.WebServer;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.web.dd.DDDataObject;
import org.netbeans.modules.web.dd.model.EjbLocalRef;
import org.netbeans.modules.web.dd.model.EjbRef;
import org.netbeans.modules.web.dd.model.ResourceEnvRef;
import org.netbeans.modules.web.dd.model.ResourceRef;
import org.netbeans.modules.web.dd.model.Servlet;
import org.netbeans.modules.web.webdata.WebDataFactory;
import org.netbeans.modules.web.webdata.WebModuleImpl;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Sheet;

public class DDUtils {
    public static WebConfigSupport[] getWebConfigSupports() {
        ServerRegistryImpl registry = (ServerRegistryImpl)ServerRegistry.getServerRegistry();
        WebServer[] servers = registry.getWebServers();
        Vector<WebConfigSupport> vec = new Vector<WebConfigSupport>();
        int i = 0;
        while (i < servers.length) {
            WebConfigSupport sup = null;
            try {
                sup = servers[i].getWebConfigSupport();
                if (sup == null) {
                    sup = new DummyAppSrvCustomData((Server)servers[i]);
                }
                vec.add(sup);
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
        WebConfigSupport[] supports = new WebConfigSupport[vec.size()];
        vec.toArray(supports);
        return supports;
    }

    public static WebModuleImpl getWebModule(FileObject fo) {
        WebDataFactory factory = WebDataFactory.getFactory();
        return factory.findWebModule(fo);
    }

    public static Sheet.Set[] getModuleCustomDataSheet(DDDataObject obj) {
        if (obj == null) {
            return null;
        }
        ServerRegistryImpl registry = (ServerRegistryImpl)ServerRegistry.getServerRegistry();
        WebServer[] servers = registry.getWebServers();
        FileObject root = null;
        try {
            root = obj.getPrimaryFile().getFileSystem().getRoot();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (root == null) {
            return null;
        }
        WebDataFactory factory = WebDataFactory.getFactory();
        WebModuleImpl module = factory.findWebModule(root);
        if (module == null) {
            return null;
        }
        Vector<Sheet.Set> vec = new Vector<Sheet.Set>();
        int i = 0;
        while (i < servers.length) {
            WebCustomData.WebConfigurator cd;
            WebConfigSupport support = servers[i].getWebConfigSupport();
            if (support == null) {
                support = new DummyAppSrvCustomData((Server)servers[i]);
            }
            if ((cd = obj.getWebModuleCustomData(support)) != null) {
                Sheet.Set[] sets = cd.createSheetSets((StandardData)module);
                if (sets != null) {
                    int j = 0;
                    while (j < sets.length) {
                        vec.add(sets[j]);
                        ++j;
                    }
                } else {
                    vec.add(DummyAppSrvCustomData.getEmptyTab((Server)servers[i]));
                }
            }
            ++i;
        }
        Sheet.Set[] sheetSet = new Sheet.Set[vec.size()];
        int i2 = 0;
        while (i2 < sheetSet.length) {
            sheetSet[i2] = (Sheet.Set)vec.elementAt(i2);
            ++i2;
        }
        return sheetSet;
    }

    public static Sheet.Set[] getModuleCustomDataSheet(DDDataObject obj, WebServer server) {
        WebCustomData.WebConfigurator cd;
        if (obj == null) {
            return null;
        }
        FileObject root = null;
        try {
            root = obj.getPrimaryFile().getFileSystem().getRoot();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (root == null) {
            return null;
        }
        WebDataFactory factory = WebDataFactory.getFactory();
        WebModuleImpl module = factory.findWebModule(root);
        if (module == null) {
            return null;
        }
        Vector<Sheet.Set> vec = new Vector<Sheet.Set>();
        WebConfigSupport support = server.getWebConfigSupport();
        if (support == null) {
            support = new DummyAppSrvCustomData((Server)server);
        }
        if ((cd = obj.getWebModuleCustomData(support)) != null) {
            Sheet.Set[] sets = cd.createSheetSets((StandardData)module);
            if (sets != null) {
                int j = 0;
                while (j < sets.length) {
                    vec.add(sets[j]);
                    ++j;
                }
            } else {
                vec.add(DummyAppSrvCustomData.getEmptyTab((Server)server));
            }
        }
        Sheet.Set[] sheetSet = new Sheet.Set[vec.size()];
        int i = 0;
        while (i < sheetSet.length) {
            sheetSet[i] = (Sheet.Set)vec.elementAt(i);
            ++i;
        }
        return sheetSet;
    }

    public static WebStandardData getStandardData(WebModuleImpl module, BaseBean bean) {
        WebDataFactory webFact = WebDataFactory.getFactory();
        if (bean instanceof ResourceRef) {
            return webFact.getResourceRefData(bean, module.getWebModule());
        }
        if (bean instanceof ResourceEnvRef) {
            return webFact.getResourceEnvRefData(bean, module.getWebModule());
        }
        if (bean instanceof EjbRef) {
            return webFact.getEjbRefData(bean, module.getWebModule());
        }
        if (bean instanceof EjbLocalRef) {
            return webFact.getEjbLocalRefData(bean, module.getWebModule());
        }
        if (bean instanceof Servlet) {
            return webFact.getServletJspData(bean, module.getWebModule());
        }
        return null;
    }

    public static CustomDialogData getCustomDialogData(WebCustomData.WebConfigurator config, WebStandardData stdData) {
        if (stdData instanceof WebStandardData.ResourceRefData) {
            return config.getResourceRefCustomData((WebStandardData.ResourceRefData)stdData);
        }
        if (stdData instanceof WebStandardData.ResourceEnvRefData) {
            return config.getResourceEnvRefCustomData((WebStandardData.ResourceEnvRefData)stdData);
        }
        if (stdData instanceof WebStandardData.EjbRefData) {
            return config.getEjbRefCustomData((WebStandardData.EjbRefData)stdData);
        }
        if (stdData instanceof WebStandardData.EjbLocalRefData) {
            return config.getEjbLocalRefCustomData((WebStandardData.EjbLocalRefData)stdData);
        }
        if (stdData instanceof WebStandardData.EnvironmentEntryData) {
            return config.getEnvEntryCustomData((WebStandardData.EnvironmentEntryData)stdData);
        }
        if (stdData instanceof WebStandardData.ServletJspData) {
            return config.getServletJspCustomData((WebStandardData.ServletJspData)stdData);
        }
        return null;
    }

    private static DDDataObject getDDDataObject(FileObject fo) {
        DDDataObject dd = null;
        try {
            dd = (DDDataObject)DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException e) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return dd;
    }

    public static String findFreeName(BaseBean[] elements, String identifier, String name) {
        if (DDUtils.checkFreeName(elements, identifier, name)) {
            return name;
        }
        int i = 1;
        String destName;
        while (!DDUtils.checkFreeName(elements, identifier, destName = name + "_" + i)) {
            ++i;
        }
        return destName;
    }

    private static boolean checkFreeName(BaseBean[] elements, String identifier, Object o) {
        int i = 0;
        while (i < elements.length) {
            Object val = elements[i].getValue(identifier);
            if (val != null && val.equals(o)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

