/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.dd.wizards;

import java.awt.Component;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.web.context.ContextUtil;
import org.netbeans.modules.web.context.WebContextObject;
import org.netbeans.modules.web.dd.DDDataObject;
import org.netbeans.modules.web.dd.model.Filter;
import org.netbeans.modules.web.dd.model.FilterMapping;
import org.netbeans.modules.web.dd.model.Servlet;
import org.netbeans.modules.web.dd.model.WebApp;
import org.netbeans.modules.web.dd.wizards.FilterPanel;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class FilterIterator
implements TemplateWizard.Iterator {
    private FilterPanel panel;
    private WebContextObject webContext;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient TemplateWizard wiz;
    private static final long serialVersionUID = 7989893229939156917L;
    static /* synthetic */ Class class$org$netbeans$modules$web$dd$wizards$FilterIterator;
    static /* synthetic */ Class class$org$openide$cookies$OpenCookie;

    protected WizardDescriptor.Panel[] createPanels() {
        this.panel = new FilterPanel(this);
        return new WizardDescriptor.Panel[]{this.wiz.targetChooser(), this.panel};
    }

    protected String[] createSteps() {
        return new String[]{null, NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$FilterIterator == null ? (class$org$netbeans$modules$web$dd$wizards$FilterIterator = FilterIterator.class$("org.netbeans.modules.web.dd.wizards.FilterIterator")) : class$org$netbeans$modules$web$dd$wizards$FilterIterator), (String)"LBL_configure_deployment")};
    }

    public Set instantiate(TemplateWizard wiz) throws IOException {
        OpenCookie open;
        String filter0Name = wiz.getTargetName();
        DataFolder targetFolder = wiz.getTargetFolder();
        DataObject template = wiz.getTemplate();
        DataObject result = filter0Name == null ? template.createFromTemplate(targetFolder) : template.createFromTemplate(targetFolder, filter0Name);
        if (this.panel.createElementInDD()) {
            FileObject folder = targetFolder.getPrimaryFile();
            WebContextObject webContext = this.findWebModule(folder);
            if (webContext != null) {
                DDDataObject ddDataObj;
                WebApp webApp;
                DataObject dd;
                String packName = folder.getPackageName('.');
                String resultName = result.getPrimaryFile().getName();
                String className = (packName.length() == 0 ? "" : packName + ".") + resultName;
                String filterName = this.panel.getFilterName();
                if (filterName.length() == 0) {
                    filterName = className;
                }
                String servletName = this.panel.getServletName();
                String urlPattern = this.panel.getUrlPattern();
                if (servletName != null && servletName.length() == 0 || urlPattern != null && urlPattern.length() == 0) {
                    servletName = null;
                    urlPattern = "/*";
                }
                if ((dd = webContext.getDeploymentDescriptor()) instanceof DDDataObject && (webApp = (ddDataObj = (DDDataObject)dd).getWebApp()) != null) {
                    if (!ddDataObj.canEdit23Elements(true, 0)) {
                        return null;
                    }
                    boolean alreadyExists = false;
                    Filter[] oldFilters = webApp.getFilter();
                    int i = 0;
                    while (i < oldFilters.length) {
                        if (filterName.equals(oldFilters[i].getFilterName())) {
                            oldFilters[i].setFilterClass(className);
                            alreadyExists = true;
                            break;
                        }
                        ++i;
                    }
                    if (!alreadyExists) {
                        Filter filter = new Filter();
                        filter.setFilterName(filterName);
                        filter.setFilterClass(className);
                        webApp.addFilter(filter);
                    }
                    alreadyExists = false;
                    FilterMapping[] oldMappings = webApp.getFilterMapping();
                    int i2 = 0;
                    while (i2 < oldMappings.length) {
                        if (filterName.equals(oldMappings[i2].getFilterName())) {
                            if (urlPattern == null) {
                                oldMappings[i2].setServletName(servletName);
                                oldMappings[i2].setUrlPattern(null);
                            } else {
                                oldMappings[i2].setUrlPattern(urlPattern);
                                oldMappings[i2].setServletName(null);
                            }
                            alreadyExists = true;
                            break;
                        }
                        ++i2;
                    }
                    if (!alreadyExists) {
                        FilterMapping mapping = new FilterMapping();
                        mapping.setFilterName(filterName);
                        if (urlPattern == null) {
                            mapping.setServletName(servletName);
                        } else {
                            mapping.setUrlPattern(urlPattern);
                        }
                        webApp.addFilterMapping(mapping);
                    }
                    ddDataObj.setNodeDirty(true);
                }
            } else {
                String mes = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$FilterIterator == null ? (class$org$netbeans$modules$web$dd$wizards$FilterIterator = FilterIterator.class$("org.netbeans.modules.web.dd.wizards.FilterIterator")) : class$org$netbeans$modules$web$dd$wizards$FilterIterator), (String)"TXT_cannotFindWebModule"), "filter");
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            }
        }
        if ((open = (OpenCookie)result.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = FilterIterator.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie)) != null) {
            open.open();
        }
        return Collections.singleton(result);
    }

    public void initialize(TemplateWizard wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        int i = 0;
        while (i < this.panels.length) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (c instanceof JComponent) {
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
            }
            ++i;
        }
    }

    public void uninitialize(TemplateWizard wiz) {
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$FilterIterator == null ? (class$org$netbeans$modules$web$dd$wizards$FilterIterator = FilterIterator.class$("org.netbeans.modules.web.dd.wizards.FilterIterator")) : class$org$netbeans$modules$web$dd$wizards$FilterIterator), (String)"TITLE_x_of_y", (Object)new Integer(this.index + 1), (Object)new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    private WebContextObject findWebModule(FileObject fo) {
        FileObject webModuleFO = ContextUtil.findContextRoot(fo);
        if (webModuleFO != null) {
            DataObject rootDO = null;
            try {
                rootDO = DataObject.find((FileObject)webModuleFO);
            }
            catch (DataObjectNotFoundException e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
            }
            if (rootDO instanceof WebContextObject) {
                this.webContext = (WebContextObject)rootDO;
                return this.webContext;
            }
        }
        return null;
    }

    TemplateWizard getTemplateWizard() {
        return this.wiz;
    }

    String[] getServletNames() {
        String[] servletNames = new String[]{};
        try {
            WebApp webApp;
            DataObject dd;
            FileObject folder = this.wiz.getTargetFolder().getPrimaryFile();
            this.webContext = this.findWebModule(folder);
            if (this.webContext != null && (dd = this.webContext.getDeploymentDescriptor()) instanceof DDDataObject && (webApp = ((DDDataObject)dd).getWebApp()) != null) {
                Servlet[] servlets = webApp.getServlet();
                servletNames = new String[servlets.length];
                int i = 0;
                while (i < servlets.length) {
                    servletNames[i] = servlets[i].getServletName();
                    ++i;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return servletNames;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

