/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.dd.wizards;

import java.awt.Component;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.web.dd.wizards.FilterIterator;
import org.netbeans.modules.web.dd.wizards.FilterVisualPanel;
import org.openide.WizardDescriptor;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;

public class FilterPanel
implements WizardDescriptor.Panel,
ChangeListener {
    private FilterIterator iterator;
    private FilterVisualPanel component;
    private final Set listeners = new HashSet(1);

    public FilterPanel(FilterIterator iterator) {
        this.iterator = iterator;
        this.addChangeListener(this);
    }

    public String getFilterName() {
        return this.component.getFilterName();
    }

    public String getServletName() {
        return this.component.getServletName();
    }

    public String getUrlPattern() {
        return this.component.getUrlPattern();
    }

    boolean createElementInDD() {
        return this.component.createElementInDD();
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new FilterVisualPanel(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("filter_addtodd");
    }

    public boolean isValid() {
        return this.component.finishEnabled();
    }

    public final void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    public final void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    protected final void fireChangeEvent() {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }

    public void readSettings(Object settings) {
        if (settings instanceof TemplateWizard) {
            TemplateWizard w = (TemplateWizard)settings;
            String pack = null;
            try {
                pack = w.getTargetFolder().getPrimaryFile().getPackageName('.');
            }
            catch (IOException e) {
                // empty catch block
            }
            String targetName = w.getTargetName();
            String name = (pack == null || pack.length() == 0 ? "" : pack + ".") + (targetName == null ? w.getTemplate().getPrimaryFile().getName() : targetName);
            this.component.setFilterName(name);
            this.component.setServletNames(this.iterator.getServletNames());
        }
    }

    public void storeSettings(Object settings) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
    }
}

