/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.dd.wizards;

import java.awt.Component;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.web.context.ContextUtil;
import org.netbeans.modules.web.context.WebContextObject;
import org.netbeans.modules.web.dd.DDDataObject;
import org.netbeans.modules.web.dd.model.Listener;
import org.netbeans.modules.web.dd.model.WebApp;
import org.netbeans.modules.web.dd.wizards.ListenerPanel;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class ListenerIterator
implements TemplateWizard.Iterator {
    private ListenerPanel panel;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient TemplateWizard wiz;
    private static final long serialVersionUID = -7586964579556513549L;
    static /* synthetic */ Class class$org$netbeans$modules$web$dd$wizards$ListenerIterator;
    static /* synthetic */ Class class$org$openide$cookies$OpenCookie;

    protected WizardDescriptor.Panel[] createPanels() {
        this.panel = new ListenerPanel();
        return new WizardDescriptor.Panel[]{this.wiz.targetChooser(), this.panel};
    }

    protected String[] createSteps() {
        return new String[]{null, NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ListenerIterator == null ? (class$org$netbeans$modules$web$dd$wizards$ListenerIterator = ListenerIterator.class$("org.netbeans.modules.web.dd.wizards.ListenerIterator")) : class$org$netbeans$modules$web$dd$wizards$ListenerIterator), (String)"LBL_configure_deployment")};
    }

    public Set instantiate(TemplateWizard wiz) throws IOException {
        OpenCookie open;
        DataFolder targetFolder = wiz.getTargetFolder();
        String listenerName = wiz.getTargetName();
        DataObject template = wiz.getTemplate();
        DataObject result = listenerName == null ? template.createFromTemplate(targetFolder) : template.createFromTemplate(targetFolder, listenerName);
        if (this.panel.createElementInDD()) {
            FileObject folder = wiz.getTargetFolder().getPrimaryFile();
            WebContextObject webContext = this.findWebModule(folder);
            if (webContext != null) {
                DDDataObject ddDataObj;
                WebApp webApp;
                String packName = folder.getPackageName('.');
                String resultName = result.getPrimaryFile().getName();
                String className = (packName.length() == 0 ? "" : packName + ".") + resultName;
                DataObject dd = webContext.getDeploymentDescriptor();
                if (dd instanceof DDDataObject && (webApp = (ddDataObj = (DDDataObject)dd).getWebApp()) != null) {
                    if (!ddDataObj.canEdit23Elements(true, 0)) {
                        return null;
                    }
                    Listener[] oldListeners = webApp.getListener();
                    boolean alreadyExists = false;
                    int i = 0;
                    while (i < oldListeners.length) {
                        if (className.equals(oldListeners[i].getListenerClass())) {
                            alreadyExists = true;
                            break;
                        }
                        ++i;
                    }
                    if (!alreadyExists) {
                        Listener listener = new Listener();
                        listener.setListenerClass(className);
                        webApp.addListener(listener);
                        ddDataObj.setNodeDirty(true);
                    }
                }
            } else {
                String mes = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ListenerIterator == null ? (class$org$netbeans$modules$web$dd$wizards$ListenerIterator = ListenerIterator.class$("org.netbeans.modules.web.dd.wizards.ListenerIterator")) : class$org$netbeans$modules$web$dd$wizards$ListenerIterator), (String)"TXT_cannotFindWebModule"), "listener");
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            }
        }
        if ((open = (OpenCookie)result.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = ListenerIterator.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie)) != null) {
            open.open();
        }
        return Collections.singleton(result);
    }

    public void initialize(TemplateWizard wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        int i = 0;
        while (i < this.panels.length) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (c instanceof JComponent) {
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
            }
            ++i;
        }
    }

    public void uninitialize(TemplateWizard wiz) {
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ListenerIterator == null ? (class$org$netbeans$modules$web$dd$wizards$ListenerIterator = ListenerIterator.class$("org.netbeans.modules.web.dd.wizards.ListenerIterator")) : class$org$netbeans$modules$web$dd$wizards$ListenerIterator), (String)"TITLE_x_of_y", (Object)new Integer(this.index + 1), (Object)new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    private WebContextObject findWebModule(FileObject fo) {
        FileObject webModuleFO = ContextUtil.findContextRoot(fo);
        if (webModuleFO != null) {
            DataObject rootDO = null;
            try {
                rootDO = DataObject.find((FileObject)webModuleFO);
            }
            catch (DataObjectNotFoundException e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
            }
            if (rootDO instanceof WebContextObject) {
                return (WebContextObject)rootDO;
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

