/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.dd.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.web.dd.model.Servlet;
import org.netbeans.modules.web.dd.model.ServletMapping;
import org.openide.WizardDescriptor;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ServletPanel
implements WizardDescriptor.Panel {
    private ServletVisualPanel component;
    private transient boolean inited = false;
    private final Set listeners = new HashSet(1);

    public Component getComponent() {
        if (this.component == null) {
            this.component = new ServletVisualPanel();
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("jsp_create");
    }

    public boolean isValid() {
        return this.component.isOK();
    }

    Servlet getServlet(TemplateWizard wiz) {
        if (!this.inited) {
            this.initWizard(wiz);
        }
        return this.component.getServlet();
    }

    ServletMapping getMapping(TemplateWizard wiz) {
        if (!this.inited) {
            this.initWizard(wiz);
        }
        return this.component.getMapping();
    }

    private void initWizard(TemplateWizard w) {
        this.inited = true;
        String fullName = null;
        try {
            fullName = w.getTargetFolder().getPrimaryFile().getPackageName('.');
        }
        catch (IOException e) {
            // empty catch block
        }
        String targetName = w.getTargetName();
        if (targetName == null) {
            targetName = w.getTemplate().getPrimaryFile().getName();
        }
        fullName = (fullName == null || fullName.length() == 0 ? "" : fullName + ".") + targetName;
        ((ServletVisualPanel)this.getComponent()).updateState(targetName, fullName);
    }

    public final void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    public final void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    protected final void fireChangeEvent() {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }

    public void readSettings(Object settings) {
        if (settings instanceof TemplateWizard) {
            this.initWizard((TemplateWizard)settings);
        }
    }

    public void storeSettings(Object settings) {
    }

    private class ServletVisualPanel
    extends JPanel
    implements ItemListener,
    KeyListener {
        private JTextField jTFservletname;
        private JTextField jTFservletdisp;
        private JTextField jTFservletdesc;
        private JTextField jTFservletorder;
        private JTextField jTFmappingname;
        private JTextField jTFmappingurl;
        private JCheckBox jCBservlet;
        private JCheckBox jCBload_on_startup;
        private JCheckBox jCBmapping;
        private JLabel jLservletname;
        private JLabel jLservletdisp;
        private JLabel jLservletdesc;
        private JLabel jLservletorder;
        private JLabel jLmappingname;
        private JLabel jLmappingurl;
        private JPanel jPanel1;
        private JPanel jPanel2;
        static /* synthetic */ Class class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel;

        public ServletVisualPanel() {
            this.initComponents();
            this.setName(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"TITLE_ServletDeploymentWizardPanel"));
        }

        private void updateState(String sName, String fullName) {
            this.jTFservletname.setText(sName);
            this.jTFmappingname.setText(sName);
            this.jTFmappingurl.setText("/servlet/" + fullName);
        }

        private boolean isOK() {
            if (this.jCBservlet.isSelected()) {
                if (this.jTFservletname.getText().length() == 0) {
                    return false;
                }
                if (this.jCBload_on_startup.isSelected()) {
                    try {
                        Integer.valueOf(this.jTFservletorder.getText());
                    }
                    catch (NumberFormatException ex) {
                        return false;
                    }
                }
            }
            return !this.jCBmapping.isSelected() || this.jTFmappingname.getText().length() != 0 && this.jTFmappingurl.getText().length() != 0;
        }

        private Servlet getServlet() {
            if (this.jCBservlet.isSelected()) {
                Servlet s = new Servlet();
                s.setServletName(this.jTFservletname.getText());
                s.setDescription(this.jTFservletdesc.getText());
                s.setDisplayName(this.jTFservletdisp.getText());
                if (this.jCBload_on_startup.isSelected()) {
                    try {
                        s.setLoadOnStartup(Integer.valueOf(this.jTFservletorder.getText()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return s;
            }
            return null;
        }

        private ServletMapping getMapping() {
            if (this.jCBmapping.isSelected()) {
                ServletMapping m = new ServletMapping();
                m.setServletName(this.jTFmappingname.getText());
                m.setUrlPattern(this.jTFmappingurl.getText());
                return m;
            }
            return null;
        }

        private void initComponents() {
            GridBagConstraints gridBagConstraints;
            this.jTFservletname = new JTextField(25);
            this.jTFservletdisp = new JTextField(30);
            this.jTFservletdesc = new JTextField(30);
            this.jTFservletorder = new JTextField(3);
            this.jTFmappingname = new JTextField(25);
            this.jTFmappingurl = new JTextField(30);
            this.jCBservlet = new JCheckBox(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_add_servlet"), true);
            this.jCBservlet.setMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_add_servlet_Mnem").charAt(0));
            this.jCBload_on_startup = new JCheckBox(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_load_on_startup"));
            this.jCBload_on_startup.setMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_load_on_startup_Mnem").charAt(0));
            this.jCBmapping = new JCheckBox(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_add_mapping"), true);
            this.jCBmapping.setMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_add_mapping_Mnem").charAt(0));
            this.jLservletname = new JLabel(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_servlet_name"));
            this.jLservletname.setLabelFor(this.jTFservletname);
            this.jLservletname.setDisplayedMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_servlet_name_Mnem").charAt(0));
            this.jLservletdisp = new JLabel(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_servlet_display_name"));
            this.jLservletdisp.setLabelFor(this.jTFservletdisp);
            this.jLservletdisp.setDisplayedMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_servlet_display_name_Mnem").charAt(0));
            this.jLservletdesc = new JLabel(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_servlet_description"));
            this.jLservletdesc.setLabelFor(this.jTFservletdesc);
            this.jLservletdesc.setDisplayedMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_servlet_description_Mnem").charAt(0));
            this.jLservletorder = new JLabel(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_servlet_order"));
            this.jLservletorder.setLabelFor(this.jTFservletorder);
            this.jLservletorder.setDisplayedMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_servlet_order_Mnem").charAt(0));
            this.jLmappingname = new JLabel(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_mapping_name"));
            this.jLmappingname.setLabelFor(this.jTFmappingname);
            this.jLmappingname.setDisplayedMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_mapping_name_Mnem").charAt(0));
            this.jLmappingurl = new JLabel(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_mapping_url"));
            this.jLmappingurl.setLabelFor(this.jTFmappingurl);
            this.jLmappingurl.setDisplayedMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel), (String)"LBL_mapping_url_Mnem").charAt(0));
            ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel == null ? (class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel = ServletVisualPanel.class$("org.netbeans.modules.web.dd.wizards.ServletPanel$ServletVisualPanel")) : class$org$netbeans$modules$web$dd$wizards$ServletPanel$ServletVisualPanel));
            this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_servlet_deployment"));
            this.jTFservletname.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_servlet_name"));
            this.jTFservletdisp.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_servlet_disp"));
            this.jTFservletdesc.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_servlet_desc"));
            this.jTFservletorder.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_servlet_order"));
            this.jTFmappingname.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_mapping_name"));
            this.jTFmappingurl.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_mapping_url"));
            this.jCBservlet.addItemListener(this);
            this.jCBload_on_startup.addItemListener(this);
            this.jCBmapping.addItemListener(this);
            this.jTFmappingname.setEnabled(false);
            this.jTFservletname.addKeyListener(this);
            this.jTFservletorder.addKeyListener(this);
            this.jTFservletorder.setEnabled(false);
            this.jTFmappingurl.addKeyListener(this);
            JComponent[] comps = new JComponent[]{this.jCBservlet, this.jTFservletname, this.jTFservletdisp, this.jTFservletdesc, this.jTFservletorder, this.jTFmappingname, this.jTFmappingurl, this.jCBload_on_startup, this.jCBmapping, this.jLservletname, this.jLservletdisp, this.jLservletdesc, this.jLservletorder, this.jLmappingname, this.jLmappingurl};
            int[][] layout = new int[][]{{0, 0, 2, 1, 2}, {1, 1, 1, 1, 2}, {1, 2, 1, 1, 2}, {1, 3, 1, 1, 2}, {1, 5, 1, 1, 2}, {1, 7, 1, 1, 2}, {1, 8, 1, 1, 2}, {0, 4, 1, 1, 2}, {0, 6, 2, 1, 2}, {0, 1, 1, 1, 0}, {0, 2, 1, 1, 0}, {0, 3, 1, 1, 0}, {0, 5, 1, 1, 0}, {0, 7, 1, 1, 0}, {0, 8, 1, 1, 0}};
            Insets[] insets = new Insets[]{new Insets(0, 0, 5, 0), new Insets(0, 0, 5, 0), new Insets(0, 0, 5, 0), new Insets(0, 0, 5, 0), new Insets(0, 0, 12, 0), new Insets(0, 0, 5, 0), new Insets(0, 0, 12, 0), new Insets(0, 12, 5, 0), new Insets(0, 12, 5, 0), new Insets(0, 12, 5, 0), new Insets(0, 12, 5, 0), new Insets(0, 12, 5, 0), new Insets(0, 24, 12, 0), new Insets(0, 24, 5, 0), new Insets(0, 24, 12, 0)};
            this.setLayout(new GridBagLayout());
            this.setPreferredSize(new Dimension(450, 250));
            int i = 0;
            while (i < comps.length) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = layout[i][0];
                gridBagConstraints.gridy = layout[i][1];
                gridBagConstraints.gridwidth = layout[i][2];
                gridBagConstraints.gridheight = layout[i][3];
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = layout[i][4];
                gridBagConstraints.insets = insets[i];
                this.add((Component)comps[i], gridBagConstraints);
                ++i;
            }
            this.jPanel1 = new JPanel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 9;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)this.jPanel1, gridBagConstraints);
            this.jPanel2 = new JPanel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 3;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.jPanel2, gridBagConstraints);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            boolean enabled;
            boolean bl = enabled = itemEvent.getStateChange() == 1;
            if (itemEvent.getSource() == this.jCBservlet) {
                this.jTFservletname.setEnabled(enabled);
                this.jTFservletdisp.setEnabled(enabled);
                this.jTFservletdesc.setEnabled(enabled);
                this.jCBload_on_startup.setEnabled(enabled);
                this.jTFservletorder.setEnabled(enabled && this.jCBload_on_startup.isSelected());
                this.jCBmapping.setEnabled(enabled);
                this.jTFmappingurl.setEnabled(enabled && this.jCBmapping.isSelected());
            } else if (itemEvent.getSource() == this.jCBmapping) {
                this.jTFmappingurl.setEnabled(enabled);
            } else if (itemEvent.getSource() == this.jCBload_on_startup) {
                this.jTFservletorder.setEnabled(enabled);
            }
            ServletPanel.this.fireChangeEvent();
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getSource() == this.jTFservletname) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ ServletVisualPanel this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        ServletVisualPanel.access$500(this.this$1).setText(ServletVisualPanel.access$400(this.this$1).getText());
                        ServletVisualPanel.access$600(this.this$1).fireChangeEvent();
                    }
                });
                return;
            }
            if (keyEvent.getSource() == this.jTFservletorder || keyEvent.getSource() == this.jTFmappingurl) {
                ServletPanel.this.fireChangeEvent();
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static /* synthetic */ JTextField access$400(ServletVisualPanel x0) {
            return x0.jTFservletname;
        }

        static /* synthetic */ JTextField access$500(ServletVisualPanel x0) {
            return x0.jTFmappingname;
        }

        static /* synthetic */ ServletPanel access$600(ServletVisualPanel x0) {
            return x0.ServletPanel.this;
        }
    }
}

