/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.war;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.netbeans.modules.web.context.WebContextLoader;
import org.netbeans.modules.web.war.WarPackagerSupport;
import org.netbeans.modules.web.war.WarPackagingProperties;
import org.netbeans.modules.web.war.packager.FileWarEntry;
import org.netbeans.modules.web.war.packager.WarContent;
import org.netbeans.modules.web.war.packager.WarException;
import org.netbeans.modules.web.war.packager.WarPackager;
import org.netbeans.modules.web.war.packager.WarPackagerFactory;
import org.openide.ErrorManager;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Sheet;

public abstract class WarDataModel {
    WarPackagingProperties warPackagingProps;

    public abstract FileObject getWarFileObject();

    public abstract FileObject getWarContentFileObject();

    public abstract Collection getWarFileContents() throws WarException;

    protected Collection getWarFileContentsFromWarFile() throws WarException {
        Vector<FileWarEntry> warEntries = new Vector<FileWarEntry>();
        FileObject warFO = this.getWarFileObject();
        if (warFO == null) {
            return warEntries;
        }
        Collection fileEntries = this.getZipFileEntries(warFO);
        Iterator itr = fileEntries.iterator();
        while (itr.hasNext()) {
            File entry = new File((String)itr.next());
            warEntries.add(new FileWarEntry(entry));
        }
        return warEntries;
    }

    protected void registerArchivePropertyChangeListener() {
        this.warPackagingProps.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                WarPackagerSupport.getErrorManager().log("Property Changed : " + evt.getPropertyName());
                WarDataModel.this.savePackagingProperties();
            }
        });
    }

    public Sheet.Set createArchivePropertySet() {
        this.loadPackagingProperties();
        Sheet.Set propSet = this.warPackagingProps.createProperties();
        this.registerArchivePropertyChangeListener();
        return propSet;
    }

    public void loadPackagingProperties() {
        this.warPackagingProps = new WarPackagingProperties(this);
        FileObject warContentFO = this.getWarContentFileObject();
        if (warContentFO == null) {
            return;
        }
        try {
            this.warPackagingProps.loadPackagingProps(warContentFO);
        }
        catch (Exception ex) {
            WarPackagerSupport.getErrorManager().notify(0, (Throwable)ex);
        }
    }

    public void savePackagingProperties() {
        FileObject warContentFO = this.getWarContentFileObject();
        if (warContentFO == null) {
            return;
        }
        try {
            this.warPackagingProps.savePackagingProps(warContentFO);
        }
        catch (Exception ex) {
            WarPackagerSupport.getErrorManager().notify(0, (Throwable)ex);
        }
    }

    public boolean isValidWarFile() {
        FileObject warFO = this.getWarFileObject();
        if (warFO == null) {
            return false;
        }
        try {
            Collection fileEntries = this.getZipFileEntries(warFO);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public FileObject getAssociatedWebModule() {
        try {
            FileObject warContentFO = this.getWarContentFileObject();
            if (warContentFO == null) {
                return null;
            }
            FileObject root = warContentFO.getFileSystem().getRoot();
            if (warContentFO.getParent().getPackageName('/').equalsIgnoreCase("WEB-INF") && WebContextLoader.isWebApplication(warContentFO.getFileSystem())) {
                return root;
            }
            return null;
        }
        catch (Exception ex) {
            WarPackagerSupport.getErrorManager().notify(1, (Throwable)ex);
            return null;
        }
    }

    public WarContent prepareWarContent() {
        if (this.getWarContentFileObject() == null) {
            return null;
        }
        try {
            FileObject webModuleRoot = this.getAssociatedWebModule();
            WarContent warContent = new WarContent();
            this.warPackagingProps.savePackagingProps(warContent);
            if (webModuleRoot != null) {
                warContent.addWebModule(webModuleRoot);
            }
            return warContent;
        }
        catch (Exception ex) {
            WarPackagerSupport.getErrorManager().notify(0, (Throwable)ex);
            return null;
        }
    }

    private void packageWarContents(File warFile, WarContent warContent) throws WarException {
        WarPackager warPackager = WarPackagerFactory.getWarPackager();
        warPackager.setWarContent(warContent);
        warPackager.setWarFile(warFile);
        warPackager.generateWarFile();
    }

    public void packageWarContents(File warFile) throws WarException {
        WarContent warContent = this.prepareWarContent();
        this.packageWarContents(warFile, warContent);
    }

    public FileObject generateWarFile() throws WarException {
        FileObject warFO = this.getWarFileObject();
        if (warFO == null) {
            return null;
        }
        File warFile = FileUtil.toFile((FileObject)warFO);
        this.packageWarContents(warFile);
        return warFO;
    }

    public Collection getZipFileEntries(FileObject warFO) throws WarException {
        return this.getZipFileEntries(NbClassPath.toFile((FileObject)warFO));
    }

    public Collection getZipFileEntries(File warFile) throws WarException {
        Vector<String> warEntries = new Vector<String>();
        try {
            ZipFile warZipFile = new ZipFile(warFile);
            Enumeration<? extends ZipEntry> enumeration = warZipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry ze = enumeration.nextElement();
                if (ze.isDirectory()) continue;
                warEntries.add(ze.getName());
            }
            try {
                warZipFile.close();
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify(1, (Throwable)ioe);
            }
            return warEntries;
        }
        catch (Exception ex) {
            throw new WarException(ex);
        }
    }
}

