/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.war;

import java.awt.Image;
import org.netbeans.modules.web.war.WarDataObject;
import org.netbeans.modules.web.war.WarPackagerSupport;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class WarNode
extends DataNode {
    static final String WAR_ICON_BASE = "org/netbeans/modules/web/war/resources/war";
    static final String WARCONTENT_ICON_BASE = "org/netbeans/modules/web/war/resources/warContent";
    static final String WARPLUS_ICON_BASE = "org/netbeans/modules/web/war/resources/warPlus";
    static final String ERR_WAR_ICON_BASE = "org/netbeans/modules/web/war/resources/ErrWar";
    static final String ERR_WARCONTENT_ICON_BASE = "org/netbeans/modules/web/war/resources/ErrWarContent";
    static final String ERR_WARPLUS_ICON_BASE = "org/netbeans/modules/web/war/resources/ErrWarPlus";
    static final String ERR_BADGE_ICON_BASE = "org/netbeans/modules/web/war/resources/errorbadge";
    static Image errorIcon = null;
    static String errorWarHint = null;
    static String validWarHint = null;
    static /* synthetic */ Class class$org$netbeans$modules$web$war$WarNode;
    static /* synthetic */ Class class$org$netbeans$modules$web$war$actions$ViewContentWarAction;

    public WarNode(DataObject dataObject) {
        this(dataObject, Children.LEAF);
    }

    public WarNode(DataObject dataObject, Children children) {
        super(dataObject, children);
        String iconBase = WAR_ICON_BASE;
        WarDataObject warDataObject = (WarDataObject)dataObject;
        if (warDataObject.isWarContentOnly()) {
            iconBase = WARCONTENT_ICON_BASE;
        } else if (warDataObject.isWarOnly()) {
            iconBase = WAR_ICON_BASE;
            if (warDataObject.getWarDataModel().isValidWarFile()) {
                iconBase = ERR_WAR_ICON_BASE;
            }
        } else {
            iconBase = WARPLUS_ICON_BASE;
        }
        validWarHint = NbBundle.getMessage((Class)(class$org$netbeans$modules$web$war$WarNode == null ? (class$org$netbeans$modules$web$war$WarNode = WarNode.class$("org.netbeans.modules.web.war.WarNode")) : class$org$netbeans$modules$web$war$WarNode), (String)"HINT_WarNode");
        errorWarHint = NbBundle.getMessage((Class)(class$org$netbeans$modules$web$war$WarNode == null ? (class$org$netbeans$modules$web$war$WarNode = WarNode.class$("org.netbeans.modules.web.war.WarNode")) : class$org$netbeans$modules$web$war$WarNode), (String)"HINT_InvalidWarNode");
        this.setIconBase(iconBase);
        this.setDefaultAction(SystemAction.get((Class)(class$org$netbeans$modules$web$war$actions$ViewContentWarAction == null ? (class$org$netbeans$modules$web$war$actions$ViewContentWarAction = WarNode.class$("org.netbeans.modules.web.war.actions.ViewContentWarAction")) : class$org$netbeans$modules$web$war$actions$ViewContentWarAction)));
        FileObject warFO = dataObject.getPrimaryFile();
        warFO.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

            public void fileChanged(FileEvent fe) {
                WarNode.this.validateWarNode();
            }
        });
    }

    private void validateWarNode() {
        this.fireIconChange();
    }

    public Image getIcon(int type) {
        Image mainIcon = super.getIcon(type);
        if (mainIcon == null) {
            return mainIcon;
        }
        try {
            if (!((WarDataObject)this.getDataObject()).getWarDataModel().isValidWarFile()) {
                if (errorIcon == null) {
                    String imgPath = "org/netbeans/modules/web/war/resources/errorbadge.gif";
                    Image badgeIcon = Utilities.loadImage((String)imgPath);
                    if (badgeIcon == null) {
                        throw new NullPointerException();
                    }
                    errorIcon = Utilities.mergeImages((Image)mainIcon, (Image)badgeIcon, (int)8, (int)8);
                }
                this.setShortDescription(errorWarHint);
                return errorIcon;
            }
        }
        catch (Exception ex) {
            WarPackagerSupport.getErrorManager().notify(1, (Throwable)ex);
        }
        this.setShortDescription(validWarHint);
        return mainIcon;
    }

    protected SystemAction[] createActions() {
        return ((WarDataObject)this.getDataObject()).createActions();
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set ps = ((WarDataObject)this.getDataObject()).createProperties();
        if (ps != null) {
            sheet.put(ps);
        }
        return sheet;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("concepts_war");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

