/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.war;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.netbeans.modules.j2ee.server.Server;
import org.netbeans.modules.j2ee.server.datamodel.FileArchiveResource;
import org.netbeans.modules.j2ee.server.datamodel.J2eeAppStandardData;
import org.netbeans.modules.web.context.PackageWar;
import org.netbeans.modules.web.context.WebContextObject;
import org.netbeans.modules.web.war.WebContextWarModel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class WarPackagerSupport
extends PackageWar {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.web.war");
    WebContextWarModel warModel;
    File warFile;

    public static ErrorManager getErrorManager() {
        return err;
    }

    public WarPackagerSupport() {
        this.warModel = null;
        this.warFile = null;
    }

    WarPackagerSupport(WebContextObject w, Server s, J2eeAppStandardData appData) {
        this(w, s, appData, null);
    }

    WarPackagerSupport(WebContextObject w, Server s, J2eeAppStandardData appData, File warFile) {
        this.warModel = new WebContextWarModel(w, s, appData);
        this.warFile = warFile;
    }

    public FileArchiveResource getResource(WebContextObject wco, Server s, J2eeAppStandardData appData) {
        return this.getResource(wco, s, appData, null);
    }

    public FileArchiveResource getResource(WebContextObject wco, Server s, J2eeAppStandardData appData, File warFile) {
        if (wco == null) {
            return null;
        }
        return new WarPackagerSupport(wco, s, appData, warFile);
    }

    public File getFile() {
        try {
            if (this.warModel == null) {
                return null;
            }
            PackageWar.doCompile(this.warModel.webContext);
            if (this.warFile != null) {
                this.warModel.packageWarContents(this.warFile);
                return this.warFile;
            }
            FileObject warFO = this.warModel.generateWarFile();
            if (warFO == null) {
                return null;
            }
            return FileUtil.toFile((FileObject)warFO);
        }
        catch (Exception e) {
            try {
                if (this.warFile != null && !this.warFile.getName().equals("web.war")) {
                    this.warFile.delete();
                }
            }
            catch (Exception ex) {
                err.notify(1, (Throwable)ex);
            }
            ErrorManager.getDefault().notify(4096, (Throwable)e);
            return null;
        }
    }

    public InputStream getJarFile() {
        try {
            if (this.warModel == null) {
                return null;
            }
            PackageWar.doCompile(this.warModel.webContext);
            if (this.warFile != null) {
                this.warModel.packageWarContents(this.warFile);
                return new FileInputStream(this.warFile);
            }
            FileObject warFO = this.warModel.generateWarFile();
            if (warFO == null) {
                return null;
            }
            return warFO.getInputStream();
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return null;
        }
    }
}

