/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.war;

import java.util.Collection;
import org.netbeans.modules.j2ee.server.Server;
import org.netbeans.modules.j2ee.server.ServerInstance;
import org.netbeans.modules.j2ee.server.datamodel.J2eeAppStandardData;
import org.netbeans.modules.web.context.WebContextLoader;
import org.netbeans.modules.web.context.WebContextObject;
import org.netbeans.modules.web.context.WebInfObject;
import org.netbeans.modules.web.context.packager.WarServerArchiveBuilder;
import org.netbeans.modules.web.war.WarDataModel;
import org.netbeans.modules.web.war.WarPackagerSupport;
import org.netbeans.modules.web.war.packager.WarContent;
import org.netbeans.modules.web.war.packager.WarException;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Sheet;

public class WebContextWarModel
extends WarDataModel {
    WebContextObject webContext;
    Server server;
    J2eeAppStandardData appData;

    public WebContextWarModel(WebInfObject webInfObject) {
        WebContextObject wco = null;
        try {
            wco = WebContextLoader.findContext(webInfObject.getPrimaryFile().getFileSystem());
        }
        catch (Exception ex) {
            WarPackagerSupport.getErrorManager().notify(0, (Throwable)ex);
        }
        this.initModel(wco, null, null);
    }

    public WebContextWarModel(WebContextObject webContext) {
        this.initModel(webContext, null, null);
    }

    public WebContextWarModel(WebContextObject webContext, Server server, J2eeAppStandardData appData) {
        this.initModel(webContext, server, appData);
    }

    private void initModel(WebContextObject webContext, Server server, J2eeAppStandardData appData) {
        this.webContext = webContext;
        this.server = server;
        this.appData = appData;
        this.loadPackagingProperties();
    }

    private FileObject getWebInfFileObject() {
        if (this.webContext == null) {
            return null;
        }
        return this.webContext.getInfObject().getPrimaryFile();
    }

    public FileObject getWarFileObject() {
        try {
            FileObject webInfFO = this.getWebInfFileObject();
            FileObject warFO = webInfFO.getFileObject("web", "war");
            if (warFO == null) {
                warFO = webInfFO.createData("web", "war");
            }
            return warFO;
        }
        catch (Exception ex) {
            WarPackagerSupport.getErrorManager().notify(0, (Throwable)ex);
            return null;
        }
    }

    public FileObject getWarContentFileObject() {
        FileObject warContentFO = null;
        try {
            FileObject webInfFO = this.getWebInfFileObject();
            warContentFO = WarContent.findWarContentFile(webInfFO, "web", true);
        }
        catch (Exception ex) {
            WarPackagerSupport.getErrorManager().notify(0, (Throwable)ex);
        }
        return warContentFO;
    }

    public Sheet.Set createArchivePropertySet() {
        return super.createArchivePropertySet();
    }

    public WarContent prepareWarContent() {
        WarContent warContent = super.prepareWarContent();
        if (warContent != null) {
            try {
                ServerInstance si;
                WarServerArchiveBuilder serverArchiveBuilder = null;
                if (this.server == null && (si = this.webContext.getServerInstance()) != null) {
                    this.server = si.getServer();
                }
                serverArchiveBuilder = new WarServerArchiveBuilder(this.webContext, this.server, this.appData);
                warContent.setServerArchiveBuilder(serverArchiveBuilder);
            }
            catch (Exception ex) {
                WarPackagerSupport.getErrorManager().notify(0, (Throwable)ex);
            }
        }
        return warContent;
    }

    public Collection getWarFileContents() throws WarException {
        this.generateWarFile();
        return this.getWarFileContentsFromWarFile();
    }
}

