/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.war.actions;

import java.awt.Component;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.web.context.WebContextLoader;
import org.netbeans.modules.web.context.WebContextObject;
import org.netbeans.modules.web.context.WebInfObject;
import org.netbeans.modules.web.war.WarDataObject;
import org.netbeans.modules.web.war.WebContextWarModel;
import org.netbeans.modules.web.war.actions.UnpackWarAction;
import org.netbeans.modules.web.war.packager.WarException;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;
import org.openide.windows.WindowManager;

public class ExportWarAction
extends NodeAction {
    private static File lastWarFileFolder = null;
    private static final FileFilter WARFILTER = new WarFileFilter();
    static /* synthetic */ Class class$org$netbeans$modules$web$war$actions$ExportWarAction;
    static /* synthetic */ Class class$org$netbeans$modules$web$war$WarDataObject;
    static /* synthetic */ Class class$org$netbeans$modules$web$context$WebInfObject;

    public String getName() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$web$war$actions$ExportWarAction == null ? (class$org$netbeans$modules$web$war$actions$ExportWarAction = ExportWarAction.class$("org.netbeans.modules.web.war.actions.ExportWarAction")) : class$org$netbeans$modules$web$war$actions$ExportWarAction), (String)"CTL_ExportWarAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$web$war$actions$ExportWarAction == null ? (class$org$netbeans$modules$web$war$actions$ExportWarAction = ExportWarAction.class$("org.netbeans.modules.web.war.actions.ExportWarAction")) : class$org$netbeans$modules$web$war$actions$ExportWarAction);
    }

    protected String iconResource() {
        return "org/netbeans/modules/web/war/resources/war.gif";
    }

    public void performAction(Node[] nodes) {
        try {
            File warFile = this.getTargetWarFile();
            if (warFile == null) {
                return;
            }
            WarDataObject war = (WarDataObject)nodes[0].getCookie(class$org$netbeans$modules$web$war$WarDataObject == null ? (class$org$netbeans$modules$web$war$WarDataObject = ExportWarAction.class$("org.netbeans.modules.web.war.WarDataObject")) : class$org$netbeans$modules$web$war$WarDataObject);
            if (war != null) {
                this.exportAsWarFile(war, warFile);
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$war$actions$ExportWarAction == null ? (class$org$netbeans$modules$web$war$actions$ExportWarAction = ExportWarAction.class$("org.netbeans.modules.web.war.actions.ExportWarAction")) : class$org$netbeans$modules$web$war$actions$ExportWarAction), (String)"Msg_WARFileCreated"));
            } else {
                WebInfObject webInfObject = (WebInfObject)nodes[0].getCookie(class$org$netbeans$modules$web$context$WebInfObject == null ? (class$org$netbeans$modules$web$context$WebInfObject = ExportWarAction.class$("org.netbeans.modules.web.context.WebInfObject")) : class$org$netbeans$modules$web$context$WebInfObject);
                if (webInfObject != null) {
                    this.exportAsWarFile(webInfObject, warFile);
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$war$actions$ExportWarAction == null ? (class$org$netbeans$modules$web$war$actions$ExportWarAction = ExportWarAction.class$("org.netbeans.modules.web.war.actions.ExportWarAction")) : class$org$netbeans$modules$web$war$actions$ExportWarAction), (String)"Msg_WARFileCreated"));
                }
            }
            return;
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
            return;
        }
    }

    public boolean enable(Node[] nodes) {
        if (nodes.length != 1) {
            return false;
        }
        WarDataObject dobj = (WarDataObject)nodes[0].getCookie(class$org$netbeans$modules$web$war$WarDataObject == null ? (class$org$netbeans$modules$web$war$WarDataObject = ExportWarAction.class$("org.netbeans.modules.web.war.WarDataObject")) : class$org$netbeans$modules$web$war$WarDataObject);
        if (dobj != null) {
            return !dobj.isWarOnly();
        }
        return nodes[0].getCookie(class$org$netbeans$modules$web$context$WebInfObject == null ? (class$org$netbeans$modules$web$context$WebInfObject = ExportWarAction.class$("org.netbeans.modules.web.context.WebInfObject")) : class$org$netbeans$modules$web$context$WebInfObject) != null;
    }

    void exportAsWarFile(WebInfObject webInfObject, File warFile) throws WarException {
        if (warFile == null) {
            return;
        }
        try {
            WebContextObject wco = null;
            wco = WebContextLoader.findContext(webInfObject.getPrimaryFile().getFileSystem());
            WebContextWarModel warDataModel = new WebContextWarModel(wco);
            warDataModel.packageWarContents(warFile);
        }
        catch (Exception ex) {
            throw new WarException(ex);
        }
    }

    void exportAsWarFile(WarDataObject warDO, File warFile) throws WarException {
        if (warFile == null) {
            return;
        }
        warDO.getWarDataModel().packageWarContents(warFile);
    }

    File getTargetWarFile() {
        File warFile = null;
        UnpackWarAction.FSChooser chooser = new UnpackWarAction.FSChooser();
        HelpCtx.setHelpIDString((JComponent)chooser, (String)this.getHelpCtx().getHelpID());
        chooser.setDialogTitle(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$war$actions$ExportWarAction == null ? (class$org$netbeans$modules$web$war$actions$ExportWarAction = ExportWarAction.class$("org.netbeans.modules.web.war.actions.ExportWarAction")) : class$org$netbeans$modules$web$war$actions$ExportWarAction), (String)"CTL_ExportWarDialogTitle"));
        chooser.setFileFilter(WARFILTER);
        if (lastWarFileFolder != null) {
            chooser.setCurrentDirectory(lastWarFileFolder);
        }
        if (Utilities.showJFileChooser((JFileChooser)chooser, (Component)WindowManager.getDefault().getMainWindow(), (String)NbBundle.getMessage((Class)(class$org$netbeans$modules$web$war$actions$ExportWarAction == null ? (class$org$netbeans$modules$web$war$actions$ExportWarAction = ExportWarAction.class$("org.netbeans.modules.web.war.actions.ExportWarAction")) : class$org$netbeans$modules$web$war$actions$ExportWarAction), (String)"CTL_ExportWarOk")) == 0) {
            warFile = chooser.getSelectedFile();
        }
        chooser.dispose();
        lastWarFileFolder = chooser.getCurrentDirectory();
        if (warFile == null) {
            return null;
        }
        if (warFile.exists() && warFile.isDirectory()) {
            return null;
        }
        return ExportWarAction.ensureExtension(warFile, "war");
    }

    private static File ensureExtension(File f, String e) {
        String ext;
        String n = f.getName();
        if (n.endsWith(ext = "." + e)) {
            return f;
        }
        int l = n.lastIndexOf(".");
        if (l >= 0) {
            n = n.substring(0, l);
        }
        n = n + e;
        return new File(f.getParentFile(), n);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class WarFileFilter
    extends FileFilter {
        static /* synthetic */ Class class$org$netbeans$modules$web$war$actions$ExportWarAction;

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith("war");
        }

        public String getDescription() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$web$war$actions$ExportWarAction == null ? (class$org$netbeans$modules$web$war$actions$ExportWarAction = WarFileFilter.class$("org.netbeans.modules.web.war.actions.ExportWarAction")) : class$org$netbeans$modules$web$war$actions$ExportWarAction), (String)"CTL_WarArchivesMask");
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

