/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.war.packager;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.netbeans.modules.web.war.packager.WarEntry;

public abstract class AbstractWarEntry
implements WarEntry,
Serializable {
    protected String pathName;
    protected String fileName;
    protected String fileExt;

    public AbstractWarEntry() {
        this("", "", "");
    }

    public AbstractWarEntry(String pathName, String fileName, String fileExt) {
        this.pathName = pathName;
        this.fileName = fileName;
        this.fileExt = fileExt;
    }

    public String getPathName() {
        return this.pathName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileExt() {
        return this.fileExt;
    }

    public String getFullyQualifiedName() {
        String fullName = this.pathName;
        fullName = this.pathName.length() > 0 ? fullName + "/" + this.fileName : this.fileName;
        if (this.fileExt.length() > 0) {
            fullName = fullName + "." + this.fileExt;
        }
        return fullName;
    }

    protected void initWithFile(File file) {
        if (file == null) {
            return;
        }
        this.pathName = file.getParent();
        if (this.pathName == null) {
            this.pathName = "";
        }
        this.pathName = this.pathName.replace(File.separatorChar, '/');
        if (this.pathName.length() > 2 && this.pathName.charAt(1) == ':') {
            this.pathName = this.pathName.substring(2);
        }
        if (this.pathName.length() > 1 && this.pathName.charAt(0) == '/') {
            this.pathName = this.pathName.substring(1);
        }
        String name = file.getName();
        this.fileName = "";
        this.fileExt = "";
        if (name == null) {
            return;
        }
        int idx = name.lastIndexOf(".");
        if (idx > 0) {
            this.fileName = name.substring(0, idx);
            this.fileExt = name.substring(idx + 1);
        } else {
            this.fileName = name;
        }
    }

    protected void initWithTargetNameAndPrefix(String name, String prefix) {
        if (name == null && prefix == null) {
            return;
        }
        if (name == null && prefix != null) {
            this.pathName = prefix + "/" + this.pathName;
            return;
        }
        String fullName = name;
        if (prefix != null) {
            fullName = prefix + "/" + name;
        }
        File file = new File(fullName);
        this.initWithFile(file);
    }

    public String getName() {
        return this.getFullyQualifiedName();
    }

    public int hashCode() {
        return this.getFullyQualifiedName().hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof WarEntry) {
            WarEntry otherEntry = (WarEntry)other;
            String thisF = this.getFullyQualifiedName();
            String otherF = otherEntry.getFullyQualifiedName();
            return thisF.equals(otherF);
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public abstract InputStream createInputStream() throws IOException;
}

