/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.war.packager;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.netbeans.modules.web.war.packager.AbstractWarEntry;

public class FileWarEntry
extends AbstractWarEntry {
    File file;

    public FileWarEntry(File file) {
        this(file, null, null);
    }

    public FileWarEntry(File file, String name) {
        this(file, name, null);
    }

    public FileWarEntry(File file, String name, String prefix) {
        this.file = file;
        super.initWithFile(file);
        super.initWithTargetNameAndPrefix(name, prefix);
    }

    public File getFile() {
        return this.file;
    }

    public InputStream createInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public long getSize() {
        try {
            return new RandomAccessFile(this.file, "r").length();
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public boolean equals(Object other) {
        String otherF;
        if (!(other instanceof FileWarEntry)) {
            return super.equals(other);
        }
        FileWarEntry otherEntry = (FileWarEntry)other;
        String thisF = this.file.getAbsolutePath();
        if (thisF.equals(otherF = otherEntry.file.getAbsolutePath())) {
            return this.getName().equals(otherEntry.getName());
        }
        return false;
    }
}

