/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.war.packager;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.netbeans.modules.jarpackager.ContentMemberList;
import org.netbeans.modules.jarpackager.FileObjectFilter;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.api.ArchiveBuilder;
import org.netbeans.modules.jarpackager.options.JarPackagerOption;
import org.netbeans.modules.web.war.WarPackagerSupport;
import org.netbeans.modules.web.war.packager.WarEntry;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.io.NbObjectInputStream;
import org.openide.util.io.NbObjectOutputStream;

public class WarContent
extends JarContent {
    public static final String WAR_EXT = "war";
    public static final String WARCONTENT_EXT = "warContent";
    public static final String WEBINF_PATH = "WEB-INF";
    public static final String CLASSES_PATH = "WEB-INF/classes";
    public static final String LIB_PATH = "WEB-INF/lib";
    public static final String WEBXML_NAME = "web.xml";
    public static final String WEB_NAME = "web";
    public static final FileObjectFilter WAR_DEFAULT_FILTER = new WarAllButJavaFilter();
    public static final FileObjectFilter WARCONTENT_FILTER = new WarContentFilter();
    FileObjectFilter myWarFilter;
    Collection extraFiles = new ContentMemberList();
    transient HashMap warEntries = new HashMap();
    transient ArchiveBuilder serverArchiveBuilder = null;

    public WarContent() {
        this(WAR_DEFAULT_FILTER);
    }

    public WarContent(FileObjectFilter filter) {
        super(filter);
    }

    protected void setMyWarFilter(FileObjectFilter myWarFilter) {
        this.myWarFilter = myWarFilter;
    }

    protected FileObjectFilter getMyWarFilter() {
        return this.myWarFilter;
    }

    public void setExtraFiles(Collection extraFiles) {
        this.extraFiles = extraFiles;
    }

    public Collection getExtraFiles() {
        return this.extraFiles;
    }

    public void addWarEntry(WarEntry extraEntry) {
        String name = extraEntry.getName();
        if (!this.warEntries.containsKey(name)) {
            this.warEntries.put(name, extraEntry);
        }
    }

    public void addWarEntries(Collection extraEntries) {
        Iterator itr = extraEntries.iterator();
        while (itr.hasNext()) {
            this.addWarEntry((WarEntry)itr.next());
        }
    }

    public Collection getWarEntries() {
        Collection entries = this.warEntries.values();
        if (entries == null) {
            entries = new Vector();
        }
        return entries;
    }

    public void clearWarEntries() {
        this.warEntries = new HashMap();
    }

    public void setServerArchiveBuilder(ArchiveBuilder archiveBuilder) {
        this.serverArchiveBuilder = archiveBuilder;
    }

    public ArchiveBuilder getServerArchiveBuilder() {
        return this.serverArchiveBuilder;
    }

    public void addWebModule(DataObject webModule) {
        WarPackagerSupport.getErrorManager().log("Adding Web Module as DataObject");
        this.addDataObject(webModule);
    }

    public void addWebModule(FileObject webModuleRoot) throws Exception {
        DataObject webContext = DataObject.find((FileObject)webModuleRoot);
        this.addWebModule(webContext);
    }

    public void writeContent(ObjectOutput out) throws IOException {
        FileObjectFilter tempFilter = this.getFilter();
        this.setFilter(JarContent.DEFAULT);
        this.setMyWarFilter(tempFilter);
        super.writeContent(out);
        out.writeObject(this.getExtraFiles());
        out.writeObject(Boolean.FALSE);
        out.writeObject(null);
        out.writeObject(this.getMyWarFilter());
    }

    public void readContent(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readContent(in);
        this.setExtraFiles((Collection)in.readObject());
        in.readObject();
        in.readObject();
        FileObjectFilter tempFilter = (FileObjectFilter)in.readObject();
        this.setMyWarFilter(tempFilter);
        this.setFilter(tempFilter);
    }

    public static WarContent createDefaultWarContent() {
        WarContent warContent = new WarContent();
        return warContent;
    }

    public static FileObject findWarContentFile(FileObject parentDir, String name, boolean create) throws IOException {
        FileObject wcFo;
        String nameWithOutExt = name;
        int i = name.lastIndexOf(".");
        if (i > 0) {
            nameWithOutExt = name.substring(0, i);
        }
        if ((wcFo = parentDir.getFileObject(nameWithOutExt, WARCONTENT_EXT)) == null && create) {
            wcFo = parentDir.createData(name, WARCONTENT_EXT);
            WarContent defWC = WarContent.createDefaultWarContent();
            defWC.save(wcFo);
        }
        return wcFo;
    }

    public static WarContent loadWarContent(FileObject warContentFO) {
        WarContent warContent = WarContent.createDefaultWarContent();
        try {
            warContent.load(warContentFO);
        }
        catch (Exception ex) {
            WarPackagerSupport.getErrorManager().notify(1, (Throwable)ex);
        }
        return warContent;
    }

    public void load(FileObject warContentFO) throws IOException, ClassNotFoundException {
        this.load(warContentFO.getInputStream());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load(InputStream wcInStream) throws IOException, ClassNotFoundException {
        NbObjectInputStream ois = new NbObjectInputStream(wcInStream);
        try {
            this.readContent((ObjectInput)ois);
            Object var4_3 = null;
            if (ois == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (ois == null) throw throwable;
            ois.close();
            throw throwable;
        }
        ois.close();
    }

    public static void saveWarContent(WarContent warContent, FileObject warContentFO) throws IOException {
        warContent.save(warContentFO);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(FileObject warContentFO) throws IOException {
        FileLock lock = null;
        try {
            block4: {
                lock = warContentFO.lock();
                OutputStream wcOutStream = warContentFO.getOutputStream(lock);
                try {
                    this.save(wcOutStream);
                    Object var5_4 = null;
                    if (wcOutStream == null) break block4;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (wcOutStream == null) throw throwable;
                    wcOutStream.close();
                    throw throwable;
                }
                wcOutStream.close();
            }
            Object var7_7 = null;
            if (lock == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (lock == null) throw throwable;
            lock.releaseLock();
            throw throwable;
        }
        lock.releaseLock();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save(OutputStream wcOutStream) throws IOException {
        NbObjectOutputStream oos = new NbObjectOutputStream(wcOutStream);
        try {
            this.writeContent((ObjectOutput)oos);
            Object var4_3 = null;
            if (oos == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (oos == null) throw throwable;
            oos.close();
            throw throwable;
        }
        oos.close();
    }

    public void setWarContentFilter() {
        FileObjectFilter warFilter = this.getFilter();
        if (!(warFilter instanceof WarSuperFilter)) {
            this.setFilter(new WarSuperFilter(warFilter));
        }
    }

    public void resetWarContentFilter() {
        FileObjectFilter warFilter = this.getFilter();
        if (warFilter instanceof WarSuperFilter) {
            this.setFilter(((WarSuperFilter)warFilter).getWarFilter());
        }
    }

    public static final class WarSuperFilter
    implements FileObjectFilter {
        FileObjectFilter warFilter;

        public WarSuperFilter(FileObjectFilter warFilter) {
            this.warFilter = warFilter;
        }

        public FileObjectFilter getWarFilter() {
            return this.warFilter;
        }

        public boolean accept(FileObject fo) {
            WarPackagerSupport.getErrorManager().log("War SuperFiltering : " + fo.getPackageNameExt('/', '.'));
            if (!WARCONTENT_FILTER.accept(fo)) {
                return false;
            }
            return this.warFilter.accept(fo);
        }

        public String toString() {
            return this.warFilter.toString();
        }
    }

    public static final class WarContentFilter
    implements FileObjectFilter {
        static /* synthetic */ Class class$org$netbeans$modules$web$war$packager$WarContent;

        public boolean accept(FileObject fo) {
            String ext = fo.getExt();
            if (WarContent.WARCONTENT_EXT.equals(ext)) {
                return false;
            }
            String name = fo.getName();
            if (name.equals(WarContent.WEB_NAME)) {
                FileObject parent = fo.getParent();
                if (parent == null || !parent.getPackageName('/').equals(WarContent.WEBINF_PATH)) {
                    return true;
                }
                return WarContent.WEBXML_NAME.equals(name + "." + ext);
            }
            return true;
        }

        private Object readResolve() throws ObjectStreamException {
            return WARCONTENT_FILTER;
        }

        public String toString() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$web$war$packager$WarContent == null ? (class$org$netbeans$modules$web$war$packager$WarContent = WarContentFilter.class$("org.netbeans.modules.web.war.packager.WarContent")) : class$org$netbeans$modules$web$war$packager$WarContent), (String)"CTL_WarAllButJavaFilter");
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static final class WarAllButJavaFilter
    implements FileObjectFilter {
        static final long serialVersionUID = 4867639055067324309L;
        static /* synthetic */ Class class$org$netbeans$modules$web$war$packager$WarContent;

        public boolean accept(FileObject fo) {
            String extension = fo.getExt();
            return !"java".equals(extension) && !JarPackagerOption.singleton().getContentExt().equals(extension);
        }

        private Object readResolve() throws ObjectStreamException {
            return WAR_DEFAULT_FILTER;
        }

        public String toString() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$web$war$packager$WarContent == null ? (class$org$netbeans$modules$web$war$packager$WarContent = WarAllButJavaFilter.class$("org.netbeans.modules.web.war.packager.WarContent")) : class$org$netbeans$modules$web$war$packager$WarContent), (String)"CTL_WarAllButJavaFilter");
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

