/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.war.packager;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.netbeans.modules.jarpackager.ArchiveDescriptor;
import org.netbeans.modules.jarpackager.JarCreator;
import org.netbeans.modules.jarpackager.api.ArchiveBuilder;
import org.netbeans.modules.web.war.WarPackagerSupport;
import org.netbeans.modules.web.war.packager.FileObjectWarEntry;
import org.netbeans.modules.web.war.packager.FileWarEntry;
import org.netbeans.modules.web.war.packager.StringWarEntry;
import org.netbeans.modules.web.war.packager.WarContent;
import org.netbeans.modules.web.war.packager.WarEntry;
import org.netbeans.modules.web.war.packager.WarException;
import org.netbeans.modules.web.war.packager.WarPackager;
import org.netbeans.modules.web.war.packager.WarPackagerArchiveBuilder;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class WarPackagerImpl
implements WarPackager {
    WarContent warContent = new WarContent();
    static /* synthetic */ Class class$org$netbeans$modules$web$war$packager$WarPackagerImpl;

    public void setWarFile(File warFile) throws WarException {
        if (!this.hasWarExtension(warFile)) {
            throw new WarException(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$war$packager$WarPackagerImpl == null ? (class$org$netbeans$modules$web$war$packager$WarPackagerImpl = WarPackagerImpl.class$("org.netbeans.modules.web.war.packager.WarPackagerImpl")) : class$org$netbeans$modules$web$war$packager$WarPackagerImpl), (String)"Msg_WarEx_InvalidWarExt"));
        }
        try {
            this.warContent.setTargetFile(warFile);
        }
        catch (Exception ex) {
            WarPackagerSupport.getErrorManager().notify(1, (Throwable)ex);
            throw new WarException(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$war$packager$WarPackagerImpl == null ? (class$org$netbeans$modules$web$war$packager$WarPackagerImpl = WarPackagerImpl.class$("org.netbeans.modules.web.war.packager.WarPackagerImpl")) : class$org$netbeans$modules$web$war$packager$WarPackagerImpl), (String)"Msg_WarEx_InvalidWarExt"));
        }
    }

    public void setWarFile(FileObject warFileObject) throws WarException {
        if (!this.hasWarExtension(warFileObject)) {
            throw new WarException(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$war$packager$WarPackagerImpl == null ? (class$org$netbeans$modules$web$war$packager$WarPackagerImpl = WarPackagerImpl.class$("org.netbeans.modules.web.war.packager.WarPackagerImpl")) : class$org$netbeans$modules$web$war$packager$WarPackagerImpl), (String)"Msg_WarEx_InvalidWarExt"));
        }
        try {
            this.warContent.setTargetResource(warFileObject.getURL());
        }
        catch (Exception ex) {
            throw new WarException(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$war$packager$WarPackagerImpl == null ? (class$org$netbeans$modules$web$war$packager$WarPackagerImpl = WarPackagerImpl.class$("org.netbeans.modules.web.war.packager.WarPackagerImpl")) : class$org$netbeans$modules$web$war$packager$WarPackagerImpl), (String)"Msg_WarEx_InvalidWarExt"));
        }
    }

    public void setWarFile(URL warURL) throws WarException {
        if (!this.hasWarExtension(warURL)) {
            throw new WarException(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$war$packager$WarPackagerImpl == null ? (class$org$netbeans$modules$web$war$packager$WarPackagerImpl = WarPackagerImpl.class$("org.netbeans.modules.web.war.packager.WarPackagerImpl")) : class$org$netbeans$modules$web$war$packager$WarPackagerImpl), (String)"Msg_WarEx_InvalidWarExt"));
        }
        this.warContent.setTargetResource(warURL);
    }

    public void setWarContent(WarContent warContnet) throws WarException {
        this.warContent = warContnet;
    }

    public void addWarEntries(Collection warEntries) throws WarException {
        this.warContent.addWarEntries(warEntries);
    }

    public void addFilesToRoot(Collection files) throws WarException {
        this.addEntriesWithPrefix(files, null);
    }

    public void addFilesToClassesDir(Collection files) throws WarException {
        WarPackagerSupport.getErrorManager().log("Adding files To Classes Dir WEB-INF/classes size : " + files.size());
        this.addEntriesWithPrefix(files, "WEB-INF/classes");
    }

    public void addFilesToLibDir(Collection files) throws WarException {
        this.addEntriesWithPrefix(files, "WEB-INF/lib");
    }

    public void addFilesToWebInfDir(Collection files) throws WarException {
        this.addEntriesWithPrefix(files, "WEB-INF");
    }

    public void addWebXml(String webXml) throws WarException {
        Vector<StringWarEntry> entries = new Vector<StringWarEntry>();
        entries.add(new StringWarEntry(webXml, this.getWebXmlName()));
        this.warContent.addWarEntries(entries);
    }

    public void addWebXml(FileObject webXmlFileObject) throws WarException {
        Vector<FileObjectWarEntry> entries = new Vector<FileObjectWarEntry>();
        entries.add(new FileObjectWarEntry(webXmlFileObject, this.getWebXmlName()));
        this.warContent.addWarEntries(entries);
    }

    public void generateWarFile() throws WarException {
        this.doPackage();
    }

    protected String getWebXmlName() {
        return "WEB-INF/web.xml";
    }

    protected String getValidWarEntryName(String warItemName, String warItemExt, String prefix) throws WarException {
        String name = null;
        if (prefix == null) {
            name = null;
        } else if (prefix.equalsIgnoreCase("WEB-INF/lib")) {
            if (warItemExt.equals("jar")) {
                name = warItemName + "." + warItemExt;
            }
        } else if (prefix.equalsIgnoreCase("WEB-INF")) {
            if ("web.xml".equalsIgnoreCase(warItemName + "." + warItemExt)) {
                name = warItemName + "." + warItemExt;
            }
        } else if (!prefix.equalsIgnoreCase("WEB-INF/classes")) {
            throw new WarException(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$war$packager$WarPackagerImpl == null ? (class$org$netbeans$modules$web$war$packager$WarPackagerImpl = WarPackagerImpl.class$("org.netbeans.modules.web.war.packager.WarPackagerImpl")) : class$org$netbeans$modules$web$war$packager$WarPackagerImpl), (String)"Msg_WarEx_InvalidPrefix"));
        }
        return name;
    }

    protected WarEntry createValidWarEntry(File warItem, String prefix) throws WarException {
        String name = null;
        String warItemName = warItem.getName();
        String warItemExt = "";
        int idx = warItemName.lastIndexOf(".");
        if (idx >= 0) {
            warItemExt = warItemName.substring(idx + 1);
            warItemName = warItemName.substring(0, idx);
        }
        name = this.getValidWarEntryName(warItemName, warItemExt, prefix);
        FileWarEntry fileWarEntry = new FileWarEntry(warItem, name, prefix);
        WarPackagerSupport.getErrorManager().log("creating File War entry : " + fileWarEntry);
        return fileWarEntry;
    }

    protected WarEntry createValidWarEntry(FileObject warItem, String prefix) throws WarException {
        String name = null;
        String warItemName = warItem.getName();
        String warItemExt = warItem.getExt();
        name = this.getValidWarEntryName(warItemName, warItemExt, prefix);
        FileObjectWarEntry warEntry = new FileObjectWarEntry(warItem, name, prefix);
        return warEntry;
    }

    protected WarEntry createValidWarEntry(String warItem, String itemName, String prefix) throws WarException {
        String name = null;
        String warItemName = itemName;
        String warItemExt = "";
        name = this.getValidWarEntryName(warItemName, warItemExt, prefix);
        StringWarEntry warEntry = new StringWarEntry(warItem, name, prefix);
        return warEntry;
    }

    protected WarEntry createValidWarEntry(WarEntry warEntry, String prefix) throws WarException {
        if (warEntry instanceof FileWarEntry) {
            return this.createValidWarEntry(((FileWarEntry)warEntry).getFile(), prefix);
        }
        if (warEntry instanceof FileObjectWarEntry) {
            FileObject fo = ((FileObjectWarEntry)warEntry).getFileObject();
            String name = this.getValidWarEntryName(fo.getName(), fo.getExt(), prefix);
            if (name == null) {
                name = warEntry.getName();
            }
            return new FileObjectWarEntry(fo, name, prefix);
        }
        if (warEntry instanceof StringWarEntry) {
            StringWarEntry strEntry = (StringWarEntry)warEntry;
            return this.createValidWarEntry(strEntry.getContents(), strEntry.getName(), prefix);
        }
        return warEntry;
    }

    protected void addEntriesWithPrefix(Collection files, String prefix) throws WarException {
        Iterator filesItr = files.iterator();
        Vector<WarEntry> warEntries = new Vector<WarEntry>();
        WarPackagerSupport.getErrorManager().log("Adding entries with Prefix : " + prefix);
        while (filesItr.hasNext()) {
            Object entry = filesItr.next();
            if (entry instanceof FileObject) {
                warEntries.add(this.createValidWarEntry((FileObject)entry, prefix));
                continue;
            }
            if (entry instanceof File) {
                warEntries.add(this.createValidWarEntry((File)entry, prefix));
                continue;
            }
            if (entry instanceof WarEntry) {
                warEntries.add(this.createValidWarEntry((WarEntry)entry, prefix));
                continue;
            }
            throw new WarException(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$war$packager$WarPackagerImpl == null ? (class$org$netbeans$modules$web$war$packager$WarPackagerImpl = WarPackagerImpl.class$("org.netbeans.modules.web.war.packager.WarPackagerImpl")) : class$org$netbeans$modules$web$war$packager$WarPackagerImpl), (String)"Msg_WarEx_InvalidEntry"));
        }
        this.warContent.addWarEntries(warEntries);
    }

    protected boolean hasWarExtension(String fileName) {
        String ext = new String();
        int i = fileName.lastIndexOf(".");
        if (i > 0) {
            ext = fileName.substring(i + 1);
        }
        return "war".equals(ext);
    }

    protected boolean hasWarExtension(File warFile) {
        return this.hasWarExtension(warFile.getName());
    }

    protected boolean hasWarExtension(FileObject warFileObject) {
        return "war".equals(warFileObject.getExt());
    }

    protected boolean hasWarExtension(URL warURL) {
        return this.hasWarExtension(warURL.getFile());
    }

    public void processExtraFiles() {
        ArrayList extra = (ArrayList)this.warContent.getExtraFiles();
        if (extra.size() > 0) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$war$packager$WarPackagerImpl == null ? (class$org$netbeans$modules$web$war$packager$WarPackagerImpl = WarPackagerImpl.class$("org.netbeans.modules.web.war.packager.WarPackagerImpl")) : class$org$netbeans$modules$web$war$packager$WarPackagerImpl), (String)"Msg_Status_inclExtraFiles"));
            this.warContent.getContentList().addList((ArrayList)this.warContent.getExtraFiles());
        }
    }

    /*
     * Loose catch block
     */
    public void doPackage() throws WarException {
        block10: {
            OutputStream warOStream = null;
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$war$packager$WarPackagerImpl == null ? (class$org$netbeans$modules$web$war$packager$WarPackagerImpl = WarPackagerImpl.class$("org.netbeans.modules.web.war.packager.WarPackagerImpl")) : class$org$netbeans$modules$web$war$packager$WarPackagerImpl), (String)"Msg_Status_WarCreating"));
            WarPackagerArchiveBuilder warArchiveBuilder = null;
            ArchiveBuilder serverArchiveBuilder = null;
            serverArchiveBuilder = this.warContent.getServerArchiveBuilder();
            warArchiveBuilder = new WarPackagerArchiveBuilder(this.warContent);
            File warFile = this.warContent.getTargetFile();
            warFile.delete();
            warOStream = new FileOutputStream(warFile);
            this.processExtraFiles();
            this.warContent.setWarContentFilter();
            JarCreator jarCreator = new JarCreator((ArchiveDescriptor)this.warContent);
            jarCreator.addSpecificBuilder((ArchiveBuilder)warArchiveBuilder);
            if (serverArchiveBuilder != null) {
                jarCreator.addSpecificBuilder(serverArchiveBuilder);
            }
            jarCreator.createJar(warOStream, warFile);
            this.warContent.resetWarContentFilter();
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$web$war$packager$WarPackagerImpl == null ? (class$org$netbeans$modules$web$war$packager$WarPackagerImpl = WarPackagerImpl.class$("org.netbeans.modules.web.war.packager.WarPackagerImpl")) : class$org$netbeans$modules$web$war$packager$WarPackagerImpl), (String)"Msg_Status_WarCreated"));
            warOStream.close();
            warOStream = null;
            Object var7_7 = null;
            try {
                if (warOStream != null) {
                    warOStream.close();
                }
                break block10;
            }
            catch (Exception ex) {
                WarPackagerSupport.getErrorManager().notify(1, (Throwable)ex);
            }
            break block10;
            {
                catch (Exception ex) {
                    WarPackagerSupport.getErrorManager().notify(1, (Throwable)ex);
                    throw new WarException(ex);
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    if (warOStream != null) {
                        warOStream.close();
                    }
                }
                catch (Exception ex) {
                    WarPackagerSupport.getErrorManager().notify(1, (Throwable)ex);
                }
                throw throwable;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

