/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webdata;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.modules.j2ee.server.datamodel.AppChangeEvent;
import org.netbeans.modules.j2ee.server.datamodel.AppChangeListener;
import org.netbeans.modules.j2ee.server.datamodel.StandardData;
import org.netbeans.modules.j2ee.server.datamodel.WebAppStandardData;
import org.netbeans.modules.web.context.WebAppMapping;
import org.netbeans.modules.web.context.WebContextObject;
import org.netbeans.modules.web.webdata.StandardDataImpl;
import org.netbeans.modules.web.webdata.WebDataFactory;
import org.netbeans.modules.web.webdata.WebMappingImpl;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.RequestProcessor;

public class WebApplicationImpl
extends StandardDataImpl
implements WebAppStandardData,
PropertyChangeListener,
RepositoryListener {
    protected WebAppStandardData.WebMapping[] webMappings = null;
    protected Set appChangeListeners = new HashSet(5);
    protected FileObject fileObject = null;
    protected DataObject dataObject = null;
    protected String fileSystemName = null;
    static /* synthetic */ Class class$org$netbeans$modules$web$context$WebContextObject;
    static /* synthetic */ Class class$org$netbeans$modules$web$context$WebAppMapping$MappingCookie;

    public WebApplicationImpl(FileObject fileObject) {
        this.fileObject = fileObject;
        this.addListener();
        this.init();
    }

    protected void addListener() {
        if (this.dataObject != null) {
            this.dataObject.removePropertyChangeListener((PropertyChangeListener)this);
        }
        try {
            DataObject dob = DataObject.find((FileObject)this.fileObject);
            dob.addPropertyChangeListener((PropertyChangeListener)this);
            this.dataObject = dob;
        }
        catch (DataObjectNotFoundException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
    }

    protected void init() {
        try {
            DataObject dob = DataObject.find((FileObject)this.fileObject);
            WebContextObject wco = (WebContextObject)dob.getCookie(class$org$netbeans$modules$web$context$WebContextObject == null ? (class$org$netbeans$modules$web$context$WebContextObject = WebApplicationImpl.class$("org.netbeans.modules.web.context.WebContextObject")) : class$org$netbeans$modules$web$context$WebContextObject);
            if (wco != null) {
                this.webMappings = new WebAppStandardData.WebMapping[1];
                this.webMappings[0] = new WebMappingImpl(WebDataFactory.getFactory().findWebModule(this.fileObject), wco.getURIParameter());
            } else {
                WebAppMapping.MappingCookie wam = (WebAppMapping.MappingCookie)dob.getCookie(class$org$netbeans$modules$web$context$WebAppMapping$MappingCookie == null ? (class$org$netbeans$modules$web$context$WebAppMapping$MappingCookie = WebApplicationImpl.class$("org.netbeans.modules.web.context.WebAppMapping$MappingCookie")) : class$org$netbeans$modules$web$context$WebAppMapping$MappingCookie);
                if (wam != null) {
                    TreeSet treeSet = wam.getWarehouse();
                    this.webMappings = new WebAppStandardData.WebMapping[treeSet.size()];
                    Iterator iterator = treeSet.iterator();
                    int i = 0;
                    while (i < treeSet.size()) {
                        WebAppMapping webApp = (WebAppMapping)iterator.next();
                        FileSystem fs = Repository.getDefault().findFileSystem(webApp.getName());
                        if (fs != null) {
                            FileObject fo = fs.getRoot();
                            this.webMappings[i] = new WebMappingImpl(WebDataFactory.getFactory().findWebModule(fo), webApp.getMapping());
                        }
                        ++i;
                    }
                } else {
                    this.webMappings = new WebAppStandardData.WebMapping[0];
                }
            }
        }
        catch (DataObjectNotFoundException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public WebAppStandardData.WebMapping[] getWebModules() {
        return this.webMappings;
    }

    public void addAppChangeListener(AppChangeListener acl) {
        if (this.appChangeListeners == null) {
            WebApplicationImpl webApplicationImpl = this;
            synchronized (webApplicationImpl) {
                if (this.appChangeListeners == null) {
                    this.appChangeListeners = new HashSet(5);
                }
            }
        }
        this.appChangeListeners.add(acl);
    }

    public void removeAppChangeListener(AppChangeListener acl) {
        if (this.appChangeListeners != null) {
            this.appChangeListeners.remove(acl);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String name = propertyChangeEvent.getPropertyName();
        if ("URI_CHANGE".equals(name) || "WAREHOUSE_CHANGE_PROPERTY".equals(name)) {
            this.fireWebModuleChange();
        }
        if (name.equals("valid")) {
            Repository.getDefault().addRepositoryListener((RepositoryListener)this);
            try {
                this.fileSystemName = this.fileObject.getFileSystem().getSystemName();
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    protected void fireWebModuleChange() {
        this.init();
        AppChangeEvent ace = new AppChangeEvent(2, 2, (StandardData)this);
        Iterator i = this.appChangeListeners.iterator();
        while (i.hasNext()) {
            ((AppChangeListener)i.next()).fireAppChangeEvent(ace);
        }
    }

    protected void webModuleInit() {
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                WebDataFactory.getFactory().findWebModule(WebApplicationImpl.this.fileObject).init();
            }
        }, (int)100);
    }

    public void fileSystemAdded(RepositoryEvent ev) {
        if (this.fileSystemName == null || this.fileSystemName.equals(ev.getFileSystem().getSystemName())) {
            Repository.getDefault().removeRepositoryListener((RepositoryListener)this);
            this.fileSystemName = null;
            this.webModuleInit();
            this.addListener();
            this.fireWebModuleChange();
        }
    }

    public void fileSystemPoolReordered(RepositoryReorderedEvent ev) {
    }

    public void fileSystemRemoved(RepositoryEvent ev) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

