/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webdata;

import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.j2ee.impl.ServerExecSupport;
import org.netbeans.modules.j2ee.impl.ServerInstanceData;
import org.netbeans.modules.j2ee.impl.ServerRegistryImpl;
import org.netbeans.modules.j2ee.server.ConfigInputStream;
import org.netbeans.modules.j2ee.server.CustomData;
import org.netbeans.modules.j2ee.server.CustomDialogData;
import org.netbeans.modules.j2ee.server.Server;
import org.netbeans.modules.j2ee.server.ServerInstance;
import org.netbeans.modules.j2ee.server.datamodel.StandardData;
import org.netbeans.modules.j2ee.server.datamodel.WebAppStandardData;
import org.netbeans.modules.j2ee.server.datamodel.WebStandardData;
import org.netbeans.modules.j2ee.server.web.WebCustomData;
import org.netbeans.modules.j2ee.server.web.WebServer;
import org.netbeans.modules.web.context.DelegatingFileSystem;
import org.netbeans.modules.web.context.WebContextObject;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.netbeans.modules.web.execution.MonitorSupport;
import org.netbeans.modules.web.webdata.WebApplicationImpl;
import org.netbeans.modules.web.webdata.WebDDDataImpl;
import org.netbeans.modules.web.webdata.WebJarImpl;
import org.netbeans.modules.web.webdata.WebJspImpl;
import org.netbeans.modules.web.webdata.WebModuleImpl;
import org.netbeans.modules.web.webdata.WebResourceImpl;
import org.netbeans.modules.web.webdata.WebServletImpl;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class WebDataFactoryImpl {
    protected Map webDataMap = new WeakHashMap(100);
    protected Map webModuleMap = new WeakHashMap(10);
    protected Map webAppMap = new WeakHashMap(10);
    private static MonitorSupport monitorSupport;
    private static final String PROP_CONTENT_LANGUAGE = "content_language";
    private static final String EA_CONTENT_LANGUAGE = "NbAttrContentLanguage";
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$impl$J2EEAppCookie;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$modules$web$webdata$WebDataFactoryImpl;

    public ServerInstance findServerInstance(WebStandardData standardData) {
        ServerInstance serverInstance = null;
        if (standardData instanceof WebStandardData) {
            WebModuleImpl webModuleImpl = (WebModuleImpl)standardData.getWebModule();
            if (webModuleImpl == null) {
                return null;
            }
            FileObject webAppFileObject = ((WebApplicationImpl)this.findWebApplication(webModuleImpl.getFileObject())).getFileObject();
            serverInstance = ServerExecSupport.findServerInstance((ServerInstanceData)ServerExecSupport.getServerInstance((FileObject)webAppFileObject));
            if (serverInstance == null) {
                serverInstance = ServerExecSupport.findServerInstance((ServerInstanceData)ServerExecSupport.getServerInstance((FileObject)webModuleImpl.getFileObject()));
            }
        }
        if (serverInstance == null) {
            serverInstance = ServerRegistryImpl.getRegistry().getDefaultWebInstance();
        }
        if (serverInstance == null) {
            serverInstance = ServerRegistryImpl.getRegistry().getDefaultAppInstance();
        }
        return serverInstance;
    }

    public WebStandardData.WebResource findResource(String name, WebModuleImpl wm) {
        DataObject dob = null;
        FileObject fo = null;
        try {
            fo = this.findFileObject(name, wm);
            if (fo == null) {
                return null;
            }
            dob = DataObject.find((FileObject)fo);
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
        }
        catch (DataObjectNotFoundException e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
        }
        if (fo.getParent().getPackageName('/').equals("WEB-INF/lib") && fo.getExt().equals("jar")) {
            return this.getWebJar(fo);
        }
        if (dob instanceof JspDataObject) {
            return this.getWebJsp(name, wm);
        }
        if (fo.getPackageNameExt('/', '.').equals("WEB-INF/web.xml")) {
            return this.getWebDDData(fo);
        }
        return this.getWebResource(name, wm);
    }

    private FileObject findFileObject(String name, WebModuleImpl wm) throws FileStateInvalidException {
        FileObject fo;
        FileSystem webContextFS = wm.getFileObject().getFileSystem();
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if ((fo = webContextFS.findResource(name)) == null) {
            Enumeration enumeration = Repository.getDefault().getFileSystems();
            while (enumeration.hasMoreElements()) {
                FileSystem classesFS = (FileSystem)enumeration.nextElement();
                if (!(classesFS instanceof DelegatingFileSystem) || !((DelegatingFileSystem)classesFS).delegatesTo(webContextFS)) continue;
                fo = classesFS.findResource(name);
                break;
            }
        }
        return fo;
    }

    public DataObject findDataObject(String name, WebModuleImpl wm) {
        try {
            FileObject fo = this.findFileObject(name, wm);
            return fo == null ? null : DataObject.find((FileObject)fo);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
            return null;
        }
    }

    public WebResourceImpl getWebResource(String name, WebStandardData.WebModule webModule) {
        WebResourceImpl webResource = null;
        Identification identification = new Identification(name, webModule);
        webResource = (WebResourceImpl)this.webDataMap.get(identification);
        if (webResource == null) {
            webResource = this.createWebResource(identification);
        }
        return webResource;
    }

    protected synchronized WebResourceImpl createWebResource(Identification identification) {
        WebResourceImpl webResource = null;
        webResource = (WebResourceImpl)this.webDataMap.get(identification);
        if (webResource == null) {
            webResource = new WebResourceImpl(identification.getName(), identification.getWebModule());
            this.webDataMap.put(identification, webResource);
        }
        return webResource;
    }

    public WebJspImpl getWebJsp(String name, WebStandardData.WebModule webModule) {
        WebJspImpl webJsp = null;
        Identification identification = new Identification(name, webModule);
        webJsp = (WebJspImpl)this.webDataMap.get(identification);
        if (webJsp == null) {
            webJsp = this.createWebJsp(identification);
        }
        return webJsp;
    }

    protected synchronized WebJspImpl createWebJsp(Identification identification) {
        WebJspImpl webJsp = null;
        webJsp = (WebJspImpl)this.webDataMap.get(identification);
        if (webJsp == null) {
            webJsp = new WebJspImpl(identification.getName(), identification.getWebModule());
            this.webDataMap.put(identification, webJsp);
        }
        return webJsp;
    }

    public WebServletImpl getWebServlet(String className, WebStandardData.WebModule webModule) {
        WebServletImpl webServlet = null;
        Identification identification = new Identification(className, webModule);
        webServlet = (WebServletImpl)this.webDataMap.get(identification);
        if (webServlet == null) {
            webServlet = this.createWebServlet(identification);
        }
        return webServlet;
    }

    protected synchronized WebServletImpl createWebServlet(Identification identification) {
        WebServletImpl webServlet = null;
        webServlet = (WebServletImpl)this.webDataMap.get(identification);
        if (webServlet == null) {
            webServlet = new WebServletImpl(identification.getName(), identification.getWebModule());
            this.webDataMap.put(identification, webServlet);
        }
        return webServlet;
    }

    public WebModuleImpl findWebModule(FileObject fo) {
        FileObject webModuleFO;
        block6: {
            webModuleFO = null;
            DataObject rootDO = null;
            try {
                FileObject rootFO;
                FileSystem firstFS = fo.getFileSystem();
                webModuleFO = rootFO = firstFS.getRoot();
                rootDO = DataObject.find((FileObject)rootFO);
                if (rootDO instanceof WebContextObject) {
                    return this.getWebModule(webModuleFO);
                }
                if (!(rootDO instanceof DataFolder) || !(firstFS instanceof DelegatingFileSystem)) break block6;
                Enumeration enumeration = Repository.getDefault().getFileSystems();
                while (enumeration.hasMoreElements()) {
                    FileSystem fs = (FileSystem)enumeration.nextElement();
                    if (!((DelegatingFileSystem)firstFS).delegatesTo(fs)) continue;
                    webModuleFO = fs.getRoot();
                    break;
                }
            }
            catch (DataObjectNotFoundException e) {
                ErrorManager.getDefault().notify(4096, (Throwable)e);
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify(4096, (Throwable)e);
            }
        }
        if (webModuleFO == null) {
            return this.getWebModule(fo);
        }
        return this.getWebModule(webModuleFO);
    }

    protected WebModuleImpl getWebModule(FileObject mdo) {
        WebModuleImpl webModule = null;
        webModule = (WebModuleImpl)this.webModuleMap.get(mdo);
        if (webModule == null) {
            webModule = this.createWebModule(mdo);
        }
        return webModule;
    }

    protected synchronized WebModuleImpl createWebModule(FileObject mdo) {
        WebModuleImpl webModule = null;
        webModule = (WebModuleImpl)this.webModuleMap.get(mdo);
        if (webModule == null) {
            webModule = new WebModuleImpl(mdo);
            this.webModuleMap.put(mdo, webModule);
        }
        return webModule;
    }

    public WebAppStandardData findWebApplication(FileObject fileObject) {
        FileObject webContextFO;
        WebModuleImpl webModuleImpl = this.findWebModule(fileObject);
        FileObject serverConfigFO = ServerExecSupport.getWebAppParameter((FileObject)webModuleImpl.getFileObject());
        if (serverConfigFO != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)serverConfigFO);
                if (dataObject.getCookie(class$org$netbeans$modules$j2ee$impl$J2EEAppCookie == null ? (class$org$netbeans$modules$j2ee$impl$J2EEAppCookie = WebDataFactoryImpl.class$("org.netbeans.modules.j2ee.impl.J2EEAppCookie")) : class$org$netbeans$modules$j2ee$impl$J2EEAppCookie) != null) {
                    return this.getWebApplication(serverConfigFO);
                }
            }
            catch (DataObjectNotFoundException e) {
                // empty catch block
            }
        }
        if ((webContextFO = webModuleImpl.getFileObject()) != null) {
            return this.getWebApplication(webContextFO);
        }
        ErrorManager.getDefault().notify(4096, (Throwable)new Exception("no file object for the web app"));
        return null;
    }

    public WebAppStandardData getWebApplication(FileObject mdo) {
        WebApplicationImpl webApplication = null;
        webApplication = (WebApplicationImpl)this.webAppMap.get(mdo);
        if (webApplication == null) {
            webApplication = this.createWebApplication(mdo);
        }
        return webApplication;
    }

    protected synchronized WebAppStandardData createWebApplication(FileObject mdo) {
        WebApplicationImpl webApplication = null;
        webApplication = (WebApplicationImpl)this.webAppMap.get(mdo);
        if (webApplication == null) {
            webApplication = new WebApplicationImpl(mdo);
            this.webAppMap.put(mdo, webApplication);
        }
        return webApplication;
    }

    public WebDDDataImpl getWebDDData(FileObject jdo) {
        WebDDDataImpl webDDData = null;
        webDDData = (WebDDDataImpl)this.webDataMap.get(jdo);
        if (webDDData == null) {
            webDDData = this.createWebDDData(jdo);
        }
        return webDDData;
    }

    protected synchronized WebDDDataImpl createWebDDData(FileObject jdo) {
        WebDDDataImpl webDDData = null;
        webDDData = (WebDDDataImpl)this.webDataMap.get(jdo);
        if (webDDData == null) {
            webDDData = new WebDDDataImpl(jdo);
            this.webDataMap.put(jdo, webDDData);
        }
        return webDDData;
    }

    public CustomData getCustomData(StandardData sd, Server server, ConfigInputStream[] inputStream) throws IllegalArgumentException {
        if (server instanceof WebServer) {
            WebStandardData.WebModule wm = null;
            if (sd instanceof WebStandardData.WebResource) {
                wm = ((WebStandardData.WebResource)sd).getWebModule();
            }
            if (sd instanceof WebStandardData.WebServlet) {
                wm = ((WebStandardData.WebServlet)sd).getWebModule();
            }
            if (wm == null) {
                throw new IllegalArgumentException();
            }
            WebServer ws = (WebServer)server;
            if (ws.getWebConfigSupport() == null) {
                return null;
            }
            WebCustomData.WebConfigurator wc = ws.getWebConfigSupport().getWebCustomData(wm, inputStream);
            if (sd instanceof WebStandardData.WebModule) {
                return wc;
            }
            if (sd instanceof WebStandardData.WebJar) {
                return wc.getJarCustomData((WebStandardData.WebJar)sd);
            }
        }
        return null;
    }

    public CustomDialogData getCustomDialogData(StandardData sd, Server server, ConfigInputStream[] inputStream) throws IllegalArgumentException {
        if (server instanceof WebServer) {
            WebStandardData.WebModule wm = null;
            if (sd instanceof WebStandardData.WebResource) {
                wm = ((WebStandardData.WebResource)sd).getWebModule();
            }
            if (sd instanceof WebStandardData.WebServlet) {
                wm = ((WebStandardData.WebServlet)sd).getWebModule();
            }
            if (wm == null) {
                throw new IllegalArgumentException();
            }
            WebServer ws = (WebServer)server;
            if (ws.getWebConfigSupport() == null) {
                return null;
            }
            WebCustomData.WebConfigurator wc = ws.getWebConfigSupport().getWebCustomData(wm, inputStream);
            if (sd instanceof WebStandardData.EjbRefData) {
                return wc.getEjbRefCustomData((WebStandardData.EjbRefData)sd);
            }
            if (sd instanceof WebStandardData.ResourceRefData) {
                return wc.getResourceRefCustomData((WebStandardData.ResourceRefData)sd);
            }
            if (sd instanceof WebStandardData.ServletJspData) {
                return wc.getServletJspCustomData((WebStandardData.ServletJspData)sd);
            }
        }
        return null;
    }

    public WebStandardData.WebJar getWebJar(FileObject jdo) {
        WebStandardData.WebJar webJar = null;
        webJar = (WebStandardData.WebJar)this.webDataMap.get(jdo);
        if (webJar == null) {
            webJar = this.createWebJar(jdo);
        }
        return webJar;
    }

    protected synchronized WebStandardData.WebJar createWebJar(FileObject jdo) {
        WebStandardData.WebJar webJar = null;
        webJar = (WebStandardData.WebJar)this.webDataMap.get(jdo);
        if (webJar == null) {
            webJar = new WebJarImpl(jdo);
            this.webDataMap.put(jdo, webJar);
        }
        return webJar;
    }

    public WebStandardData.ContextParamData getContextParamData(Object jdo, WebStandardData.WebModule webModule) {
        return null;
    }

    public WebStandardData.ServletJspData getServletJspData(Object jdo, WebStandardData.WebModule webModule) {
        return null;
    }

    public WebStandardData.IconData getIconData(Object jdo, WebStandardData.WebModule webModule) {
        return null;
    }

    public WebStandardData.TagLibData getTagLibData(Object jdo, WebStandardData.WebModule webModule) {
        return null;
    }

    public WebStandardData.ServletMappingData getServletMappingData(Object jdo, WebStandardData.WebModule webModule) {
        return null;
    }

    public WebStandardData.MimeMappingData getMimeMappingData(Object jdo, WebStandardData.WebModule webModule) {
        return null;
    }

    public WebStandardData.ErrorPageData getErrorPageData(Object jdo, WebStandardData.WebModule webModule) {
        return null;
    }

    public WebStandardData.ResourceRefData getResourceRefData(Object jdo, WebStandardData.WebModule webModule) {
        return null;
    }

    public WebStandardData.ResourceEnvRefData getResourceEnvRefData(Object jdo, WebStandardData.WebModule webModule) {
        return null;
    }

    public WebStandardData.SecurityConstraintData getSecurityConstraintData(Object jdo, WebStandardData.WebModule webModule) {
        return null;
    }

    public WebStandardData.WebResourceCollectionData getWebResourceCollectionData(Object jdo, WebStandardData.WebModule webModule) {
        return null;
    }

    public WebStandardData.AuthConstraintData getAuthConstraintData(Object jdo, WebStandardData.WebModule webModule) {
        return null;
    }

    public WebStandardData.UserDataConstraintData getUserDataConstraintData(Object jdo, WebStandardData.WebModule webModule) {
        return null;
    }

    public WebStandardData.LoginConfigData getLoginConfigData(Object jdo, WebStandardData.WebModule webModule) {
        return null;
    }

    public WebStandardData.SecurityRoleData getSecurityRoleData(Object jdo, WebStandardData.WebModule webModule) {
        return null;
    }

    public WebStandardData.EnvironmentEntryData getEnvironmentEntryData(Object jdo, WebStandardData.WebModule webModule) {
        return null;
    }

    public WebStandardData.EjbRefData getEjbRefData(Object jdo, WebStandardData.WebModule webModule) {
        return null;
    }

    public WebStandardData.EjbLocalRefData getEjbLocalRefData(Object jdo, WebStandardData.WebModule webModule) {
        return null;
    }

    public WebStandardData.InitParamData getInitParamData(Object jdo, WebStandardData.WebModule webModule) {
        return null;
    }

    public WebStandardData.SecurityRoleRefData getSecurityRoleRefData(Object jdo, WebStandardData.WebModule webModule) {
        return null;
    }

    public WebStandardData.RunAsData getRunAsData(Object jdo, WebStandardData.WebModule webModule) {
        return null;
    }

    public WebStandardData.ListenerData getListener(Object jdo, WebStandardData.WebModule webModule) {
        return null;
    }

    public WebStandardData.FilterData getFilter(Object jdo, WebStandardData.WebModule webModule) {
        return null;
    }

    public WebStandardData.FilterMappingData getFilterMapping(Object jdo, WebStandardData.WebModule webModule) {
        return null;
    }

    public WebStandardData.ResourceEnvRefData getResourceEnvRef(Object jdo, WebStandardData.WebModule webModule) {
        return null;
    }

    public WebStandardData.EjbLocalRefData getEjbLocalRef(Object jdo, WebStandardData.WebModule webModule) {
        return null;
    }

    public void addContentLanguageProperty(Sheet.Set ps, final DataObject dob) {
        ps.put((Node.Property)new PropertySupport.ReadWrite(PROP_CONTENT_LANGUAGE, class$java$lang$String == null ? (class$java$lang$String = WebDataFactoryImpl.class$("java.lang.String")) : class$java$lang$String, NbBundle.getBundle((Class)(class$org$netbeans$modules$web$webdata$WebDataFactoryImpl == null ? (class$org$netbeans$modules$web$webdata$WebDataFactoryImpl = WebDataFactoryImpl.class$("org.netbeans.modules.web.webdata.WebDataFactoryImpl")) : class$org$netbeans$modules$web$webdata$WebDataFactoryImpl)).getString("PROP_contentLanguageTitle"), NbBundle.getBundle((Class)(class$org$netbeans$modules$web$webdata$WebDataFactoryImpl == null ? (class$org$netbeans$modules$web$webdata$WebDataFactoryImpl = WebDataFactoryImpl.class$("org.netbeans.modules.web.webdata.WebDataFactoryImpl")) : class$org$netbeans$modules$web$webdata$WebDataFactoryImpl)).getString("HINT_contentLanguageHint")){

            public Object getValue() {
                String o = WebDataFactoryImpl.this.getContentLanguageParameter(dob.getPrimaryFile());
                if (o == null) {
                    return "";
                }
                return o;
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (!(val instanceof String)) {
                    throw new IllegalArgumentException();
                }
                WebDataFactoryImpl.this.setContentLanguageParameter(dob.getPrimaryFile(), (String)val);
            }
        });
    }

    public String getContentLanguageParameter(FileObject fob) {
        try {
            String str = (String)fob.getAttribute(EA_CONTENT_LANGUAGE);
            if (str == null) {
                return "text/html";
            }
            return str;
        }
        catch (Exception exception) {
            return "text/html";
        }
    }

    protected void setContentLanguageParameter(FileObject fob, String parameter) {
        try {
            fob.setAttribute(EA_CONTENT_LANGUAGE, (Object)parameter);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Identification {
        String name = "";
        WebStandardData.WebModule webModule = null;

        Identification(String name, WebStandardData.WebModule webModule) {
            this.name = name;
            this.webModule = webModule;
        }

        String getName() {
            return this.name;
        }

        WebStandardData.WebModule getWebModule() {
            return this.webModule;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof Identification) {
                Identification id = (Identification)obj;
                if ((id.name == null && this.name == null || id.name.equals(this.name)) && (id.webModule == null && this.webModule == null || id.webModule.equals(this.webModule))) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return (this.name == null ? "unknown".hashCode() : this.name.hashCode()) + (this.webModule == null ? "unknown".hashCode() : this.webModule.hashCode());
        }
    }
}

