/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webdata;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.j2ee.server.Server;
import org.netbeans.modules.j2ee.server.datamodel.FileArchiveResource;
import org.netbeans.modules.j2ee.server.datamodel.J2eeAppStandardData;
import org.netbeans.modules.j2ee.server.datamodel.WebChangeEvent;
import org.netbeans.modules.j2ee.server.datamodel.WebChangeListener;
import org.netbeans.modules.j2ee.server.datamodel.WebStandardData;
import org.netbeans.modules.web.context.WebContextObject;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.netbeans.modules.web.core.jsploader.ServletDataObject;
import org.netbeans.modules.web.webdata.CustomDataCookie;
import org.netbeans.modules.web.webdata.FileArchiveResourceImpl;
import org.netbeans.modules.web.webdata.WebDDDataImpl;
import org.netbeans.modules.web.webdata.WebDataFactory;
import org.netbeans.modules.web.webdata.WebJarImpl;
import org.netbeans.modules.web.webdata.WebJspImpl;
import org.netbeans.modules.web.webdata.WebResourceExtImpl;
import org.netbeans.modules.web.webdata.WebServletImpl;
import org.openide.ErrorManager;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class WebModuleImpl
extends WebResourceExtImpl
implements WebStandardData.WebModule {
    protected Set webChangeListeners = null;
    private FileChangeListener fcl = new WebModuleFileChangeListener();
    boolean noInit = true;
    static /* synthetic */ Class class$org$netbeans$modules$web$webdata$CustomDataCookie;

    public WebModuleImpl(FileObject fileObject) {
        super(fileObject);
        this.init();
    }

    public void init() {
        FileObject webinf;
        if (this.noInit && (webinf = this.fileObject.getFileObject("WEB-INF")) != null) {
            FileObject webXML;
            FileObject lib = webinf.getFileObject("lib");
            if (lib != null) {
                lib.addFileChangeListener(this.fcl);
            }
            if ((webXML = webinf.getFileObject("web.xml")) != null) {
                webXML.addFileChangeListener(this.fcl);
            }
            this.noInit = false;
        }
    }

    public FileArchiveResource getResource(Server server, J2eeAppStandardData appData) {
        try {
            return WebContextObject.getPackager().getResource((WebContextObject)DataObject.find((FileObject)this.fileObject), server, appData);
        }
        catch (DataObjectNotFoundException donfe) {
            return new FileArchiveResourceImpl(this.fileObject);
        }
    }

    public File getDocumentBase() {
        return NbClassPath.toFile((FileObject)this.fileObject);
    }

    public void customDataModified() {
        FileObject fileObj = null;
        try {
            FileSystem fs = this.fileObject.getFileSystem();
            fileObj = fs.find("WEB-INF", "web", "xml");
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        try {
            DataObject dd = DataObject.find(fileObj);
            CustomDataCookie cookie = (CustomDataCookie)dd.getCookie(class$org$netbeans$modules$web$webdata$CustomDataCookie == null ? (class$org$netbeans$modules$web$webdata$CustomDataCookie = WebModuleImpl.class$("org.netbeans.modules.web.webdata.CustomDataCookie")) : class$org$netbeans$modules$web$webdata$CustomDataCookie);
            if (cookie != null) {
                cookie.customDataChanged();
            }
        }
        catch (DataObjectNotFoundException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
    }

    public WebStandardData.WebModule getWebModule() {
        return this;
    }

    public WebStandardData.WebResource findResource(String s) {
        return WebDataFactory.getFactory().findResource(s, this);
    }

    public WebStandardData.WebJsp[] getJsps() {
        FileObject[] files = this.fileObject.getChildren();
        ArrayList<WebJspImpl> list = new ArrayList<WebJspImpl>();
        int i = 0;
        while (i < files.length) {
            try {
                DataObject dob = DataObject.find((FileObject)files[i]);
                if (dob instanceof JspDataObject) {
                    list.add(WebDataFactory.getFactory().getWebJsp(files[i].getPackageNameExt('/', '.'), this));
                }
            }
            catch (DataObjectNotFoundException e) {
                // empty catch block
            }
            ++i;
        }
        WebStandardData.WebJsp[] ret = new WebJspImpl[list.size()];
        list.toArray(ret);
        return ret;
    }

    public WebStandardData.WebServlet[] getServlets() {
        FileObject[] files = this.fileObject.getChildren();
        ArrayList<WebServletImpl> list = new ArrayList<WebServletImpl>();
        int i = 0;
        while (i < files.length) {
            try {
                DataObject dob = DataObject.find((FileObject)files[i]);
                if (dob instanceof ServletDataObject) {
                    list.add(WebDataFactory.getFactory().getWebServlet(files[i].getPackageNameExt('/', '.'), this));
                }
            }
            catch (DataObjectNotFoundException e) {
                // empty catch block
            }
            ++i;
        }
        WebStandardData.WebServlet[] ret = new WebServletImpl[list.size()];
        list.toArray(ret);
        return ret;
    }

    public WebStandardData.WebJar[] getJars() {
        FileObject[] files = this.fileObject.getChildren();
        ArrayList<WebStandardData.WebJar> list = new ArrayList<WebStandardData.WebJar>();
        int i = 0;
        while (i < files.length) {
            if ("jar".equals(files[i].getExt())) {
                list.add(WebDataFactory.getFactory().getWebJar(files[i]));
            }
            ++i;
        }
        WebStandardData.WebJar[] ret = new WebJarImpl[list.size()];
        list.toArray(ret);
        return ret;
    }

    public WebStandardData.WebDDData getDD() {
        return (WebStandardData.WebDDData)this.findResource("WEB-INF/web.xml");
    }

    public void addWebChangeListener(WebChangeListener l) {
        if (this.webChangeListeners == null) {
            WebModuleImpl webModuleImpl = this;
            synchronized (webModuleImpl) {
                if (this.webChangeListeners == null) {
                    this.webChangeListeners = new HashSet(5);
                }
            }
        }
        this.webChangeListeners.add(l);
    }

    public void removeWebChangeListener(WebChangeListener l) {
        if (this.webChangeListeners != null) {
            this.webChangeListeners.remove(l);
        }
    }

    public void fireWebModuleChanged(int event, int type, WebStandardData data) {
        WebChangeEvent wce = new WebChangeEvent(event, type, data);
        if (this.webChangeListeners != null) {
            Iterator it = this.webChangeListeners.iterator();
            while (it.hasNext()) {
                ((WebChangeListener)it.next()).fireWebChangeEvent(wce);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class WebModuleFileChangeListener
    implements FileChangeListener {
        WebModuleFileChangeListener() {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
            this.fireEvent(fe);
        }

        public void fileDataCreated(FileEvent fe) {
            this.fireEvent(fe);
        }

        public void fileDeleted(FileEvent fe) {
            this.fireEvent(fe);
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.fireEvent((FileEvent)fe);
        }

        private void fireEvent(FileEvent fe) {
            FileObject fo = fe.getFile();
            String name = fo.getPackageNameExt('/', '.');
            if (name.endsWith(".jar")) {
                WebStandardData.WebJar wsd = WebDataFactory.getFactory().getWebJar(fo);
                this.fireEvent((WebStandardData)wsd, 4, fo);
            } else if (name.endsWith("WEB-INF/web.xml")) {
                WebDDDataImpl wsd = WebDataFactory.getFactory().getWebDDData(fo);
                this.fireEvent((WebStandardData)wsd, 6, fo);
            }
        }

        private void fireEvent(WebStandardData wsd, int event, FileObject fo) {
            WebModuleImpl webModule = WebDataFactory.getFactory().findWebModule(fo);
            if (webModule != null && wsd != null) {
                webModule.fireWebModuleChanged(2, event, wsd);
            }
        }
    }
}

