/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.gj;

import java.util.LinkedList;
import java.util.Stack;
import org.netbeans.lib.javac.v8.code.Symbol;
import org.netbeans.lib.javac.v8.parser.JavaDocComment;
import org.netbeans.lib.javac.v8.tree.Tree;
import org.netbeans.lib.javac.v8.util.List;
import org.netbeans.lib.javac.v8.util.Name;
import org.netbeans.lib.javac.v8.util.Names;
import org.netbeans.lib.javac.v8.util.Position;
import org.netbeans.modules.java.ElementFactory;
import org.netbeans.modules.java.parser.ParseObjectRequest;
import org.openide.src.Identifier;
import org.openide.src.Import;
import org.openide.src.MethodParameter;
import org.openide.src.Type;

class V8TreeTranslator
extends Tree.Visitor {
    private static final int EDITABLE_MASK = 1535;
    ElementFactory.Item currentClass = null;
    Tree.ClassDef currentClassDef = null;
    Tree.TopLevel currentTopLevel = null;
    int currentDepth = 1;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_FIELDS = false;
    Stack classes = new Stack();
    ElementFactory factory;
    char[] inputBuffer;
    int[] lines;
    ElementFactory.Item previousField;

    V8TreeTranslator(char[] cArray, ParseObjectRequest parseObjectRequest) {
        this.factory = parseObjectRequest.getFactory();
        this.inputBuffer = cArray;
        this.lines = this.createLineInfo(cArray);
    }

    void process(Tree.TopLevel topLevel) {
        if (topLevel == null) {
            return;
        }
        try {
            topLevel.visit((Tree.Visitor)this);
        }
        catch (InternalError internalError) {
            internalError.printStackTrace();
            System.out.println("*** error parsing class " + this.currentClassDef.sym.fullName().toString());
            throw internalError;
        }
    }

    private int[] createLineInfo(char[] cArray) {
        int[] nArray = new int[200];
        int n = 1;
        nArray[0] = 0;
        nArray[1] = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == '\n') {
                if (++n == nArray.length) {
                    int[] nArray2 = new int[nArray.length * 2];
                    System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                    nArray = nArray2;
                }
                nArray[n] = n2 + 1;
            }
            ++n2;
        }
        return nArray;
    }

    protected int getOffset(int n) {
        int n2 = Position.line((int)n);
        int n3 = Position.column((int)n);
        return this.lines[n2] + n3 - 1;
    }

    private String getString(int n, int n2) {
        return String.copyValueOf(this.inputBuffer, n, n2 - n + 1);
    }

    private String getString(int n) {
        return String.copyValueOf(this.inputBuffer, n, this.inputBuffer.length - n + 1);
    }

    JavaDocComment getJavaDoc(Tree tree) {
        if (this.currentTopLevel == null || this.currentTopLevel.docComments == null) {
            return null;
        }
        return (JavaDocComment)this.currentTopLevel.docComments.get((Object)tree);
    }

    static String bounds(int n, int n2) {
        return V8TreeTranslator.position(n) + "-" + V8TreeTranslator.position(n2);
    }

    static String position(int n) {
        return "[" + Position.line((int)n) + "," + Position.column((int)n) + "]";
    }

    public void _case(Tree.TopLevel topLevel) {
        this.currentTopLevel = topLevel;
        if (topLevel.packge != Symbol.emptyPackage && topLevel.packge != null && topLevel.packge != Symbol.noSymbol) {
            this.factory.createPackage(Identifier.create((String)topLevel.packge.fullName().toString()), this.getOffset(topLevel.pos), this.getOffset(topLevel.packageEnd));
        } else {
            this.factory.createPackage(null, 0, 0);
        }
        List list = topLevel.defs;
        while (list.nonEmpty()) {
            ((Tree)list.head).visit((Tree.Visitor)this);
            list = list.tail;
        }
    }

    public void _case(Tree.Import import_) {
        Tree.Select select;
        Tree tree = import_.qualid;
        boolean bl = false;
        if (tree instanceof Tree.Select) {
            select = (Tree.Select)tree;
            if (select.name == Names.asterisk) {
                bl = true;
                tree = select.selected;
            }
        }
        if ((select = this.createIdentifier(tree, false)) == null) {
            return;
        }
        this.factory.createImport(new Import((Identifier)select, bl), this.getOffset(import_.pos), this.getOffset(import_.importEnd));
    }

    public void _case(Tree.ClassDef classDef) {
        if (classDef.sym == null || classDef.sym == Symbol.errSymbol || classDef.sym == Symbol.noSymbol) {
            return;
        }
        Identifier identifier = Identifier.create((String)classDef.sym.fullName().toString(), (String)classDef.name.toString());
        int n = classDef.flags & 0x5FF;
        Identifier identifier2 = null;
        boolean bl = false;
        if (classDef.extending != null && classDef.tag == 40) {
            bl = true;
        } else {
            identifier2 = this.createIdentifier(classDef.extending, true);
        }
        LinkedList<Identifier> linkedList = new LinkedList<Identifier>();
        boolean bl2 = false;
        List list = classDef.implementing;
        while (list.nonEmpty()) {
            if (((Tree)list.head).tag == 40) {
                bl = true;
            } else {
                linkedList.add(this.createIdentifier((Tree)list.head, false));
            }
            list = list.tail;
        }
        Identifier[] identifierArray = linkedList.toArray(new Identifier[linkedList.size()]);
        ElementFactory.Item item = this.factory.createClass((classDef.flags & 0x200) > 0, n, identifier, identifier2, identifierArray);
        if (bl) {
            this.factory.markError(item);
        }
        int n2 = this.getOffset(classDef.headerEndPos);
        int n3 = this.getOffset(classDef.bodyEndPos);
        JavaDocComment javaDocComment = this.getJavaDoc((Tree)classDef);
        int n4 = this.getOffset(classDef.modifierPos);
        this.factory.setHeaderBounds(item, n4, n2);
        this.factory.setBodyBounds(item, this.getOffset(classDef.bodyStartPos) + 1, n3 - 1);
        if (javaDocComment == null) {
            this.factory.setDocumentation(item, -1, -1, null);
            this.factory.setBounds(item, n4, n3);
        } else {
            int n5 = this.getOffset(javaDocComment.getStartPosition());
            this.factory.setDocumentation(item, n5, this.getOffset(javaDocComment.getEndPosition()), javaDocComment.getComment());
            this.factory.setBounds(item, n5, n3);
        }
        this.classes.push(item);
        this.factory.setParent(item, this.currentClass);
        ElementFactory.Item item2 = this.currentClass;
        Tree.ClassDef classDef2 = this.currentClassDef;
        this.currentClass = item;
        this.currentClassDef = classDef;
        ++this.currentDepth;
        List list2 = classDef.defs;
        while (list2.nonEmpty()) {
            switch (((Tree)list2.head).tag) {
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    ((Tree)list2.head).visit((Tree.Visitor)this);
                    break;
                }
            }
            list2 = list2.tail;
        }
        --this.currentDepth;
        this.currentClass = item2;
        this.currentClassDef = classDef2;
    }

    public void _case(Tree.Block block) {
        if (this.currentClass == null) {
            return;
        }
        if (block.endpos == 0) {
            return;
        }
        int n = this.getOffset(block.modifierPos);
        int n2 = this.getOffset(block.pos + 1);
        int n3 = this.getOffset(block.endpos);
        ElementFactory.Item item = this.factory.createInitializer(block.flags & 8);
        JavaDocComment javaDocComment = this.getJavaDoc((Tree)block);
        this.factory.setHeaderBounds(item, n, n2 - 1);
        this.factory.setBodyBounds(item, n2, n3);
        if (javaDocComment == null) {
            this.factory.setDocumentation(item, -1, -1, null);
            this.factory.setBounds(item, n, n3 + 1);
        } else {
            int n4 = this.getOffset(javaDocComment.getStartPosition());
            this.factory.setDocumentation(item, n4, this.getOffset(javaDocComment.getEndPosition()), javaDocComment.getComment());
            this.factory.setBounds(item, n4, n3 + 1);
        }
        this.factory.setParent(item, this.currentClass);
    }

    public void _case(Tree.MethodDef methodDef) {
        int n;
        ElementFactory.Item item;
        Identifier identifier;
        List list;
        Identifier[] identifierArray;
        if (this.currentClass == null) {
            return;
        }
        if (methodDef.pos == this.currentClassDef.pos) {
            return;
        }
        if (methodDef.name == Names.any || methodDef.name == Names.error) {
            return;
        }
        boolean bl = methodDef.name == Names.init;
        MethodParameter[] methodParameterArray = new MethodParameter[methodDef.params.length()];
        int n2 = 0;
        List list2 = methodDef.params;
        while (list2.nonEmpty()) {
            identifierArray = (Identifier[])list2.head;
            if (identifierArray.vartype == null) {
                return;
            }
            list = this.createType(identifierArray.vartype);
            if (list == null) {
                return;
            }
            methodParameterArray[n2++] = new MethodParameter(identifierArray.name.toString(), (Type)list, (identifierArray.flags & 0x10) != 0);
            list2 = list2.tail;
        }
        identifierArray = new Identifier[methodDef.thrown.length()];
        n2 = 0;
        list = methodDef.thrown;
        while (list.nonEmpty()) {
            identifier = this.createIdentifier((Tree)list.head, false);
            if (identifier == null) {
                return;
            }
            identifierArray[n2++] = identifier;
            list = list.tail;
        }
        if (bl) {
            item = this.factory.createConstructor(methodDef.flags & 0x5FF, Identifier.create((String)this.currentClassDef.name.toString()), methodParameterArray, identifierArray);
        } else {
            if (methodDef.restype == null || methodDef.name == null) {
                return;
            }
            identifier = this.createType(methodDef.restype);
            if (identifier == null) {
                return;
            }
            item = this.factory.createMethod(methodDef.flags & 0x5FF, Identifier.create((String)methodDef.name.toString()), (Type)identifier, methodParameterArray, identifierArray);
        }
        int n3 = this.getOffset(methodDef.headerBeginPos);
        int n4 = this.getOffset(methodDef.headerEndPos);
        this.factory.setHeaderBounds(item, n3, n4);
        if (methodDef.body == null) {
            n = n4 + 1;
        } else {
            n = this.getOffset(methodDef.body.endpos) + 1;
            this.factory.setBodyBounds(item, this.getOffset(methodDef.body.pos) + 1, n - 1);
        }
        JavaDocComment javaDocComment = this.getJavaDoc((Tree)methodDef);
        if (javaDocComment == null) {
            this.factory.setDocumentation(item, -1, -1, null);
            this.factory.setBounds(item, n3, n);
        } else {
            int n5 = this.getOffset(javaDocComment.getStartPosition());
            this.factory.setDocumentation(item, n5, this.getOffset(javaDocComment.getEndPosition()), javaDocComment.getComment());
            this.factory.setBounds(item, n5, n);
        }
        this.factory.setParent(item, this.currentClass);
    }

    public void _case(Tree.VarDef varDef) {
        String string;
        if (this.currentClass == null) {
            return;
        }
        String string2 = varDef.name.toString();
        if (varDef.name == Names.any || varDef.name == Names.error) {
            return;
        }
        if (varDef.vartype == null) {
            return;
        }
        Type type = this.createType(varDef.vartype);
        if (type == null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        int n2 = -1;
        int n3 = this.getOffset(varDef.modifierPos);
        int n4 = this.getOffset(varDef.pos);
        int n5 = this.getOffset(varDef.endPos);
        int n6 = this.getOffset(varDef.headerEnd);
        if (varDef.init != null) {
            int n7 = this.getOffset(varDef.initStart);
            n = this.getOffset(varDef.headerEnd);
            n2 = n5;
            string = this.getString(n7, n2 - 1);
        } else {
            string = "";
        }
        ElementFactory.Item item = this.factory.createField(varDef.flags & 0x5FF, Identifier.create((String)string2), type, string);
        if (varDef.prevChain == null) {
            if (varDef.nextChain != null) {
                bl = true;
                this.factory.setFieldTypeBounds(item, n3, n4 - 1);
                this.factory.setHeaderBounds(item, n4, n6);
                this.previousField = item;
            } else {
                this.factory.setHeaderBounds(item, n3, n6);
                this.previousField = null;
            }
        } else {
            this.factory.setPrecedingField(item, this.previousField);
            this.factory.setHeaderBounds(item, n4, n6);
            bl2 = true;
            this.previousField = item;
        }
        if (varDef.init == null) {
            this.factory.setBodyBounds(item, n5, n5);
        } else {
            this.factory.setBodyBounds(item, n, n2);
        }
        JavaDocComment javaDocComment = this.getJavaDoc((Tree)varDef);
        if (bl2) {
            this.factory.setBounds(item, n4, n5 + 1);
        } else if (javaDocComment == null) {
            if (!bl) {
                this.factory.setBounds(item, n3, n5 + 1);
            }
            this.factory.setDocumentation(item, -1, -1, null);
        } else {
            int n8 = this.getOffset(javaDocComment.getStartPosition());
            this.factory.setDocumentation(item, n8, this.getOffset(javaDocComment.getEndPosition()), javaDocComment.getComment());
            if (!bl) {
                this.factory.setBounds(item, n8, n5 + 1);
            }
        }
        if (bl) {
            this.factory.setBounds(item, n4, n5 + 1);
        }
        this.factory.setParent(item, this.currentClass);
    }

    public void _case(Tree.Erroneous erroneous) {
        this.factory.markError(null);
    }

    private Type createType(Tree tree) {
        if (tree == null) {
            throw new InternalError("NULL pointer");
        }
        switch (tree.tag) {
            case 33: 
            case 34: {
                Identifier identifier = this.createIdentifier(tree, true);
                return identifier == null ? null : Type.createClass((Identifier)identifier);
            }
            case 36: {
                Tree.TypeIdent typeIdent = (Tree.TypeIdent)tree;
                switch (typeIdent.typetag) {
                    case 1: {
                        return Type.BYTE;
                    }
                    case 2: {
                        return Type.CHAR;
                    }
                    case 3: {
                        return Type.SHORT;
                    }
                    case 4: {
                        return Type.INT;
                    }
                    case 5: {
                        return Type.LONG;
                    }
                    case 6: {
                        return Type.FLOAT;
                    }
                    case 7: {
                        return Type.DOUBLE;
                    }
                    case 8: {
                        return Type.BOOLEAN;
                    }
                    case 9: {
                        return Type.VOID;
                    }
                }
                throw new InternalError("Neznamej prim. type:" + typeIdent.typetag);
            }
            case 37: {
                Tree.TypeArray typeArray = (Tree.TypeArray)tree;
                Type type = this.createType(typeArray.elemtype);
                return type == null ? null : Type.createArray((Type)type);
            }
            case 38: {
                Tree.TypeApply typeApply = (Tree.TypeApply)tree;
                return this.createType(typeApply.clazz);
            }
            case 39: {
                System.out.println("Found typeParameter!");
                Throwable throwable = new Throwable();
                throwable.fillInStackTrace();
                throwable.printStackTrace();
            }
            case 40: {
                return null;
            }
        }
        System.out.println("NEVIM: (" + tree.tag + ")");
        throw new InternalError("neznamej type");
    }

    protected Identifier createIdentifier(Tree tree, boolean bl) {
        if (tree == null) {
            if (bl) {
                return null;
            }
            throw new InternalError("NULL pointer");
        }
        switch (tree.tag) {
            case 34: {
                int n;
                Name name;
                Tree.Ident ident = (Tree.Ident)tree;
                if (ident.name == Names.any || ident.name == Names.error) {
                    return null;
                }
                if (ident.sym == null || ident.sym == Symbol.errSymbol || ident.sym == Symbol.noSymbol || ident.type.isErroneous()) {
                    name = ident.name;
                    n = 2;
                } else {
                    name = ident.sym.fullName();
                    n = 1;
                }
                try {
                    return Identifier.create((String)name.toString(), (String)ident.name.toString(), (int)n);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
            }
            case 33: {
                int n;
                Object object;
                Tree.Select select = (Tree.Select)tree;
                Tree tree2 = select.selected;
                String string = select.name.toString();
                boolean bl2 = select.sym == null || select.sym == Symbol.errSymbol || select.sym == Symbol.noSymbol || select.type.isErroneous();
                while (tree2.tag == 33) {
                    object = (Tree.Select)tree2;
                    if (object.name == Names.error || object.name == Names.any) {
                        return null;
                    }
                    string = object.name.toString() + "." + string;
                    tree2 = object.selected;
                }
                if (tree2.tag == 34) {
                    object = (Tree.Ident)tree2;
                    if (bl2 && object.sym != null && object.sym.kind == 4) {
                        return null;
                    }
                    string = object.name.toString() + "." + string;
                } else {
                    string = select.name.toString();
                }
                if (bl2) {
                    object = string;
                    n = 2;
                } else {
                    object = select.sym.fullName().toString();
                    n = 1;
                }
                try {
                    return Identifier.create((String)object, (String)string, (int)n);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
            }
            case 38: {
                Tree.TypeApply typeApply = (Tree.TypeApply)tree;
                return this.createIdentifier(typeApply.clazz, false);
            }
            case 36: 
            case 40: {
                return null;
            }
        }
        System.out.println("NEVIM: (" + tree.tag + ")");
        throw new InternalError("neznamej token");
    }
}

