/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.classfile.Access;
import org.netbeans.modules.classfile.CPClassInfo;
import org.netbeans.modules.classfile.CPUTF8Info;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.InnerClass;
import org.netbeans.modules.classfile.Method;
import org.netbeans.modules.classfile.Variable;

public class ClassFile {
    ConstantPool constantPool;
    int classAccess;
    CPClassInfo classInfo;
    CPClassInfo superClassInfo;
    CPClassInfo[] interfaces;
    Variable[] variables;
    Method[] methods;
    String sourceFileName;
    boolean deprecated = false;
    boolean synthetic = false;
    InnerClass[] innerClasses;
    private HashMap attributes;
    short majorVersion;
    short minorVersion;
    private static final int BUFFER_SIZE = 4096;
    static /* synthetic */ Class class$org$netbeans$modules$classfile$CPClassInfo;

    public ClassFile(InputStream classData) throws IOException {
        this(classData, true);
    }

    public ClassFile(String classFileName) throws IOException {
        this(classFileName, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ClassFile(File file, boolean includeCode) throws IOException {
        BufferedInputStream is = null;
        if (file == null || !file.exists()) {
            throw new IOException("File name is invalid or file not exists");
        }
        try {
            is = new BufferedInputStream(new FileInputStream(file), 4096);
            this.load(is, includeCode);
            Object var5_4 = null;
            if (is == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (is == null) throw throwable;
            ((InputStream)is).close();
            throw throwable;
        }
        ((InputStream)is).close();
    }

    public ClassFile(InputStream classData, boolean includeCode) throws IOException {
        if (classData == null) {
            throw new IOException("input stream not specified");
        }
        this.load(classData, includeCode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ClassFile(String classFileName, boolean includeCode) throws IOException {
        InputStream in = null;
        try {
            if (classFileName == null) {
                throw new IOException("input stream not specified");
            }
            in = new BufferedInputStream(new FileInputStream(classFileName), 4096);
            this.load(in, includeCode);
            Object var5_4 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (in == null) throw throwable;
            in.close();
            throw throwable;
        }
        in.close();
    }

    public final ConstantPool getConstantPool() {
        return this.constantPool;
    }

    private void load(InputStream classData, boolean includeCode) throws IOException {
        try {
            DataInputStream in = new DataInputStream(classData);
            if (in == null) {
                throw new IOException("invalid class format");
            }
            this.constantPool = this.loadClassHeader(in);
            this.interfaces = ClassFile.getCPClassList(in, this.constantPool);
            this.variables = Variable.loadFields(in, this.constantPool, this);
            this.methods = Method.loadMethods(in, this.constantPool, this, includeCode);
            this.loadAttributes(in, this.constantPool);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new IOException("invalid class format");
        }
    }

    private ConstantPool loadClassHeader(DataInputStream in) throws IOException {
        int magic = in.readInt();
        if (magic != -889275714) {
            throw new IOException("invalid class format");
        }
        this.minorVersion = in.readShort();
        this.majorVersion = in.readShort();
        short count = in.readShort();
        ConstantPool pool = new ConstantPool(count, in);
        this.classAccess = in.readUnsignedShort();
        this.classInfo = pool.getClass(in.readUnsignedShort());
        if (this.classInfo == null) {
            throw new IOException("invalid class format");
        }
        int index = in.readUnsignedShort();
        if (index != 0) {
            this.superClassInfo = pool.getClass(index);
        }
        return pool;
    }

    static CPClassInfo[] getCPClassList(DataInputStream in, ConstantPool pool) throws IOException {
        int count = in.readUnsignedShort();
        CPClassInfo[] classes = new CPClassInfo[count];
        int i = 0;
        while (i < count) {
            classes[i] = pool.getClass(in.readUnsignedShort());
            ++i;
        }
        return classes;
    }

    private void loadAttributes(DataInputStream in, ConstantPool pool) throws IOException {
        int count = in.readUnsignedShort();
        this.attributes = new HashMap(count + 1, 1.0f);
        int i = 0;
        while (i < count) {
            CPUTF8Info entry;
            try {
                entry = (CPUTF8Info)pool.get(in.readUnsignedShort());
            }
            catch (ClassCastException e) {
                throw new IOException("invalid constant pool entry");
            }
            int len = in.readInt();
            String name = entry.getName();
            if (name.equals("Deprecated")) {
                this.attributes.put(name, null);
                this.deprecated = true;
            } else if (name.equals("Synthetic")) {
                this.attributes.put(name, null);
                this.synthetic = true;
            } else if (name.equals("SourceFile")) {
                try {
                    entry = (CPUTF8Info)pool.get(in.readUnsignedShort());
                }
                catch (ClassCastException e) {
                    throw new IOException("invalid constant pool entry");
                }
                this.sourceFileName = entry.getName();
                this.attributes.put(name, this.sourceFileName);
            } else if (name.equals("InnerClasses")) {
                this.innerClasses = InnerClass.loadInnerClasses(in, pool);
                this.attributes.put(name, this.innerClasses);
            } else {
                ClassFile.skip(in, len);
                this.attributes.put(name, null);
            }
            ++i;
        }
        if (this.innerClasses == null) {
            this.innerClasses = new InnerClass[0];
        }
    }

    /*
     * WARNING - void declaration
     */
    static void skip(InputStream in, int len) throws IOException {
        int n;
        while ((n = (int)in.skip(len)) > 0 && n < len) {
            void var2_2;
            len -= var2_2;
        }
    }

    public final int getAccess() {
        return this.classAccess;
    }

    public final ClassName getName() {
        return this.classInfo.getClassName();
    }

    public final ClassName getSuperClass() {
        if (this.superClassInfo == null) {
            return null;
        }
        return this.superClassInfo.getClassName();
    }

    public final Collection getInterfaces() {
        ArrayList<ClassName> l = new ArrayList<ClassName>();
        int n = this.interfaces.length;
        int i = 0;
        while (i < n) {
            l.add(this.interfaces[i].getClassName());
            ++i;
        }
        return l;
    }

    public final Variable getVariable(String name) {
        int n = this.variables.length;
        int i = 0;
        while (i < n) {
            Variable v = this.variables[i];
            if (v.getName().equals(name)) {
                return v;
            }
            ++i;
        }
        return null;
    }

    public final Collection getVariables() {
        return Arrays.asList(this.variables);
    }

    public final int getVariableCount() {
        return this.variables.length;
    }

    public final Method getMethod(String name, String signature) {
        int n = this.methods.length;
        int i = 0;
        while (i < n) {
            Method m = this.methods[i];
            if (m.getName().equals(name) && m.getDescriptor().equals(signature)) {
                return m;
            }
            ++i;
        }
        return null;
    }

    public final Collection getMethods() {
        return Arrays.asList(this.methods);
    }

    public final int getMethodCount() {
        return this.methods.length;
    }

    public final String getSourceFileName() {
        return this.sourceFileName;
    }

    public final boolean isDeprecated() {
        return this.deprecated;
    }

    public final boolean isSynthetic() {
        return this.synthetic;
    }

    public final Map getAttributes() {
        return this.attributes;
    }

    public final Collection getInnerClasses() {
        return Arrays.asList(this.innerClasses);
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public final Set getAllClassNames() {
        HashSet<ClassName> set = new HashSet<ClassName>();
        Collection c = this.constantPool.getAllConstants(class$org$netbeans$modules$classfile$CPClassInfo == null ? (class$org$netbeans$modules$classfile$CPClassInfo = ClassFile.class$("org.netbeans.modules.classfile.CPClassInfo")) : class$org$netbeans$modules$classfile$CPClassInfo);
        Iterator i = c.iterator();
        while (i.hasNext()) {
            CPClassInfo ci = (CPClassInfo)i.next();
            set.add(ci.getClassName());
        }
        int i2 = 0;
        while (i2 < this.variables.length) {
            this.addClassNames(set, this.variables[i2].getDescriptor());
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.methods.length) {
            this.addClassNames(set, this.methods[i3].getDescriptor());
            ++i3;
        }
        return Collections.unmodifiableSet(set);
    }

    private void addClassNames(Set set, String type) {
        int i = 0;
        while ((i = type.indexOf(76, i)) != -1) {
            int j = type.indexOf(59, i);
            if (j <= i) break;
            String classType = type.substring(i + 1, j);
            set.add(ClassName.getClassName(classType));
            i = j + 1;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ClassFile: ");
        sb.append(Access.toString(this.classAccess));
        sb.append(' ');
        sb.append(this.classInfo);
        if (this.synthetic) {
            sb.append(" (synthetic)");
        }
        if (this.deprecated) {
            sb.append(" (deprecated)");
        }
        sb.append("\n   source: ");
        sb.append(this.sourceFileName);
        sb.append("\n   super: ");
        sb.append(this.superClassInfo);
        sb.append("\n   ");
        if (this.interfaces.length > 0) {
            sb.append(this.arrayToString("interfaces", this.interfaces));
            sb.append("\n   ");
        }
        if (this.innerClasses.length > 0) {
            sb.append(this.arrayToString("innerclasses", this.innerClasses));
            sb.append("\n   ");
        }
        if (this.variables.length > 0) {
            sb.append(this.arrayToString("variables", this.variables));
            sb.append("\n   ");
        }
        if (this.methods.length > 0) {
            sb.append(this.arrayToString("methods", this.methods));
        }
        return sb.toString();
    }

    private String arrayToString(String name, Object[] array) {
        StringBuffer sb = new StringBuffer();
        sb.append(name);
        sb.append(": ");
        int n = array.length;
        if (n > 0) {
            int i = 0;
            do {
                sb.append("\n      ");
                sb.append(array[i++].toString());
            } while (i < n);
        } else {
            sb.append("none");
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

