/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.WeakHashMap;

public final class ClassName
implements Comparable,
Comparator,
Serializable {
    static final long serialVersionUID = -8444469778945723553L;
    private final String type;
    private transient String internalName;
    private transient String externalName;
    private transient String packageName;
    private transient String simpleName;
    private transient int hash = -1;
    private static final WeakHashMap cache = new WeakHashMap();

    public static ClassName getClassName(String classType) {
        ClassName cn;
        if (classType == null || classType.length() == 0) {
            return null;
        }
        WeakHashMap weakHashMap = cache;
        synchronized (weakHashMap) {
            cn = (ClassName)cache.get(classType);
            if (cn == null) {
                String _type;
                int i = classType.indexOf(76);
                char lastChar = classType.charAt(classType.length() - 1);
                if (i != -1 && lastChar == ';') {
                    _type = classType.substring(i + 1, classType.length() - 1);
                    cn = (ClassName)cache.get(_type);
                    if (cn != null) {
                        ClassName className = cn;
                        return className;
                    }
                } else {
                    _type = classType;
                }
                cn = new ClassName(_type);
                cache.put(_type, cn);
            }
        }
        return cn;
    }

    private ClassName(String type) {
        this.type = type;
        int i = type.lastIndexOf(91);
        this.internalName = i > -1 ? type.substring(i + 1) : type;
    }

    public String getType() {
        return this.type;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String getExternalName() {
        return this.getExternalName(false);
    }

    public synchronized String getExternalName(boolean suppressArrays) {
        int i;
        if (this.externalName == null) {
            this.externalName = this.externalizeClassName();
        }
        if (suppressArrays && (i = this.externalName.indexOf(91)) != -1) {
            return this.externalName.substring(0, i);
        }
        return this.externalName;
    }

    public synchronized String getPackage() {
        if (this.packageName == null) {
            int i = this.internalName.lastIndexOf(47);
            this.packageName = i == -1 ? "" : this.internalName.substring(0, i).replace('/', '.');
        }
        return this.packageName;
    }

    public String getSimpleName() {
        if (this.simpleName == null) {
            String pkg = this.getPackage();
            int i = pkg.length();
            String extName = this.getExternalName();
            this.simpleName = i == 0 ? extName : extName.substring(i + 1);
        }
        return this.simpleName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof ClassName ? this.type.equals(((ClassName)obj).type) : false;
    }

    public int compareTo(Object obj) {
        return this.type.compareTo(((ClassName)obj).type);
    }

    public int compare(Object o1, Object o2) {
        return ((ClassName)o1).compareTo(o2);
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = this.type.hashCode();
        }
        return this.hash;
    }

    public String toString() {
        return this.getExternalName();
    }

    private String externalizeClassName() {
        StringBuffer sb = new StringBuffer(this.type);
        int arrays = 0;
        boolean atBeginning = true;
        int length = sb.length();
        int i = 0;
        while (i < length) {
            char ch = sb.charAt(i);
            switch (ch) {
                case '[': {
                    if (!atBeginning) break;
                    ++arrays;
                    break;
                }
                case '$': 
                case '/': {
                    sb.setCharAt(i, '.');
                    atBeginning = false;
                    break;
                }
                default: {
                    atBeginning = false;
                }
            }
            ++i;
        }
        if (arrays > 0) {
            sb.delete(0, arrays);
            int i2 = 0;
            while (i2 < arrays) {
                sb.append("[]");
                ++i2;
            }
        }
        return sb.toString();
    }

    private Object readResolve() throws ObjectStreamException {
        return ClassName.getClassName(this.internalName);
    }
}

