/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.netbeans.modules.classfile.CPUTF8Info;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.ExceptionTableEntry;
import org.netbeans.modules.classfile.LocalVariableTableEntry;

public final class Code {
    private static final boolean debug = false;
    private int maxStack;
    private int maxLocals;
    private byte[] byteCodes;
    private ExceptionTableEntry[] exceptionTable;
    private int[] lineNumberTable;
    private LocalVariableTableEntry[] localVariableTable;

    Code(DataInputStream in, ConstantPool pool) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("input stream not specified");
        }
        if (pool == null) {
            throw new IllegalArgumentException("constant pool not specified");
        }
        this.loadCode(in, pool);
    }

    private void loadCode(DataInputStream in, ConstantPool pool) throws IOException {
        this.maxStack = in.readUnsignedShort();
        this.maxLocals = in.readUnsignedShort();
        int len = in.readInt();
        this.byteCodes = new byte[len];
        in.readFully(this.byteCodes);
        this.exceptionTable = ExceptionTableEntry.loadExceptionTable(in, pool);
        this.loadCodeAttributes(in, pool);
    }

    private void loadCodeAttributes(DataInputStream in, ConstantPool pool) throws IOException {
        int count = in.readUnsignedShort();
        int i = 0;
        while (i < count) {
            CPUTF8Info entry = (CPUTF8Info)pool.get(in.readUnsignedShort());
            int len = in.readInt();
            String name = entry.getName();
            if (name.equals("LineNumberTable")) {
                this.loadLineNumberTable(in, pool);
            } else if (name.equals("LocalVariableTable")) {
                this.localVariableTable = LocalVariableTableEntry.loadLocalVariableTable(in, pool);
            } else {
                ClassFile.skip(in, len);
            }
            ++i;
        }
    }

    private void loadLineNumberTable(DataInputStream in, ConstantPool pool) throws IOException {
        int n = in.readUnsignedShort();
        this.lineNumberTable = new int[n * 2];
        int i = 0;
        while (i < n) {
            this.lineNumberTable[i * 2] = in.readUnsignedShort();
            this.lineNumberTable[i * 2 + 1] = in.readUnsignedShort();
            ++i;
        }
    }

    public final int getMaxStack() {
        return this.maxStack;
    }

    public final int getMaxLocals() {
        return this.maxLocals;
    }

    public final byte[] getByteCodes() {
        return this.byteCodes;
    }

    public final ExceptionTableEntry[] getExceptionTable() {
        return this.exceptionTable;
    }

    public final int[] getLineNumberTable() {
        return this.lineNumberTable;
    }

    public final LocalVariableTableEntry[] getLocalVariableTable() {
        return this.localVariableTable;
    }
}

